/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.scan;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.clj.fastble.callback.BleScanPresenterImp;
import com.clj.fastble.data.BleDevice;
import com.clj.fastble.scan.BleScanner;
import com.clj.fastble.utils.BleLog;
import com.clj.fastble.utils.HexUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=18)
public abstract class BleScanPresenter
implements BluetoothAdapter.LeScanCallback {
    private String[] mDeviceNames;
    private String mDeviceMac;
    private boolean mFuzzy;
    private boolean mNeedConnect;
    private long mScanTimeout;
    private BleScanPresenterImp mBleScanPresenterImp;
    private List<BleDevice> mBleDeviceList = new ArrayList<BleDevice>();
    private Handler mMainHandler = new Handler(Looper.getMainLooper());
    private HandlerThread mHandlerThread;
    private Handler mHandler;
    private boolean mHandling;

    private void handleResult(final BleDevice bleDevice) {
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                BleScanPresenter.this.onLeScan(bleDevice);
            }
        });
        this.checkDevice(bleDevice);
    }

    public void prepare(String[] names, String mac, boolean fuzzy, boolean needConnect, long timeOut, BleScanPresenterImp bleScanPresenterImp) {
        this.mDeviceNames = names;
        this.mDeviceMac = mac;
        this.mFuzzy = fuzzy;
        this.mNeedConnect = needConnect;
        this.mScanTimeout = timeOut;
        this.mBleScanPresenterImp = bleScanPresenterImp;
        this.mHandlerThread = new HandlerThread(BleScanPresenter.class.getSimpleName());
        this.mHandlerThread.start();
        this.mHandler = new ScanHandler(this.mHandlerThread.getLooper(), this);
        this.mHandling = true;
    }

    public boolean ismNeedConnect() {
        return this.mNeedConnect;
    }

    public BleScanPresenterImp getBleScanPresenterImp() {
        return this.mBleScanPresenterImp;
    }

    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (device == null) {
            return;
        }
        if (!this.mHandling) {
            return;
        }
        Message message = this.mHandler.obtainMessage();
        message.what = 0;
        message.obj = new BleDevice(device, rssi, scanRecord, System.currentTimeMillis());
        this.mHandler.sendMessage(message);
    }

    private void checkDevice(BleDevice bleDevice) {
        if (TextUtils.isEmpty((CharSequence)this.mDeviceMac) && (this.mDeviceNames == null || this.mDeviceNames.length < 1)) {
            this.correctDeviceAndNextStep(bleDevice);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mDeviceMac) && !this.mDeviceMac.equalsIgnoreCase(bleDevice.getMac())) {
            return;
        }
        if (this.mDeviceNames != null && this.mDeviceNames.length > 0) {
            AtomicBoolean equal = new AtomicBoolean(false);
            for (String name : this.mDeviceNames) {
                String remoteName = bleDevice.getName();
                if (remoteName == null) {
                    remoteName = "";
                }
                if (!(this.mFuzzy ? remoteName.contains(name) : remoteName.equals(name))) continue;
                equal.set(true);
            }
            if (!equal.get()) {
                return;
            }
        }
        this.correctDeviceAndNextStep(bleDevice);
    }

    private void correctDeviceAndNextStep(final BleDevice bleDevice) {
        if (this.mNeedConnect) {
            BleLog.i("devices detected  ------  name:" + bleDevice.getName() + "  mac:" + bleDevice.getMac() + "  Rssi:" + bleDevice.getRssi() + "  scanRecord:" + HexUtil.formatHexString(bleDevice.getScanRecord()));
            this.mBleDeviceList.add(bleDevice);
            this.mMainHandler.post(new Runnable(){

                @Override
                public void run() {
                    BleScanner.getInstance().stopLeScan();
                }
            });
        } else {
            AtomicBoolean hasFound = new AtomicBoolean(false);
            for (BleDevice result : this.mBleDeviceList) {
                if (!result.getDevice().equals((Object)bleDevice.getDevice())) continue;
                hasFound.set(true);
            }
            if (!hasFound.get()) {
                BleLog.i("device detected  ------  name: " + bleDevice.getName() + "  mac: " + bleDevice.getMac() + "  Rssi: " + bleDevice.getRssi() + "  scanRecord: " + HexUtil.formatHexString(bleDevice.getScanRecord(), true));
                this.mBleDeviceList.add(bleDevice);
                this.mMainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BleScanPresenter.this.onScanning(bleDevice);
                    }
                });
            }
        }
    }

    public final void notifyScanStarted(final boolean success) {
        this.mBleDeviceList.clear();
        this.removeHandlerMsg();
        if (success && this.mScanTimeout > 0L) {
            this.mMainHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    BleScanner.getInstance().stopLeScan();
                }
            }, this.mScanTimeout);
        }
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                BleScanPresenter.this.onScanStarted(success);
            }
        });
    }

    public final void notifyScanStopped() {
        this.mHandling = false;
        this.mHandlerThread.quit();
        this.removeHandlerMsg();
        this.mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                BleScanPresenter.this.onScanFinished(BleScanPresenter.this.mBleDeviceList);
            }
        });
    }

    public final void removeHandlerMsg() {
        this.mMainHandler.removeCallbacksAndMessages(null);
        this.mHandler.removeCallbacksAndMessages(null);
    }

    public abstract void onScanStarted(boolean var1);

    public abstract void onLeScan(BleDevice var1);

    public abstract void onScanning(BleDevice var1);

    public abstract void onScanFinished(List<BleDevice> var1);

    private static final class ScanHandler
    extends Handler {
        private final WeakReference<BleScanPresenter> mBleScanPresenter;

        ScanHandler(Looper looper, BleScanPresenter bleScanPresenter) {
            super(looper);
            this.mBleScanPresenter = new WeakReference<BleScanPresenter>(bleScanPresenter);
        }

        public void handleMessage(Message msg) {
            BleDevice bleDevice;
            BleScanPresenter bleScanPresenter = (BleScanPresenter)this.mBleScanPresenter.get();
            if (bleScanPresenter != null && msg.what == 0 && (bleDevice = (BleDevice)msg.obj) != null) {
                bleScanPresenter.handleResult(bleDevice);
            }
        }
    }
}

