/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble;

import android.annotation.TargetApi;
import android.app.Application;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.content.Context;
import android.os.Build;
import android.os.Looper;
import com.clj.fastble.bluetooth.BleBluetooth;
import com.clj.fastble.bluetooth.MultipleBluetoothController;
import com.clj.fastble.bluetooth.SplitWriter;
import com.clj.fastble.callback.BleGattCallback;
import com.clj.fastble.callback.BleIndicateCallback;
import com.clj.fastble.callback.BleMtuChangedCallback;
import com.clj.fastble.callback.BleNotifyCallback;
import com.clj.fastble.callback.BleReadCallback;
import com.clj.fastble.callback.BleRssiCallback;
import com.clj.fastble.callback.BleScanAndConnectCallback;
import com.clj.fastble.callback.BleScanCallback;
import com.clj.fastble.callback.BleWriteCallback;
import com.clj.fastble.data.BleDevice;
import com.clj.fastble.data.BleScanState;
import com.clj.fastble.exception.OtherException;
import com.clj.fastble.scan.BleScanRuleConfig;
import com.clj.fastble.scan.BleScanner;
import com.clj.fastble.utils.BleLog;
import java.util.List;
import java.util.UUID;

@TargetApi(value=18)
public class BleManager {
    private Application context;
    private BleScanRuleConfig bleScanRuleConfig;
    private BleScanner bleScanner;
    private BluetoothAdapter bluetoothAdapter;
    private MultipleBluetoothController multipleBluetoothController;
    private BluetoothManager bluetoothManager;
    public static final int DEFAULT_SCAN_TIME = 10000;
    private static final int DEFAULT_MAX_MULTIPLE_DEVICE = 7;
    private static final int DEFAULT_OPERATE_TIME = 5000;
    private static final int DEFAULT_CONNECT_RETRY_COUNT = 0;
    private static final int DEFAULT_CONNECT_RETRY_INTERVAL = 5000;
    private static final int DEFAULT_MTU = 23;
    private static final int DEFAULT_MAX_MTU = 512;
    private static final int DEFAULT_WRITE_DATA_SPLIT_COUNT = 20;
    private int maxConnectCount = 7;
    private int operateTimeout = 5000;
    private int reConnectCount = 0;
    private long reConnectInterval = 5000L;
    private int splitWriteNum = 20;

    public static BleManager getInstance() {
        return BleManagerHolder.sBleManager;
    }

    public void init(Application app) {
        if (this.context == null && app != null) {
            this.context = app;
            this.bluetoothManager = (BluetoothManager)this.context.getSystemService("bluetooth");
            if (this.bluetoothManager != null) {
                this.bluetoothAdapter = this.bluetoothManager.getAdapter();
            }
            this.multipleBluetoothController = new MultipleBluetoothController();
            this.bleScanRuleConfig = new BleScanRuleConfig();
            this.bleScanner = BleScanner.getInstance();
        }
    }

    public Context getContext() {
        return this.context;
    }

    public BluetoothManager getBluetoothManager() {
        return this.bluetoothManager;
    }

    public BluetoothAdapter getBluetoothAdapter() {
        return this.bluetoothAdapter;
    }

    public BleScanner getBleScanner() {
        return this.bleScanner;
    }

    public BleScanRuleConfig getScanRuleConfig() {
        return this.bleScanRuleConfig;
    }

    public MultipleBluetoothController getMultipleBluetoothController() {
        return this.multipleBluetoothController;
    }

    public void initScanRule(BleScanRuleConfig config) {
        this.bleScanRuleConfig = config;
    }

    public int getMaxConnectCount() {
        return this.maxConnectCount;
    }

    public BleManager setMaxConnectCount(int count) {
        if (count > 7) {
            count = 7;
        }
        this.maxConnectCount = count;
        return this;
    }

    public int getOperateTimeout() {
        return this.operateTimeout;
    }

    public BleManager setOperateTimeout(int count) {
        this.operateTimeout = count;
        return this;
    }

    public int getReConnectCount() {
        return this.reConnectCount;
    }

    public long getReConnectInterval() {
        return this.reConnectInterval;
    }

    public BleManager setReConnectCount(int count) {
        return this.setReConnectCount(count, 5000L);
    }

    public BleManager setReConnectCount(int count, long interval) {
        if (count > 10) {
            count = 10;
        }
        if (interval < 0L) {
            interval = 0L;
        }
        this.reConnectCount = count;
        this.reConnectInterval = interval;
        return this;
    }

    public int getSplitWriteNum() {
        return this.splitWriteNum;
    }

    public BleManager setSplitWriteNum(int num) {
        this.splitWriteNum = num;
        return this;
    }

    public BleManager enableLog(boolean enable) {
        BleLog.isPrint = enable;
        return this;
    }

    public void scan(BleScanCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("BleScanCallback can not be Null!");
        }
        if (!this.isBlueEnable()) {
            BleLog.e("Bluetooth not enable!");
            callback.onScanStarted(false);
            return;
        }
        UUID[] serviceUuids = this.bleScanRuleConfig.getServiceUuids();
        String[] deviceNames = this.bleScanRuleConfig.getDeviceNames();
        String deviceMac = this.bleScanRuleConfig.getDeviceMac();
        boolean fuzzy = this.bleScanRuleConfig.isFuzzy();
        long timeOut = this.bleScanRuleConfig.getScanTimeOut();
        this.bleScanner.scan(serviceUuids, deviceNames, deviceMac, fuzzy, timeOut, callback);
    }

    public void scanAndConnect(BleScanAndConnectCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("BleScanAndConnectCallback can not be Null!");
        }
        if (!this.isBlueEnable()) {
            BleLog.e("Bluetooth not enable!");
            callback.onScanStarted(false);
            return;
        }
        UUID[] serviceUuids = this.bleScanRuleConfig.getServiceUuids();
        String[] deviceNames = this.bleScanRuleConfig.getDeviceNames();
        String deviceMac = this.bleScanRuleConfig.getDeviceMac();
        boolean fuzzy = this.bleScanRuleConfig.isFuzzy();
        long timeOut = this.bleScanRuleConfig.getScanTimeOut();
        this.bleScanner.scanAndConnect(serviceUuids, deviceNames, deviceMac, fuzzy, timeOut, callback);
    }

    public BluetoothGatt connect(BleDevice bleDevice, BleGattCallback bleGattCallback) {
        if (bleGattCallback == null) {
            throw new IllegalArgumentException("BleGattCallback can not be Null!");
        }
        if (!this.isBlueEnable()) {
            BleLog.e("Bluetooth not enable!");
            bleGattCallback.onConnectFail(bleDevice, new OtherException("Bluetooth not enable!"));
            return null;
        }
        if (Looper.myLooper() == null || Looper.myLooper() != Looper.getMainLooper()) {
            BleLog.w("Be careful: currentThread is not MainThread!");
        }
        if (bleDevice != null && bleDevice.getDevice() != null) {
            BleBluetooth bleBluetooth = this.multipleBluetoothController.buildConnectingBle(bleDevice);
            boolean autoConnect = this.bleScanRuleConfig.isAutoConnect();
            return bleBluetooth.connect(bleDevice, autoConnect, bleGattCallback);
        }
        bleGattCallback.onConnectFail(bleDevice, new OtherException("Not Found Device Exception Occurred!"));
        return null;
    }

    public BluetoothGatt connect(String mac, BleGattCallback bleGattCallback) {
        BluetoothDevice bluetoothDevice = this.getBluetoothAdapter().getRemoteDevice(mac);
        BleDevice bleDevice = new BleDevice(bluetoothDevice, 0, null, 0L);
        return this.connect(bleDevice, bleGattCallback);
    }

    public void cancelScan() {
        this.bleScanner.stopLeScan();
    }

    public void notify(BleDevice bleDevice, String uuid_service, String uuid_notify, BleNotifyCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("BleNotifyCallback can not be Null!");
        }
        BleBluetooth bleBluetooth = this.multipleBluetoothController.getBleBluetooth(bleDevice);
        if (bleBluetooth == null) {
            callback.onNotifyFailure(new OtherException("This device not connect!"));
        } else {
            bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_notify).enableCharacteristicNotify(callback, uuid_notify);
        }
    }

    public void indicate(BleDevice bleDevice, String uuid_service, String uuid_indicate, BleIndicateCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("BleIndicateCallback can not be Null!");
        }
        BleBluetooth bleBluetooth = this.multipleBluetoothController.getBleBluetooth(bleDevice);
        if (bleBluetooth == null) {
            callback.onIndicateFailure(new OtherException("This device not connect!"));
        } else {
            bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_indicate).enableCharacteristicIndicate(callback, uuid_indicate);
        }
    }

    public boolean stopNotify(BleDevice bleDevice, String uuid_service, String uuid_notify) {
        BleBluetooth bleBluetooth = this.multipleBluetoothController.getBleBluetooth(bleDevice);
        if (bleBluetooth == null) {
            return false;
        }
        boolean success = bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_notify).disableCharacteristicNotify();
        if (success) {
            bleBluetooth.removeNotifyCallback(uuid_notify);
        }
        return success;
    }

    public boolean stopIndicate(BleDevice bleDevice, String uuid_service, String uuid_indicate) {
        BleBluetooth bleBluetooth = this.multipleBluetoothController.getBleBluetooth(bleDevice);
        if (bleBluetooth == null) {
            return false;
        }
        boolean success = bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_indicate).disableCharacteristicIndicate();
        if (success) {
            bleBluetooth.removeIndicateCallback(uuid_indicate);
        }
        return success;
    }

    public void write(BleDevice bleDevice, String uuid_service, String uuid_write, byte[] data, BleWriteCallback callback) {
        this.write(bleDevice, uuid_service, uuid_write, data, true, callback);
    }

    public void write(BleDevice bleDevice, String uuid_service, String uuid_write, byte[] data, boolean split, BleWriteCallback callback) {
        BleBluetooth bleBluetooth;
        if (callback == null) {
            throw new IllegalArgumentException("BleWriteCallback can not be Null!");
        }
        if (data == null) {
            BleLog.e("data is Null!");
            callback.onWriteFailure(new OtherException("data is Null!"));
            return;
        }
        if (data.length > 20) {
            BleLog.w("Be careful: data's length beyond 20! Ensure MTU higher than 23, or use spilt write!");
        }
        if ((bleBluetooth = this.multipleBluetoothController.getBleBluetooth(bleDevice)) == null) {
            callback.onWriteFailure(new OtherException("This device not connect!"));
        } else if (split && data.length > 20) {
            new SplitWriter().splitWrite(bleBluetooth, uuid_service, uuid_write, data, callback);
        } else {
            bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_write).writeCharacteristic(data, callback, uuid_write);
        }
    }

    public void read(BleDevice bleDevice, String uuid_service, String uuid_read, BleReadCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("BleReadCallback can not be Null!");
        }
        BleBluetooth bleBluetooth = this.multipleBluetoothController.getBleBluetooth(bleDevice);
        if (bleBluetooth == null) {
            callback.onReadFailure(new OtherException("This device is not connected!"));
        } else {
            bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_read).readCharacteristic(callback, uuid_read);
        }
    }

    public void readRssi(BleDevice bleDevice, BleRssiCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("BleRssiCallback can not be Null!");
        }
        BleBluetooth bleBluetooth = this.multipleBluetoothController.getBleBluetooth(bleDevice);
        if (bleBluetooth == null) {
            callback.onRssiFailure(new OtherException("This device is not connected!"));
        } else {
            bleBluetooth.newBleConnector().readRemoteRssi(callback);
        }
    }

    public void setMtu(BleDevice bleDevice, int mtu, BleMtuChangedCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("BleMtuChangedCallback can not be Null!");
        }
        if (mtu > 512) {
            BleLog.e("requiredMtu should lower than 512 !");
            callback.onSetMTUFailure(new OtherException("requiredMtu should lower than 512 !"));
            return;
        }
        if (mtu < 23) {
            BleLog.e("requiredMtu should higher than 23 !");
            callback.onSetMTUFailure(new OtherException("requiredMtu should higher than 23 !"));
            return;
        }
        BleBluetooth bleBluetooth = this.multipleBluetoothController.getBleBluetooth(bleDevice);
        if (bleBluetooth == null) {
            callback.onSetMTUFailure(new OtherException("This device is not connected!"));
        } else {
            bleBluetooth.newBleConnector().setMtu(mtu, callback);
        }
    }

    public boolean isSupportBle() {
        return Build.VERSION.SDK_INT >= 18 && this.context.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    public void enableBluetooth() {
        if (this.bluetoothAdapter != null) {
            this.bluetoothAdapter.enable();
        }
    }

    public void disableBluetooth() {
        if (this.bluetoothAdapter != null && this.bluetoothAdapter.isEnabled()) {
            this.bluetoothAdapter.disable();
        }
    }

    public boolean isBlueEnable() {
        return this.bluetoothAdapter != null && this.bluetoothAdapter.isEnabled();
    }

    public BleDevice convertBleDevice(BluetoothDevice bluetoothDevice) {
        return new BleDevice(bluetoothDevice);
    }

    @TargetApi(value=21)
    public BleDevice convertBleDevice(ScanResult scanResult) {
        if (scanResult == null) {
            throw new IllegalArgumentException("scanResult can not be Null!");
        }
        BluetoothDevice bluetoothDevice = scanResult.getDevice();
        int rssi = scanResult.getRssi();
        ScanRecord scanRecord = scanResult.getScanRecord();
        byte[] bytes = null;
        if (scanRecord != null) {
            bytes = scanRecord.getBytes();
        }
        long timestampNanos = scanResult.getTimestampNanos();
        return new BleDevice(bluetoothDevice, rssi, bytes, timestampNanos);
    }

    public BleBluetooth getBleBluetooth(BleDevice bleDevice) {
        if (this.multipleBluetoothController != null) {
            return this.multipleBluetoothController.getBleBluetooth(bleDevice);
        }
        return null;
    }

    public List<BleDevice> getAllConnectedDevice() {
        if (this.multipleBluetoothController == null) {
            return null;
        }
        return this.multipleBluetoothController.getDeviceList();
    }

    public List<BluetoothDevice> getAlreadyConnectedBluetoothDevices() {
        return this.bluetoothManager.getConnectedDevices(7);
    }

    public BluetoothGatt getBluetoothGatt(BleDevice bleDevice) {
        BleBluetooth bleBluetooth = this.getBleBluetooth(bleDevice);
        if (bleBluetooth != null) {
            return bleBluetooth.getBluetoothGatt();
        }
        return null;
    }

    public List<BluetoothGattService> getBluetoothGattServices(BleDevice bleDevice) {
        BluetoothGatt gatt = this.getBluetoothGatt(bleDevice);
        if (gatt != null) {
            return gatt.getServices();
        }
        return null;
    }

    public List<BluetoothGattCharacteristic> getBluetoothGattCharacteristics(BluetoothGattService service) {
        return service.getCharacteristics();
    }

    public void removeConnectGattCallback(BleDevice bleDevice) {
        BleBluetooth bleBluetooth = this.getBleBluetooth(bleDevice);
        if (bleBluetooth != null) {
            bleBluetooth.removeConnectGattCallback();
        }
    }

    public void removeRssiCallback(BleDevice bleDevice) {
        BleBluetooth bleBluetooth = this.getBleBluetooth(bleDevice);
        if (bleBluetooth != null) {
            bleBluetooth.removeRssiCallback();
        }
    }

    public void removeMtuChangedCallback(BleDevice bleDevice) {
        BleBluetooth bleBluetooth = this.getBleBluetooth(bleDevice);
        if (bleBluetooth != null) {
            bleBluetooth.removeMtuChangedCallback();
        }
    }

    public void removeNotifyCallback(BleDevice bleDevice, String uuid_notify) {
        BleBluetooth bleBluetooth = this.getBleBluetooth(bleDevice);
        if (bleBluetooth != null) {
            bleBluetooth.removeNotifyCallback(uuid_notify);
        }
    }

    public void removeIndicateCallback(BleDevice bleDevice, String uuid_indicate) {
        BleBluetooth bleBluetooth = this.getBleBluetooth(bleDevice);
        if (bleBluetooth != null) {
            bleBluetooth.removeIndicateCallback(uuid_indicate);
        }
    }

    public void removeWriteCallback(BleDevice bleDevice, String uuid_write) {
        BleBluetooth bleBluetooth = this.getBleBluetooth(bleDevice);
        if (bleBluetooth != null) {
            bleBluetooth.removeWriteCallback(uuid_write);
        }
    }

    public void removeReadCallback(BleDevice bleDevice, String uuid_read) {
        BleBluetooth bleBluetooth = this.getBleBluetooth(bleDevice);
        if (bleBluetooth != null) {
            bleBluetooth.removeReadCallback(uuid_read);
        }
    }

    public void clearCharacterCallback(BleDevice bleDevice) {
        BleBluetooth bleBluetooth = this.getBleBluetooth(bleDevice);
        if (bleBluetooth != null) {
            bleBluetooth.clearCharacterCallback();
        }
    }

    public BleScanState getScanSate() {
        return this.bleScanner.getScanState();
    }

    public int getConnectState(BleDevice bleDevice) {
        if (this.multipleBluetoothController != null) {
            return this.multipleBluetoothController.getConnectState(bleDevice);
        }
        return 0;
    }

    public boolean isConnected(BleDevice bleDevice) {
        return this.getConnectState(bleDevice) == 2;
    }

    public boolean isConnected(String mac) {
        List<BluetoothDevice> list = this.getAlreadyConnectedBluetoothDevices();
        for (BluetoothDevice bluetoothDevice : list) {
            if (!bluetoothDevice.getAddress().equals(mac)) continue;
            return true;
        }
        return false;
    }

    public void disconnect(BleDevice bleDevice) {
        if (this.multipleBluetoothController != null) {
            this.multipleBluetoothController.disconnect(bleDevice);
        }
    }

    public void disconnectAllDevice() {
        if (this.multipleBluetoothController != null) {
            this.multipleBluetoothController.disconnectAllDevice();
        }
    }

    public void destroy() {
        if (this.multipleBluetoothController != null) {
            this.multipleBluetoothController.destroy();
        }
    }

    private static class BleManagerHolder {
        private static final BleManager sBleManager = new BleManager();

        private BleManagerHolder() {
        }
    }
}

