/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.bluetooth;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.clj.fastble.BleManager;
import com.clj.fastble.bluetooth.BleBluetooth;
import com.clj.fastble.callback.BleWriteCallback;
import com.clj.fastble.exception.BleException;
import com.clj.fastble.exception.OtherException;
import com.clj.fastble.utils.BleLog;
import java.util.LinkedList;
import java.util.Queue;

public class SplitWriter {
    private HandlerThread mHandlerThread = new HandlerThread("splitWriter");
    private Handler mHandler;
    private BleBluetooth mBleBluetooth;
    private String mUuid_service;
    private String mUuid_write;
    private byte[] mData;
    private int mCount;
    private BleWriteCallback mCallback;
    private Queue<byte[]> mDataQueue;
    private int mTotalNum;

    public SplitWriter() {
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper()){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                if (msg.what == 51) {
                    SplitWriter.this.write();
                }
            }
        };
    }

    public void splitWrite(BleBluetooth bleBluetooth, String uuid_service, String uuid_write, byte[] data, BleWriteCallback callback) {
        this.mBleBluetooth = bleBluetooth;
        this.mUuid_service = uuid_service;
        this.mUuid_write = uuid_write;
        this.mData = data;
        this.mCount = BleManager.getInstance().getSplitWriteNum();
        this.mCallback = callback;
        this.splitWrite();
    }

    private void splitWrite() {
        if (this.mData == null) {
            throw new IllegalArgumentException("data is Null!");
        }
        if (this.mCount < 1) {
            throw new IllegalArgumentException("split count should higher than 0!");
        }
        this.mDataQueue = SplitWriter.splitByte(this.mData, this.mCount);
        this.mTotalNum = this.mDataQueue.size();
        this.write();
    }

    private void write() {
        if (this.mDataQueue.peek() == null) {
            this.release();
        } else {
            byte[] data = this.mDataQueue.poll();
            this.mBleBluetooth.newBleConnector().withUUIDString(this.mUuid_service, this.mUuid_write).writeCharacteristic(data, new BleWriteCallback(){

                @Override
                public void onWriteSuccess(int current, int total, byte[] justWrite) {
                    int position = SplitWriter.this.mTotalNum - SplitWriter.this.mDataQueue.size();
                    if (SplitWriter.this.mCallback != null) {
                        SplitWriter.this.mCallback.onWriteSuccess(position, SplitWriter.this.mTotalNum, justWrite);
                    }
                    if (Looper.myLooper() != null && Looper.myLooper() == Looper.getMainLooper()) {
                        SplitWriter.this.write();
                    } else {
                        Message message = SplitWriter.this.mHandler.obtainMessage(51);
                        SplitWriter.this.mHandler.sendMessage(message);
                    }
                }

                @Override
                public void onWriteFailure(BleException exception) {
                    if (SplitWriter.this.mCallback != null) {
                        SplitWriter.this.mCallback.onWriteFailure(new OtherException("exception occur while writing: " + exception.getDescription()));
                    }
                }
            }, this.mUuid_write);
        }
    }

    private void release() {
        this.mHandlerThread.quit();
        this.mHandler.removeCallbacksAndMessages(null);
    }

    private static Queue<byte[]> splitByte(byte[] data, int count) {
        if (count > 20) {
            BleLog.w("Be careful: split count beyond 20! Ensure MTU higher than 23!");
        }
        LinkedList<byte[]> byteQueue = new LinkedList<byte[]>();
        if (data != null) {
            int index = 0;
            do {
                byte[] newData;
                byte[] rawData = new byte[data.length - index];
                System.arraycopy(data, index, rawData, 0, data.length - index);
                if (rawData.length <= count) {
                    newData = new byte[rawData.length];
                    System.arraycopy(rawData, 0, newData, 0, rawData.length);
                    index += rawData.length;
                } else {
                    newData = new byte[count];
                    System.arraycopy(data, index, newData, 0, count);
                    index += count;
                }
                byteQueue.offer(newData);
            } while (index < data.length);
        }
        return byteQueue;
    }
}

