/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.clj.fastble.BleManager;
import com.clj.fastble.bluetooth.BleConnector;
import com.clj.fastble.callback.BleGattCallback;
import com.clj.fastble.callback.BleIndicateCallback;
import com.clj.fastble.callback.BleMtuChangedCallback;
import com.clj.fastble.callback.BleNotifyCallback;
import com.clj.fastble.callback.BleReadCallback;
import com.clj.fastble.callback.BleRssiCallback;
import com.clj.fastble.callback.BleWriteCallback;
import com.clj.fastble.data.BleConnectStateParameter;
import com.clj.fastble.data.BleDevice;
import com.clj.fastble.exception.ConnectException;
import com.clj.fastble.utils.BleLog;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

@TargetApi(value=18)
public class BleBluetooth {
    private BleGattCallback bleGattCallback;
    private BleRssiCallback bleRssiCallback;
    private BleMtuChangedCallback bleMtuChangedCallback;
    private HashMap<String, BleNotifyCallback> bleNotifyCallbackHashMap = new HashMap();
    private HashMap<String, BleIndicateCallback> bleIndicateCallbackHashMap = new HashMap();
    private HashMap<String, BleWriteCallback> bleWriteCallbackHashMap = new HashMap();
    private HashMap<String, BleReadCallback> bleReadCallbackHashMap = new HashMap();
    private LastState lastState;
    private boolean isActiveDisconnect = false;
    private BleDevice bleDevice;
    private BluetoothGatt bluetoothGatt;
    private MainHandler mainHandler = new MainHandler(Looper.getMainLooper());
    private int connectRetryCount = 0;
    private BluetoothGattCallback coreGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            super.onConnectionStateChange(gatt, status, newState);
            BleLog.i("BluetoothGattCallback\uff1aonConnectionStateChange \nstatus: " + status + '\n' + "newState: " + newState + '\n' + "currentThread: " + Thread.currentThread().getId());
            BleBluetooth.this.bluetoothGatt = gatt;
            if (newState == 2) {
                Message message = BleBluetooth.this.mainHandler.obtainMessage();
                message.what = 5;
                message.obj = new BleConnectStateParameter(BleBluetooth.this.bleGattCallback, gatt, status);
                BleBluetooth.this.mainHandler.sendMessageDelayed(message, 500L);
            } else if (newState == 0) {
                if (BleBluetooth.this.lastState == LastState.CONNECT_CONNECTING) {
                    if (BleBluetooth.this.connectRetryCount < BleManager.getInstance().getReConnectCount()) {
                        BleLog.e("Connect fail, try reconnect after " + BleManager.getInstance().getReConnectInterval() + " Millisecond");
                        BleBluetooth.this.connectRetryCount++;
                        Message message = BleBluetooth.this.mainHandler.obtainMessage();
                        message.what = 4;
                        BleConnectStateParameter para = new BleConnectStateParameter(BleBluetooth.this.bleGattCallback, gatt, status);
                        para.setBleDevice(BleBluetooth.this.getDevice());
                        message.obj = para;
                        BleBluetooth.this.mainHandler.sendMessageDelayed(message, BleManager.getInstance().getReConnectInterval());
                    } else {
                        BleBluetooth.this.connectRetryCount = 0;
                        Message message = BleBluetooth.this.mainHandler.obtainMessage();
                        message.what = 1;
                        BleConnectStateParameter para = new BleConnectStateParameter(BleBluetooth.this.bleGattCallback, gatt, status);
                        para.setBleDevice(BleBluetooth.this.getDevice());
                        message.obj = para;
                        BleBluetooth.this.mainHandler.sendMessage(message);
                    }
                } else if (BleBluetooth.this.lastState == LastState.CONNECT_CONNECTED) {
                    BleManager.getInstance().getMultipleBluetoothController().removeBleBluetooth(BleBluetooth.this);
                    BleBluetooth.this.lastState = LastState.CONNECT_DISCONNECT;
                    Message message = BleBluetooth.this.mainHandler.obtainMessage();
                    message.what = 2;
                    BleConnectStateParameter para = new BleConnectStateParameter(BleBluetooth.this.bleGattCallback, gatt, status);
                    para.setAcitive(BleBluetooth.this.isActiveDisconnect);
                    para.setBleDevice(BleBluetooth.this.getDevice());
                    message.obj = para;
                    BleBluetooth.this.mainHandler.sendMessage(message);
                }
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            super.onServicesDiscovered(gatt, status);
            BleLog.i("BluetoothGattCallback\uff1aonServicesDiscovered \nstatus: " + status + '\n' + "currentThread: " + Thread.currentThread().getId());
            BleBluetooth.this.bluetoothGatt = gatt;
            if (status == 0) {
                BleBluetooth.this.lastState = LastState.CONNECT_CONNECTED;
                BleBluetooth.this.isActiveDisconnect = false;
                BleManager.getInstance().getMultipleBluetoothController().addBleBluetooth(BleBluetooth.this);
                Message message = BleBluetooth.this.mainHandler.obtainMessage();
                message.what = 3;
                BleConnectStateParameter para = new BleConnectStateParameter(BleBluetooth.this.bleGattCallback, gatt, status);
                para.setBleDevice(BleBluetooth.this.getDevice());
                message.obj = para;
                BleBluetooth.this.mainHandler.sendMessage(message);
            } else {
                Message message = BleBluetooth.this.mainHandler.obtainMessage();
                message.what = 1;
                BleConnectStateParameter para = new BleConnectStateParameter(BleBluetooth.this.bleGattCallback, gatt, status);
                para.setBleDevice(BleBluetooth.this.getDevice());
                message.obj = para;
                BleBluetooth.this.mainHandler.sendMessage(message);
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            Bundle bundle;
            Message message;
            Handler handler;
            Object callback;
            super.onCharacteristicChanged(gatt, characteristic);
            for (Map.Entry entry : BleBluetooth.this.bleNotifyCallbackHashMap.entrySet()) {
                callback = entry.getValue();
                if (!(callback instanceof BleNotifyCallback)) continue;
                BleNotifyCallback bleNotifyCallback = (BleNotifyCallback)callback;
                if (!characteristic.getUuid().toString().equalsIgnoreCase(bleNotifyCallback.getKey()) || (handler = bleNotifyCallback.getHandler()) == null) continue;
                message = handler.obtainMessage();
                message.what = 19;
                message.obj = bleNotifyCallback;
                bundle = new Bundle();
                bundle.putByteArray("notify_value", characteristic.getValue());
                message.setData(bundle);
                handler.sendMessage(message);
            }
            for (Map.Entry entry : BleBluetooth.this.bleIndicateCallbackHashMap.entrySet()) {
                callback = entry.getValue();
                if (!(callback instanceof BleIndicateCallback)) continue;
                BleIndicateCallback bleIndicateCallback = (BleIndicateCallback)callback;
                if (!characteristic.getUuid().toString().equalsIgnoreCase(bleIndicateCallback.getKey()) || (handler = bleIndicateCallback.getHandler()) == null) continue;
                message = handler.obtainMessage();
                message.what = 35;
                message.obj = bleIndicateCallback;
                bundle = new Bundle();
                bundle.putByteArray("indicate_value", characteristic.getValue());
                message.setData(bundle);
                handler.sendMessage(message);
            }
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            Bundle bundle;
            Message message;
            Handler handler;
            Object callback;
            super.onDescriptorWrite(gatt, descriptor, status);
            for (Map.Entry entry : BleBluetooth.this.bleNotifyCallbackHashMap.entrySet()) {
                callback = entry.getValue();
                if (!(callback instanceof BleNotifyCallback)) continue;
                BleNotifyCallback bleNotifyCallback = (BleNotifyCallback)callback;
                if (!descriptor.getCharacteristic().getUuid().toString().equalsIgnoreCase(bleNotifyCallback.getKey()) || (handler = bleNotifyCallback.getHandler()) == null) continue;
                message = handler.obtainMessage();
                message.what = 18;
                message.obj = bleNotifyCallback;
                bundle = new Bundle();
                bundle.putInt("notify_status", status);
                message.setData(bundle);
                handler.sendMessage(message);
            }
            for (Map.Entry entry : BleBluetooth.this.bleIndicateCallbackHashMap.entrySet()) {
                callback = entry.getValue();
                if (!(callback instanceof BleIndicateCallback)) continue;
                BleIndicateCallback bleIndicateCallback = (BleIndicateCallback)callback;
                if (!descriptor.getCharacteristic().getUuid().toString().equalsIgnoreCase(bleIndicateCallback.getKey()) || (handler = bleIndicateCallback.getHandler()) == null) continue;
                message = handler.obtainMessage();
                message.what = 34;
                message.obj = bleIndicateCallback;
                bundle = new Bundle();
                bundle.putInt("indicate_status", status);
                message.setData(bundle);
                handler.sendMessage(message);
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicWrite(gatt, characteristic, status);
            for (Map.Entry entry : BleBluetooth.this.bleWriteCallbackHashMap.entrySet()) {
                Handler handler;
                Object callback = entry.getValue();
                if (!(callback instanceof BleWriteCallback)) continue;
                BleWriteCallback bleWriteCallback = (BleWriteCallback)callback;
                if (!characteristic.getUuid().toString().equalsIgnoreCase(bleWriteCallback.getKey()) || (handler = bleWriteCallback.getHandler()) == null) continue;
                Message message = handler.obtainMessage();
                message.what = 50;
                message.obj = bleWriteCallback;
                Bundle bundle = new Bundle();
                bundle.putInt("write_status", status);
                bundle.putByteArray("write_value", characteristic.getValue());
                message.setData(bundle);
                handler.sendMessage(message);
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicRead(gatt, characteristic, status);
            for (Map.Entry entry : BleBluetooth.this.bleReadCallbackHashMap.entrySet()) {
                Handler handler;
                Object callback = entry.getValue();
                if (!(callback instanceof BleReadCallback)) continue;
                BleReadCallback bleReadCallback = (BleReadCallback)callback;
                if (!characteristic.getUuid().toString().equalsIgnoreCase(bleReadCallback.getKey()) || (handler = bleReadCallback.getHandler()) == null) continue;
                Message message = handler.obtainMessage();
                message.what = 66;
                message.obj = bleReadCallback;
                Bundle bundle = new Bundle();
                bundle.putInt("read_status", status);
                bundle.putByteArray("read_value", characteristic.getValue());
                message.setData(bundle);
                handler.sendMessage(message);
            }
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
            Handler handler;
            super.onReadRemoteRssi(gatt, rssi, status);
            if (BleBluetooth.this.bleRssiCallback != null && (handler = BleBluetooth.this.bleRssiCallback.getHandler()) != null) {
                Message message = handler.obtainMessage();
                message.what = 82;
                message.obj = BleBluetooth.this.bleRssiCallback;
                Bundle bundle = new Bundle();
                bundle.putInt("rssi_status", status);
                bundle.putInt("rssi_value", rssi);
                message.setData(bundle);
                handler.sendMessage(message);
            }
        }

        public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
            Handler handler;
            super.onMtuChanged(gatt, mtu, status);
            if (BleBluetooth.this.bleMtuChangedCallback != null && (handler = BleBluetooth.this.bleMtuChangedCallback.getHandler()) != null) {
                Message message = handler.obtainMessage();
                message.what = 98;
                message.obj = BleBluetooth.this.bleMtuChangedCallback;
                Bundle bundle = new Bundle();
                bundle.putInt("mtu_status", status);
                bundle.putInt("mtu_value", mtu);
                message.setData(bundle);
                handler.sendMessage(message);
            }
        }
    };

    public BleBluetooth(BleDevice bleDevice) {
        this.bleDevice = bleDevice;
    }

    public BleConnector newBleConnector() {
        return new BleConnector(this);
    }

    public synchronized void addConnectGattCallback(BleGattCallback callback) {
        this.bleGattCallback = callback;
    }

    public synchronized void removeConnectGattCallback() {
        this.bleGattCallback = null;
    }

    public synchronized void addNotifyCallback(String uuid, BleNotifyCallback bleNotifyCallback) {
        this.bleNotifyCallbackHashMap.put(uuid, bleNotifyCallback);
    }

    public synchronized void addIndicateCallback(String uuid, BleIndicateCallback bleIndicateCallback) {
        this.bleIndicateCallbackHashMap.put(uuid, bleIndicateCallback);
    }

    public synchronized void addWriteCallback(String uuid, BleWriteCallback bleWriteCallback) {
        this.bleWriteCallbackHashMap.put(uuid, bleWriteCallback);
    }

    public synchronized void addReadCallback(String uuid, BleReadCallback bleReadCallback) {
        this.bleReadCallbackHashMap.put(uuid, bleReadCallback);
    }

    public synchronized void removeNotifyCallback(String uuid) {
        if (this.bleNotifyCallbackHashMap.containsKey(uuid)) {
            this.bleNotifyCallbackHashMap.remove(uuid);
        }
    }

    public synchronized void removeIndicateCallback(String uuid) {
        if (this.bleIndicateCallbackHashMap.containsKey(uuid)) {
            this.bleIndicateCallbackHashMap.remove(uuid);
        }
    }

    public synchronized void removeWriteCallback(String uuid) {
        if (this.bleWriteCallbackHashMap.containsKey(uuid)) {
            this.bleWriteCallbackHashMap.remove(uuid);
        }
    }

    public synchronized void removeReadCallback(String uuid) {
        if (this.bleReadCallbackHashMap.containsKey(uuid)) {
            this.bleReadCallbackHashMap.remove(uuid);
        }
    }

    public synchronized void clearCharacterCallback() {
        if (this.bleNotifyCallbackHashMap != null) {
            this.bleNotifyCallbackHashMap.clear();
        }
        if (this.bleIndicateCallbackHashMap != null) {
            this.bleIndicateCallbackHashMap.clear();
        }
        if (this.bleWriteCallbackHashMap != null) {
            this.bleWriteCallbackHashMap.clear();
        }
        if (this.bleReadCallbackHashMap != null) {
            this.bleReadCallbackHashMap.clear();
        }
    }

    public synchronized void addRssiCallback(BleRssiCallback callback) {
        this.bleRssiCallback = callback;
    }

    public synchronized void removeRssiCallback() {
        this.bleRssiCallback = null;
    }

    public synchronized void addMtuChangedCallback(BleMtuChangedCallback callback) {
        this.bleMtuChangedCallback = callback;
    }

    public synchronized void removeMtuChangedCallback() {
        this.bleMtuChangedCallback = null;
    }

    public String getDeviceKey() {
        return this.bleDevice.getKey();
    }

    public int getConnectState() {
        BluetoothManager bluetoothManager = BleManager.getInstance().getBluetoothManager();
        if (bluetoothManager != null && this.getDevice() != null && this.getDevice().getDevice() != null) {
            return bluetoothManager.getConnectionState(this.getDevice().getDevice(), 7);
        }
        return 0;
    }

    public BleDevice getDevice() {
        return this.bleDevice;
    }

    public BluetoothGatt getBluetoothGatt() {
        return this.bluetoothGatt;
    }

    public synchronized BluetoothGatt connect(BleDevice bleDevice, boolean autoConnect, BleGattCallback callback) {
        BleLog.i("connect device: " + bleDevice.getName() + "\nmac: " + bleDevice.getMac() + "\nautoConnect: " + autoConnect + "\ncurrentThread: " + Thread.currentThread().getId());
        this.addConnectGattCallback(callback);
        this.lastState = LastState.CONNECT_CONNECTING;
        BluetoothGatt gatt = Build.VERSION.SDK_INT >= 23 ? bleDevice.getDevice().connectGatt(BleManager.getInstance().getContext(), autoConnect, this.coreGattCallback, 2) : bleDevice.getDevice().connectGatt(BleManager.getInstance().getContext(), autoConnect, this.coreGattCallback);
        if (gatt != null) {
            if (this.bleGattCallback != null) {
                this.bleGattCallback.onStartConnect();
            }
        } else {
            this.lastState = LastState.CONNECT_FAILURE;
        }
        return gatt;
    }

    public synchronized void disconnect() {
        this.isActiveDisconnect = true;
        this.disconnectGatt();
    }

    public synchronized void destroy() {
        this.lastState = LastState.CONNECT_IDLE;
        this.disconnectGatt();
        this.refreshDeviceCache();
        this.closeBluetoothGatt();
        this.removeConnectGattCallback();
        this.removeRssiCallback();
        this.removeMtuChangedCallback();
        this.clearCharacterCallback();
        this.mainHandler.removeCallbacksAndMessages(null);
    }

    private synchronized void disconnectGatt() {
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.disconnect();
        }
    }

    private synchronized void refreshDeviceCache() {
        try {
            Method refresh = BluetoothGatt.class.getMethod("refresh", new Class[0]);
            if (refresh != null && this.bluetoothGatt != null) {
                boolean success = (Boolean)refresh.invoke((Object)this.bluetoothGatt, new Object[0]);
                BleLog.i("refreshDeviceCache, is success:  " + success);
            }
        }
        catch (Exception e) {
            BleLog.i("exception occur while refreshing device: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private synchronized void closeBluetoothGatt() {
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.close();
        }
    }

    static enum LastState {
        CONNECT_IDLE,
        CONNECT_CONNECTING,
        CONNECT_CONNECTED,
        CONNECT_FAILURE,
        CONNECT_DISCONNECT;

    }

    private final class MainHandler
    extends Handler {
        MainHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    BleBluetooth.this.disconnectGatt();
                    BleBluetooth.this.refreshDeviceCache();
                    BleBluetooth.this.closeBluetoothGatt();
                    BleBluetooth.this.lastState = LastState.CONNECT_FAILURE;
                    BleConnectStateParameter para = (BleConnectStateParameter)msg.obj;
                    BleGattCallback callback = para.getCallback();
                    BluetoothGatt gatt = para.getGatt();
                    BleDevice bleDevice = para.getBleDevice();
                    int status = para.getStatus();
                    if (callback == null) break;
                    callback.onConnectFail(bleDevice, new ConnectException(gatt, status));
                    break;
                }
                case 2: {
                    BleConnectStateParameter para = (BleConnectStateParameter)msg.obj;
                    BleGattCallback callback = para.getCallback();
                    BluetoothGatt gatt = para.getGatt();
                    boolean isActive = para.isAcitive();
                    BleDevice bleDevice = para.getBleDevice();
                    int status = para.getStatus();
                    if (callback == null) break;
                    callback.onDisConnected(isActive, bleDevice, gatt, status);
                    break;
                }
                case 3: {
                    BleConnectStateParameter para = (BleConnectStateParameter)msg.obj;
                    BleGattCallback callback = para.getCallback();
                    BluetoothGatt gatt = para.getGatt();
                    BleDevice bleDevice = para.getBleDevice();
                    int status = para.getStatus();
                    if (callback == null) break;
                    callback.onConnectSuccess(bleDevice, gatt, status);
                    break;
                }
                case 4: {
                    BleBluetooth.this.disconnectGatt();
                    BleBluetooth.this.refreshDeviceCache();
                    BleBluetooth.this.closeBluetoothGatt();
                    BleConnectStateParameter para = (BleConnectStateParameter)msg.obj;
                    BleGattCallback callback = para.getCallback();
                    BleDevice bleDevice = para.getBleDevice();
                    BleBluetooth.this.connect(bleDevice, false, callback);
                    break;
                }
                case 5: {
                    BleConnectStateParameter para = (BleConnectStateParameter)msg.obj;
                    BluetoothGatt gatt = para.getGatt();
                    gatt.discoverServices();
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }
}

