/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.bluetooth;

import android.os.Build;
import com.clj.fastble.BleManager;
import com.clj.fastble.bluetooth.BleBluetooth;
import com.clj.fastble.data.BleDevice;
import com.clj.fastble.utils.BleLruHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class MultipleBluetoothController {
    private final BleLruHashMap<String, BleBluetooth> bleLruHashMap = new BleLruHashMap(BleManager.getInstance().getMaxConnectCount());

    public synchronized void addBleBluetooth(BleBluetooth bleBluetooth) {
        if (bleBluetooth == null) {
            return;
        }
        if (!this.bleLruHashMap.containsKey(bleBluetooth.getDeviceKey())) {
            this.bleLruHashMap.put(bleBluetooth.getDeviceKey(), bleBluetooth);
        }
    }

    public synchronized void removeBleBluetooth(BleBluetooth bleBluetooth) {
        if (bleBluetooth == null) {
            return;
        }
        if (this.bleLruHashMap.containsKey(bleBluetooth.getDeviceKey())) {
            this.bleLruHashMap.remove(bleBluetooth.getDeviceKey());
        }
    }

    public synchronized boolean isContainDevice(BleDevice bleDevice) {
        return bleDevice != null && this.bleLruHashMap.containsKey(bleDevice.getKey());
    }

    public synchronized int getConnectState(BleDevice bleDevice) {
        BleBluetooth bleBluetooth = this.getBleBluetooth(bleDevice);
        if (bleBluetooth != null) {
            return bleBluetooth.getConnectState();
        }
        return 0;
    }

    public synchronized BleBluetooth getBleBluetooth(BleDevice bleDevice) {
        if (bleDevice != null && this.bleLruHashMap.containsKey(bleDevice.getKey())) {
            return (BleBluetooth)this.bleLruHashMap.get(bleDevice.getKey());
        }
        return null;
    }

    public synchronized void disconnect(BleDevice bleDevice) {
        if (this.isContainDevice(bleDevice)) {
            this.getBleBluetooth(bleDevice).disconnect();
        }
    }

    public synchronized void disconnectAllDevice() {
        for (Map.Entry stringBleBluetoothEntry : this.bleLruHashMap.entrySet()) {
            ((BleBluetooth)stringBleBluetoothEntry.getValue()).disconnect();
        }
        this.bleLruHashMap.clear();
    }

    public synchronized void destroy() {
        for (Map.Entry stringBleBluetoothEntry : this.bleLruHashMap.entrySet()) {
            ((BleBluetooth)stringBleBluetoothEntry.getValue()).destroy();
        }
        this.bleLruHashMap.clear();
    }

    public synchronized List<BleBluetooth> getBleBluetoothList() {
        ArrayList<BleBluetooth> bleBluetoothList = new ArrayList<BleBluetooth>(this.bleLruHashMap.values());
        Collections.sort(bleBluetoothList, new Comparator<BleBluetooth>(){

            @Override
            public int compare(BleBluetooth lhs, BleBluetooth rhs) {
                return lhs.getDeviceKey().compareToIgnoreCase(rhs.getDeviceKey());
            }
        });
        return bleBluetoothList;
    }

    public synchronized List<BleDevice> getDeviceList() {
        this.refreshConnectedDevice();
        ArrayList<BleDevice> deviceList = new ArrayList<BleDevice>();
        for (BleBluetooth BleBluetooth2 : this.getBleBluetoothList()) {
            if (BleBluetooth2 == null) continue;
            deviceList.add(BleBluetooth2.getDevice());
        }
        return deviceList;
    }

    public void refreshConnectedDevice() {
        if (Build.VERSION.SDK_INT >= 18) {
            List<BleBluetooth> bluetoothList = this.getBleBluetoothList();
            for (int i = 0; bluetoothList != null && i < bluetoothList.size(); ++i) {
                BleBluetooth bleBluetooth = bluetoothList.get(i);
                if (BleManager.getInstance().isConnected(bleBluetooth.getDevice())) continue;
                this.removeBleBluetooth(bleBluetooth);
            }
        }
    }
}

