/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.clj.fastble.BleManager;
import com.clj.fastble.bluetooth.BleBluetooth;
import com.clj.fastble.callback.BleIndicateCallback;
import com.clj.fastble.callback.BleMtuChangedCallback;
import com.clj.fastble.callback.BleNotifyCallback;
import com.clj.fastble.callback.BleReadCallback;
import com.clj.fastble.callback.BleRssiCallback;
import com.clj.fastble.callback.BleWriteCallback;
import com.clj.fastble.exception.GattException;
import com.clj.fastble.exception.OtherException;
import com.clj.fastble.exception.TimeoutException;
import java.util.UUID;

@TargetApi(value=18)
public class BleConnector {
    private static final String UUID_CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR = "00002902-0000-1000-8000-00805f9b34fb";
    private BluetoothGatt bluetoothGatt;
    private BluetoothGattService service;
    private BluetoothGattCharacteristic characteristic;
    private BleBluetooth bleBluetooth;
    private Handler handler;

    BleConnector(BleBluetooth bleBluetooth) {
        Looper looper = Looper.myLooper();
        if (looper == null) {
            Looper.prepare();
        }
        this.bleBluetooth = bleBluetooth;
        this.bluetoothGatt = bleBluetooth.getBluetoothGatt();
        this.handler = new ConnectorHandler();
    }

    private void run() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            Looper.loop();
        }
    }

    public void destroy() {
        this.handler.removeCallbacksAndMessages(null);
    }

    private BleConnector withUUID(UUID serviceUUID, UUID characteristicUUID) {
        if (serviceUUID != null && this.bluetoothGatt != null) {
            this.service = this.bluetoothGatt.getService(serviceUUID);
        }
        if (this.service != null && characteristicUUID != null) {
            this.characteristic = this.service.getCharacteristic(characteristicUUID);
        }
        return this;
    }

    public BleConnector withUUIDString(String serviceUUID, String characteristicUUID) {
        return this.withUUID(this.formUUID(serviceUUID), this.formUUID(characteristicUUID));
    }

    private UUID formUUID(String uuid) {
        return uuid == null ? null : UUID.fromString(uuid);
    }

    public void enableCharacteristicNotify(BleNotifyCallback bleNotifyCallback, String uuid_notify) {
        if (this.characteristic != null && (this.characteristic.getProperties() | 0x10) > 0) {
            this.handleCharacteristicNotifyCallback(bleNotifyCallback, uuid_notify);
            this.setCharacteristicNotification(this.bluetoothGatt, this.characteristic, true, bleNotifyCallback);
        } else if (bleNotifyCallback != null) {
            bleNotifyCallback.onNotifyFailure(new OtherException("this characteristic not support notify!"));
        }
        this.run();
    }

    public boolean disableCharacteristicNotify() {
        if (this.characteristic != null && (this.characteristic.getProperties() | 0x10) > 0) {
            boolean success = this.setCharacteristicNotification(this.bluetoothGatt, this.characteristic, false, null);
            this.run();
            return success;
        }
        return false;
    }

    private boolean setCharacteristicNotification(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, boolean enable, BleNotifyCallback bleNotifyCallback) {
        if (gatt == null || characteristic == null) {
            this.notifyMsgInit();
            if (bleNotifyCallback != null) {
                bleNotifyCallback.onNotifyFailure(new OtherException("gatt or characteristic equal null"));
            }
            return false;
        }
        boolean success1 = gatt.setCharacteristicNotification(characteristic, enable);
        if (!success1) {
            this.notifyMsgInit();
            if (bleNotifyCallback != null) {
                bleNotifyCallback.onNotifyFailure(new OtherException("gatt setCharacteristicNotification fail"));
            }
            return false;
        }
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(this.formUUID(UUID_CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR));
        if (descriptor == null) {
            this.notifyMsgInit();
            if (bleNotifyCallback != null) {
                bleNotifyCallback.onNotifyFailure(new OtherException("descriptor equals null"));
            }
            return false;
        }
        descriptor.setValue(enable ? BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
        boolean success2 = gatt.writeDescriptor(descriptor);
        if (!success2) {
            this.notifyMsgInit();
            if (bleNotifyCallback != null) {
                bleNotifyCallback.onNotifyFailure(new OtherException("gatt writeDescriptor fail"));
            }
        }
        return success2;
    }

    public void enableCharacteristicIndicate(BleIndicateCallback bleIndicateCallback, String uuid_indicate) {
        if (this.characteristic != null && (this.characteristic.getProperties() | 0x10) > 0) {
            this.handleCharacteristicIndicateCallback(bleIndicateCallback, uuid_indicate);
            this.setCharacteristicIndication(this.bluetoothGatt, this.characteristic, true, bleIndicateCallback);
        } else if (bleIndicateCallback != null) {
            bleIndicateCallback.onIndicateFailure(new OtherException("this characteristic not support indicate!"));
        }
        this.run();
    }

    public boolean disableCharacteristicIndicate() {
        if (this.characteristic != null && (this.characteristic.getProperties() | 0x10) > 0) {
            boolean success = this.setCharacteristicIndication(this.bluetoothGatt, this.characteristic, false, null);
            this.run();
            return success;
        }
        return false;
    }

    private boolean setCharacteristicIndication(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, boolean enable, BleIndicateCallback bleIndicateCallback) {
        if (gatt == null || characteristic == null) {
            this.indicateMsgInit();
            if (bleIndicateCallback != null) {
                bleIndicateCallback.onIndicateFailure(new OtherException("gatt or characteristic equal null"));
            }
            return false;
        }
        boolean success1 = gatt.setCharacteristicNotification(characteristic, enable);
        if (!success1) {
            this.indicateMsgInit();
            if (bleIndicateCallback != null) {
                bleIndicateCallback.onIndicateFailure(new OtherException("gatt setCharacteristicNotification fail"));
            }
            return false;
        }
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(this.formUUID(UUID_CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR));
        if (descriptor == null) {
            this.indicateMsgInit();
            if (bleIndicateCallback != null) {
                bleIndicateCallback.onIndicateFailure(new OtherException("descriptor equals null"));
            }
            return false;
        }
        descriptor.setValue(enable ? BluetoothGattDescriptor.ENABLE_INDICATION_VALUE : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
        boolean success2 = gatt.writeDescriptor(descriptor);
        if (!success2) {
            this.indicateMsgInit();
            if (bleIndicateCallback != null) {
                bleIndicateCallback.onIndicateFailure(new OtherException("gatt writeDescriptor fail"));
            }
        }
        return success2;
    }

    public void writeCharacteristic(byte[] data, BleWriteCallback bleWriteCallback, String uuid_write) {
        if (data == null || data.length <= 0) {
            if (bleWriteCallback != null) {
                bleWriteCallback.onWriteFailure(new OtherException("the data to be written is empty"));
            }
            return;
        }
        if (this.characteristic == null || (this.characteristic.getProperties() & 0xC) == 0) {
            if (bleWriteCallback != null) {
                bleWriteCallback.onWriteFailure(new OtherException("this characteristic not support write!"));
            }
            return;
        }
        if (this.characteristic.setValue(data)) {
            this.handleCharacteristicWriteCallback(bleWriteCallback, uuid_write);
            if (!this.bluetoothGatt.writeCharacteristic(this.characteristic)) {
                this.writeMsgInit();
                if (bleWriteCallback != null) {
                    bleWriteCallback.onWriteFailure(new OtherException("gatt writeCharacteristic fail"));
                }
            }
        } else if (bleWriteCallback != null) {
            bleWriteCallback.onWriteFailure(new OtherException("Updates the locally stored value of this characteristic fail"));
        }
        this.run();
    }

    public void readCharacteristic(BleReadCallback bleReadCallback, String uuid_read) {
        if (this.characteristic != null && (this.characteristic.getProperties() & 2) > 0) {
            this.handleCharacteristicReadCallback(bleReadCallback, uuid_read);
            if (!this.bluetoothGatt.readCharacteristic(this.characteristic)) {
                this.readMsgInit();
                if (bleReadCallback != null) {
                    bleReadCallback.onReadFailure(new OtherException("gatt readCharacteristic fail"));
                }
            }
        } else if (bleReadCallback != null) {
            bleReadCallback.onReadFailure(new OtherException("this characteristic not support read!"));
        }
        this.run();
    }

    public void readRemoteRssi(BleRssiCallback bleRssiCallback) {
        this.handleRSSIReadCallback(bleRssiCallback);
        if (!this.bluetoothGatt.readRemoteRssi()) {
            this.rssiMsgInit();
            if (bleRssiCallback != null) {
                bleRssiCallback.onRssiFailure(new OtherException("gatt readRemoteRssi fail"));
            }
        }
        this.run();
    }

    public void setMtu(int requiredMtu, BleMtuChangedCallback bleMtuChangedCallback) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.handleSetMtuCallback(bleMtuChangedCallback);
            if (!this.bluetoothGatt.requestMtu(requiredMtu)) {
                this.mtuChangedMsgInit();
                if (bleMtuChangedCallback != null) {
                    bleMtuChangedCallback.onSetMTUFailure(new OtherException("gatt requestMtu fail"));
                }
            }
        } else if (bleMtuChangedCallback != null) {
            bleMtuChangedCallback.onSetMTUFailure(new OtherException("API level lower than 21"));
        }
        this.run();
    }

    private void handleCharacteristicNotifyCallback(BleNotifyCallback bleNotifyCallback, String uuid_notify) {
        if (bleNotifyCallback != null) {
            this.notifyMsgInit();
            bleNotifyCallback.setKey(uuid_notify);
            bleNotifyCallback.setHandler(this.handler);
            this.bleBluetooth.addNotifyCallback(uuid_notify, bleNotifyCallback);
            this.handler.sendMessageDelayed(this.handler.obtainMessage(17, (Object)bleNotifyCallback), (long)BleManager.getInstance().getOperateTimeout());
        }
    }

    private void handleCharacteristicIndicateCallback(BleIndicateCallback bleIndicateCallback, String uuid_indicate) {
        if (bleIndicateCallback != null) {
            this.indicateMsgInit();
            bleIndicateCallback.setKey(uuid_indicate);
            bleIndicateCallback.setHandler(this.handler);
            this.bleBluetooth.addIndicateCallback(uuid_indicate, bleIndicateCallback);
            this.handler.sendMessageDelayed(this.handler.obtainMessage(33, (Object)bleIndicateCallback), (long)BleManager.getInstance().getOperateTimeout());
        }
    }

    private void handleCharacteristicWriteCallback(BleWriteCallback bleWriteCallback, String uuid_write) {
        if (bleWriteCallback != null) {
            this.writeMsgInit();
            bleWriteCallback.setKey(uuid_write);
            bleWriteCallback.setHandler(this.handler);
            this.bleBluetooth.addWriteCallback(uuid_write, bleWriteCallback);
            this.handler.sendMessageDelayed(this.handler.obtainMessage(49, (Object)bleWriteCallback), (long)BleManager.getInstance().getOperateTimeout());
        }
    }

    private void handleCharacteristicReadCallback(BleReadCallback bleReadCallback, String uuid_read) {
        if (bleReadCallback != null) {
            this.readMsgInit();
            bleReadCallback.setKey(uuid_read);
            bleReadCallback.setHandler(this.handler);
            this.bleBluetooth.addReadCallback(uuid_read, bleReadCallback);
            this.handler.sendMessageDelayed(this.handler.obtainMessage(65, (Object)bleReadCallback), (long)BleManager.getInstance().getOperateTimeout());
        }
    }

    private void handleRSSIReadCallback(BleRssiCallback bleRssiCallback) {
        if (bleRssiCallback != null) {
            this.rssiMsgInit();
            bleRssiCallback.setHandler(this.handler);
            this.bleBluetooth.addRssiCallback(bleRssiCallback);
            this.handler.sendMessageDelayed(this.handler.obtainMessage(81, (Object)bleRssiCallback), (long)BleManager.getInstance().getOperateTimeout());
        }
    }

    private void handleSetMtuCallback(BleMtuChangedCallback bleMtuChangedCallback) {
        if (bleMtuChangedCallback != null) {
            this.mtuChangedMsgInit();
            bleMtuChangedCallback.setHandler(this.handler);
            this.bleBluetooth.addMtuChangedCallback(bleMtuChangedCallback);
            this.handler.sendMessageDelayed(this.handler.obtainMessage(97, (Object)bleMtuChangedCallback), (long)BleManager.getInstance().getOperateTimeout());
        }
    }

    public void notifyMsgInit() {
        this.handler.removeMessages(17);
    }

    public void indicateMsgInit() {
        this.handler.removeMessages(33);
    }

    public void writeMsgInit() {
        this.handler.removeMessages(49);
    }

    public void readMsgInit() {
        this.handler.removeMessages(65);
    }

    public void rssiMsgInit() {
        this.handler.removeMessages(81);
    }

    public void mtuChangedMsgInit() {
        this.handler.removeMessages(97);
    }

    private static final class ConnectorHandler
    extends Handler {
        private ConnectorHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 17: {
                    BleNotifyCallback notifyCallback = (BleNotifyCallback)msg.obj;
                    if (notifyCallback == null) break;
                    notifyCallback.onNotifyFailure(new TimeoutException());
                    break;
                }
                case 18: {
                    this.removeMessages(17);
                    BleNotifyCallback notifyCallback = (BleNotifyCallback)msg.obj;
                    Bundle bundle = msg.getData();
                    int status = bundle.getInt("notify_status");
                    if (notifyCallback == null) break;
                    if (status == 0) {
                        notifyCallback.onNotifySuccess();
                        break;
                    }
                    notifyCallback.onNotifyFailure(new GattException(status));
                    break;
                }
                case 19: {
                    BleNotifyCallback notifyCallback = (BleNotifyCallback)msg.obj;
                    Bundle bundle = msg.getData();
                    byte[] value = bundle.getByteArray("notify_value");
                    if (notifyCallback == null) break;
                    notifyCallback.onCharacteristicChanged(value);
                    break;
                }
                case 33: {
                    BleIndicateCallback indicateCallback = (BleIndicateCallback)msg.obj;
                    if (indicateCallback == null) break;
                    indicateCallback.onIndicateFailure(new TimeoutException());
                    break;
                }
                case 34: {
                    this.removeMessages(33);
                    BleIndicateCallback indicateCallback = (BleIndicateCallback)msg.obj;
                    Bundle bundle = msg.getData();
                    int status = bundle.getInt("indicate_status");
                    if (indicateCallback == null) break;
                    if (status == 0) {
                        indicateCallback.onIndicateSuccess();
                        break;
                    }
                    indicateCallback.onIndicateFailure(new GattException(status));
                    break;
                }
                case 35: {
                    BleIndicateCallback indicateCallback = (BleIndicateCallback)msg.obj;
                    Bundle bundle = msg.getData();
                    byte[] value = bundle.getByteArray("indicate_value");
                    if (indicateCallback == null) break;
                    indicateCallback.onCharacteristicChanged(value);
                    break;
                }
                case 49: {
                    BleWriteCallback writeCallback = (BleWriteCallback)msg.obj;
                    if (writeCallback == null) break;
                    writeCallback.onWriteFailure(new TimeoutException());
                    break;
                }
                case 50: {
                    this.removeMessages(49);
                    BleWriteCallback writeCallback = (BleWriteCallback)msg.obj;
                    Bundle bundle = msg.getData();
                    int status = bundle.getInt("write_status");
                    if (writeCallback == null) break;
                    if (status == 0) {
                        writeCallback.onWriteSuccess();
                        break;
                    }
                    writeCallback.onWriteFailure(new GattException(status));
                    break;
                }
                case 65: {
                    BleReadCallback readCallback = (BleReadCallback)msg.obj;
                    if (readCallback == null) break;
                    readCallback.onReadFailure(new TimeoutException());
                    break;
                }
                case 66: {
                    this.removeMessages(65);
                    BleReadCallback readCallback = (BleReadCallback)msg.obj;
                    Bundle bundle = msg.getData();
                    int status = bundle.getInt("read_status");
                    byte[] value = bundle.getByteArray("read_value");
                    if (readCallback == null) break;
                    if (status == 0) {
                        readCallback.onReadSuccess(value);
                        break;
                    }
                    readCallback.onReadFailure(new GattException(status));
                    break;
                }
                case 81: {
                    BleRssiCallback rssiCallback = (BleRssiCallback)msg.obj;
                    if (rssiCallback == null) break;
                    rssiCallback.onRssiFailure(new TimeoutException());
                    break;
                }
                case 82: {
                    this.removeMessages(81);
                    BleRssiCallback rssiCallback = (BleRssiCallback)msg.obj;
                    Bundle bundle = msg.getData();
                    int status = bundle.getInt("rssi_status");
                    int value = bundle.getInt("rssi_value");
                    if (rssiCallback == null) break;
                    if (status == 0) {
                        rssiCallback.onRssiSuccess(value);
                        break;
                    }
                    rssiCallback.onRssiFailure(new GattException(status));
                    break;
                }
                case 97: {
                    BleMtuChangedCallback mtuChangedCallback = (BleMtuChangedCallback)msg.obj;
                    if (mtuChangedCallback == null) break;
                    mtuChangedCallback.onSetMTUFailure(new TimeoutException());
                    break;
                }
                case 98: {
                    this.removeMessages(97);
                    BleMtuChangedCallback mtuChangedCallback = (BleMtuChangedCallback)msg.obj;
                    Bundle bundle = msg.getData();
                    int status = bundle.getInt("mtu_status");
                    int value = bundle.getInt("mtu_value");
                    if (mtuChangedCallback == null) break;
                    if (status == 0) {
                        mtuChangedCallback.onMtuChanged(value);
                        break;
                    }
                    mtuChangedCallback.onSetMTUFailure(new GattException(status));
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }
}

