/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.clj.fastble.BleManager;
import com.clj.fastble.bluetooth.BleConnector;
import com.clj.fastble.callback.BleGattCallback;
import com.clj.fastble.callback.BleIndicateCallback;
import com.clj.fastble.callback.BleMtuChangedCallback;
import com.clj.fastble.callback.BleNotifyCallback;
import com.clj.fastble.callback.BleReadCallback;
import com.clj.fastble.callback.BleRssiCallback;
import com.clj.fastble.callback.BleWriteCallback;
import com.clj.fastble.data.BleConnectState;
import com.clj.fastble.data.BleDevice;
import com.clj.fastble.exception.ConnectException;
import com.clj.fastble.exception.GattException;
import com.clj.fastble.utils.BleLog;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

@TargetApi(value=18)
public class BleBluetooth {
    private BleConnectState connectState = BleConnectState.CONNECT_IDLE;
    private Handler handler = new Handler(Looper.getMainLooper());
    private boolean isActivityDisconnect = false;
    private BleGattCallback bleGattCallback;
    private BleRssiCallback bleRssiCallback;
    private BleMtuChangedCallback bleMtuChangedCallback;
    private HashMap<String, BleNotifyCallback> bleNotifyCallbackHashMap = new HashMap();
    private HashMap<String, BleIndicateCallback> bleIndicateCallbackHashMap = new HashMap();
    private HashMap<String, BleWriteCallback> bleWriteCallbackHashMap = new HashMap();
    private HashMap<String, BleReadCallback> bleReadCallbackHashMap = new HashMap();
    private BleBluetooth bleBluetooth;
    private BleDevice bleDevice;
    private BluetoothGatt bluetoothGatt;
    private BluetoothGattCallback coreGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            super.onConnectionStateChange(gatt, status, newState);
            BleLog.i("BluetoothGattCallback\uff1aonConnectionStateChange \nstatus: " + status + '\n' + "newState: " + newState + '\n' + "currentThread: " + Thread.currentThread().getId());
            final BluetoothGatt finalGatt = gatt;
            final int finalStatus = status;
            final int finalState = newState;
            if (newState == 2) {
                gatt.discoverServices();
            } else if (newState == 0) {
                BleBluetooth.this.closeBluetoothGatt();
                BleManager.getInstance().getMultipleBluetoothController().removeBleBluetooth(BleBluetooth.this.bleBluetooth);
                if (BleBluetooth.this.connectState == BleConnectState.CONNECT_CONNECTING) {
                    BleBluetooth.this.connectState = BleConnectState.CONNECT_FAILURE;
                    BleBluetooth.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (BleBluetooth.this.bleGattCallback != null) {
                                BleBluetooth.this.bleGattCallback.onConnectFail(new ConnectException(finalGatt, finalStatus));
                            }
                        }
                    });
                } else if (BleBluetooth.this.connectState == BleConnectState.CONNECT_CONNECTED) {
                    BleBluetooth.this.connectState = BleConnectState.CONNECT_DISCONNECT;
                    BleBluetooth.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (BleBluetooth.this.bleGattCallback != null) {
                                BleBluetooth.this.bleGattCallback.onDisConnected(BleBluetooth.this.isActivityDisconnect, BleBluetooth.this.bleBluetooth.getDevice(), finalGatt, finalState);
                            }
                        }
                    });
                }
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            super.onServicesDiscovered(gatt, status);
            BleLog.i("BluetoothGattCallback\uff1aonServicesDiscovered \nstatus: " + status + '\n' + "currentThread: " + Thread.currentThread().getId());
            final BluetoothGatt finalGatt = gatt;
            final int finalStatus = status;
            if (status == 0) {
                BleBluetooth.this.bluetoothGatt = finalGatt;
                BleBluetooth.this.connectState = BleConnectState.CONNECT_CONNECTED;
                BleBluetooth.this.isActivityDisconnect = false;
                BleManager.getInstance().getMultipleBluetoothController().addBleBluetooth(BleBluetooth.this.bleBluetooth);
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (BleBluetooth.this.bleGattCallback != null) {
                            BleBluetooth.this.bleGattCallback.onConnectSuccess(BleBluetooth.this.bleDevice, finalGatt, finalStatus);
                        }
                    }
                });
            } else {
                BleBluetooth.this.closeBluetoothGatt();
                BleBluetooth.this.connectState = BleConnectState.CONNECT_FAILURE;
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (BleBluetooth.this.bleGattCallback != null) {
                            BleBluetooth.this.bleGattCallback.onConnectFail(new ConnectException(finalGatt, finalStatus));
                        }
                    }
                });
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            Object call;
            super.onCharacteristicChanged(gatt, characteristic);
            BleLog.i("BluetoothGattCallback\uff1aonCharacteristicChanged ");
            final byte[] data = characteristic.getValue();
            for (Map.Entry entry : BleBluetooth.this.bleNotifyCallbackHashMap.entrySet()) {
                call = entry.getValue();
                if (!(call instanceof BleNotifyCallback) || !characteristic.getUuid().toString().equalsIgnoreCase(((BleNotifyCallback)call).getKey())) continue;
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        ((BleNotifyCallback)call).onCharacteristicChanged(data);
                    }
                });
            }
            for (Map.Entry entry : BleBluetooth.this.bleIndicateCallbackHashMap.entrySet()) {
                call = entry.getValue();
                if (!(call instanceof BleIndicateCallback) || !characteristic.getUuid().toString().equalsIgnoreCase(((BleIndicateCallback)call).getKey())) continue;
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        ((BleIndicateCallback)call).onCharacteristicChanged(data);
                    }
                });
            }
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            Object call;
            super.onDescriptorWrite(gatt, descriptor, status);
            BleLog.i("BleGattCallback\uff1aonDescriptorWrite ");
            final int finalStatus = status;
            for (Map.Entry entry : BleBluetooth.this.bleNotifyCallbackHashMap.entrySet()) {
                call = entry.getValue();
                if (!(call instanceof BleNotifyCallback) || !descriptor.getCharacteristic().getUuid().toString().equalsIgnoreCase(((BleNotifyCallback)call).getKey())) continue;
                ((BleNotifyCallback)call).getBleConnector().notifyMsgInit();
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (finalStatus == 0) {
                            ((BleNotifyCallback)call).onNotifySuccess();
                        } else {
                            ((BleNotifyCallback)call).onNotifyFailure(new GattException(finalStatus));
                        }
                    }
                });
            }
            for (Map.Entry entry : BleBluetooth.this.bleIndicateCallbackHashMap.entrySet()) {
                call = entry.getValue();
                if (!(call instanceof BleIndicateCallback) || !descriptor.getCharacteristic().getUuid().toString().equalsIgnoreCase(((BleIndicateCallback)call).getKey())) continue;
                ((BleIndicateCallback)call).getBleConnector().indicateMsgInit();
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (finalStatus == 0) {
                            ((BleIndicateCallback)call).onIndicateSuccess();
                        } else {
                            ((BleIndicateCallback)call).onIndicateFailure(new GattException(finalStatus));
                        }
                    }
                });
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicWrite(gatt, characteristic, status);
            BleLog.i("BluetoothGattCallback\uff1aonCharacteristicWrite ");
            final int finalStatus = status;
            for (Map.Entry entry : BleBluetooth.this.bleWriteCallbackHashMap.entrySet()) {
                final Object call = entry.getValue();
                if (!(call instanceof BleWriteCallback) || !characteristic.getUuid().toString().equalsIgnoreCase(((BleWriteCallback)call).getKey())) continue;
                ((BleWriteCallback)call).getBleConnector().writeMsgInit();
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (finalStatus == 0) {
                            ((BleWriteCallback)call).onWriteSuccess();
                        } else {
                            ((BleWriteCallback)call).onWriteFailure(new GattException(finalStatus));
                        }
                    }
                });
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicRead(gatt, characteristic, status);
            BleLog.i("BluetoothGattCallback\uff1aonCharacteristicRead ");
            final byte[] data = characteristic.getValue();
            final int finalStatus = status;
            for (Map.Entry entry : BleBluetooth.this.bleReadCallbackHashMap.entrySet()) {
                final Object call = entry.getValue();
                if (!(call instanceof BleReadCallback) || !characteristic.getUuid().toString().equalsIgnoreCase(((BleReadCallback)call).getKey())) continue;
                ((BleReadCallback)call).getBleConnector().readMsgInit();
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (finalStatus == 0) {
                            ((BleReadCallback)call).onReadSuccess(data);
                        } else {
                            ((BleReadCallback)call).onReadFailure(new GattException(finalStatus));
                        }
                    }
                });
            }
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, final int rssi, int status) {
            super.onReadRemoteRssi(gatt, rssi, status);
            BleLog.i("BluetoothGattCallback\uff1aonReadRemoteRssi " + status);
            final int finalStatus = status;
            if (BleBluetooth.this.bleRssiCallback != null) {
                BleBluetooth.this.bleRssiCallback.getBleConnector().rssiMsgInit();
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (finalStatus == 0) {
                            BleBluetooth.this.bleRssiCallback.onRssiSuccess(rssi);
                        } else {
                            BleBluetooth.this.bleRssiCallback.onRssiFailure(new GattException(finalStatus));
                        }
                    }
                });
            }
        }

        public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
            super.onMtuChanged(gatt, mtu, status);
            BleLog.i("BluetoothGattCallback\uff1aonMtuChanged ");
            final int currentMtu = mtu;
            final int finalStatus = status;
            if (BleBluetooth.this.bleMtuChangedCallback != null) {
                BleBluetooth.this.bleMtuChangedCallback.getBleConnector().mtuChangedMsgInit();
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (finalStatus == 0) {
                            BleBluetooth.this.bleMtuChangedCallback.onMtuChanged(currentMtu);
                        } else {
                            BleBluetooth.this.bleMtuChangedCallback.onSetMTUFailure(new GattException(finalStatus));
                        }
                    }
                });
            }
        }
    };

    public BleBluetooth(BleDevice bleDevice) {
        this.bleBluetooth = this;
        this.bleDevice = bleDevice;
    }

    public BleConnector newBleConnector() {
        return new BleConnector(this);
    }

    public synchronized void addConnectGattCallback(BleGattCallback callback) {
        this.bleGattCallback = callback;
    }

    public synchronized void removeConnectGattCallback() {
        this.bleGattCallback = null;
    }

    public synchronized void addNotifyCallback(String uuid, BleNotifyCallback bleNotifyCallback) {
        this.bleNotifyCallbackHashMap.put(uuid, bleNotifyCallback);
    }

    public synchronized void addIndicateCallback(String uuid, BleIndicateCallback bleIndicateCallback) {
        this.bleIndicateCallbackHashMap.put(uuid, bleIndicateCallback);
    }

    public synchronized void addWriteCallback(String uuid, BleWriteCallback bleWriteCallback) {
        this.bleWriteCallbackHashMap.put(uuid, bleWriteCallback);
    }

    public synchronized void addReadCallback(String uuid, BleReadCallback bleReadCallback) {
        this.bleReadCallbackHashMap.put(uuid, bleReadCallback);
    }

    public synchronized void removeNotifyCallback(String uuid) {
        if (this.bleNotifyCallbackHashMap.containsKey(uuid)) {
            this.bleNotifyCallbackHashMap.remove(uuid);
        }
    }

    public synchronized void removeIndicateCallback(String uuid) {
        if (this.bleIndicateCallbackHashMap.containsKey(uuid)) {
            this.bleIndicateCallbackHashMap.remove(uuid);
        }
    }

    public synchronized void removeWriteCallback(String uuid) {
        if (this.bleWriteCallbackHashMap.containsKey(uuid)) {
            this.bleWriteCallbackHashMap.remove(uuid);
        }
    }

    public synchronized void removeReadCallback(String uuid) {
        if (this.bleReadCallbackHashMap.containsKey(uuid)) {
            this.bleReadCallbackHashMap.remove(uuid);
        }
    }

    public synchronized void clearCharacterCallback() {
        if (this.bleNotifyCallbackHashMap != null) {
            this.bleNotifyCallbackHashMap.clear();
        }
        if (this.bleIndicateCallbackHashMap != null) {
            this.bleIndicateCallbackHashMap.clear();
        }
        if (this.bleWriteCallbackHashMap != null) {
            this.bleWriteCallbackHashMap.clear();
        }
        if (this.bleReadCallbackHashMap != null) {
            this.bleReadCallbackHashMap.clear();
        }
    }

    public synchronized void addRssiCallback(BleRssiCallback callback) {
        this.bleRssiCallback = callback;
    }

    public synchronized void removeRssiCallback() {
        this.bleRssiCallback = null;
    }

    public synchronized void addMtuChangedCallback(BleMtuChangedCallback callback) {
        this.bleMtuChangedCallback = callback;
    }

    public synchronized void removeMtuChangedCallback() {
        this.bleMtuChangedCallback = null;
    }

    public String getDeviceKey() {
        return this.bleDevice.getKey();
    }

    public BleConnectState getConnectState() {
        return this.connectState;
    }

    public BleDevice getDevice() {
        return this.bleDevice;
    }

    public BluetoothGatt getBluetoothGatt() {
        return this.bluetoothGatt;
    }

    public synchronized BluetoothGatt connect(BleDevice bleDevice, boolean autoConnect, BleGattCallback callback) {
        BleLog.i("connect device: " + bleDevice.getName() + "\nmac: " + bleDevice.getMac() + "\nautoConnect: " + autoConnect);
        this.addConnectGattCallback(callback);
        BluetoothGatt gatt = Build.VERSION.SDK_INT >= 23 ? bleDevice.getDevice().connectGatt(BleManager.getInstance().getContext(), autoConnect, this.coreGattCallback, 2) : bleDevice.getDevice().connectGatt(BleManager.getInstance().getContext(), autoConnect, this.coreGattCallback);
        if (gatt != null) {
            if (this.bleGattCallback != null) {
                this.bleGattCallback.onStartConnect();
            }
            this.connectState = BleConnectState.CONNECT_CONNECTING;
        }
        return gatt;
    }

    public synchronized boolean refreshDeviceCache() {
        try {
            Method refresh = BluetoothGatt.class.getMethod("refresh", new Class[0]);
            if (refresh != null) {
                boolean success = (Boolean)refresh.invoke((Object)this.getBluetoothGatt(), new Object[0]);
                BleLog.i("refreshDeviceCache, is success:  " + success);
                return success;
            }
        }
        catch (Exception e) {
            BleLog.i("exception occur while refreshing device: " + e.getMessage());
            e.printStackTrace();
        }
        return false;
    }

    public synchronized void disconnect() {
        if (this.bluetoothGatt != null) {
            this.isActivityDisconnect = true;
            this.bluetoothGatt.disconnect();
        }
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
        }
    }

    private synchronized void closeBluetoothGatt() {
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.close();
        }
    }

    public synchronized void destroy() {
        this.connectState = BleConnectState.CONNECT_IDLE;
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.disconnect();
        }
        if (this.bluetoothGatt != null) {
            this.refreshDeviceCache();
        }
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.close();
        }
        this.removeConnectGattCallback();
        this.removeRssiCallback();
        this.removeMtuChangedCallback();
        this.clearCharacterCallback();
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
        }
    }
}

