/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.clj.fastble.BleManager;
import com.clj.fastble.bluetooth.BleConnector;
import com.clj.fastble.callback.BleGattCallback;
import com.clj.fastble.callback.BleIndicateCallback;
import com.clj.fastble.callback.BleMtuChangedCallback;
import com.clj.fastble.callback.BleNotifyCallback;
import com.clj.fastble.callback.BleReadCallback;
import com.clj.fastble.callback.BleRssiCallback;
import com.clj.fastble.callback.BleWriteCallback;
import com.clj.fastble.data.BleConnectState;
import com.clj.fastble.data.BleDevice;
import com.clj.fastble.exception.ConnectException;
import com.clj.fastble.exception.GattException;
import com.clj.fastble.utils.BleLog;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

@TargetApi(value=18)
public class BleBluetooth {
    private BleConnectState connectState = BleConnectState.CONNECT_IDLE;
    private Handler handler = new Handler(Looper.getMainLooper());
    private boolean isActivityDisconnect = false;
    private BleGattCallback bleGattCallback;
    private BleRssiCallback bleRssiCallback;
    private BleMtuChangedCallback bleMtuChangedCallback;
    private HashMap<String, BleNotifyCallback> bleNotifyCallbackHashMap = new HashMap();
    private HashMap<String, BleIndicateCallback> bleIndicateCallbackHashMap = new HashMap();
    private HashMap<String, BleWriteCallback> bleWriteCallbackHashMap = new HashMap();
    private HashMap<String, BleReadCallback> bleReadCallbackHashMap = new HashMap();
    private BleBluetooth bleBluetooth;
    private BleDevice bleDevice;
    private BluetoothGatt bluetoothGatt;
    private BluetoothGattCallback coreGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(final BluetoothGatt gatt, final int status, final int newState) {
            super.onConnectionStateChange(gatt, status, newState);
            BleLog.i("BluetoothGattCallback\uff1aonConnectionStateChange \nstatus: " + status + '\n' + "newState: " + newState + '\n' + "currentThread: " + Thread.currentThread().getId());
            if (newState == 2) {
                gatt.discoverServices();
            } else if (newState == 0) {
                BleBluetooth.this.closeBluetoothGatt();
                BleManager.getInstance().getMultipleBluetoothController().removeBleBluetooth(BleBluetooth.this.bleBluetooth);
                if (BleBluetooth.this.connectState == BleConnectState.CONNECT_CONNECTING) {
                    BleBluetooth.this.connectState = BleConnectState.CONNECT_FAILURE;
                    BleBluetooth.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (BleBluetooth.this.bleGattCallback != null) {
                                BleBluetooth.this.bleGattCallback.onConnectFail(new ConnectException(gatt, status));
                            }
                        }
                    });
                } else if (BleBluetooth.this.connectState == BleConnectState.CONNECT_CONNECTED) {
                    BleBluetooth.this.connectState = BleConnectState.CONNECT_DISCONNECT;
                    BleBluetooth.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (BleBluetooth.this.bleGattCallback != null) {
                                BleBluetooth.this.bleGattCallback.onDisConnected(BleBluetooth.this.isActivityDisconnect, BleBluetooth.this.bleBluetooth.getDevice(), gatt, newState);
                            }
                        }
                    });
                }
            }
        }

        public void onServicesDiscovered(final BluetoothGatt gatt, final int status) {
            super.onServicesDiscovered(gatt, status);
            BleLog.i("BluetoothGattCallback\uff1aonServicesDiscovered \nstatus: " + status + '\n' + "currentThread: " + Thread.currentThread().getId());
            if (status == 0) {
                BleBluetooth.this.bluetoothGatt = gatt;
                BleBluetooth.this.connectState = BleConnectState.CONNECT_CONNECTED;
                BleBluetooth.this.isActivityDisconnect = false;
                BleManager.getInstance().getMultipleBluetoothController().addBleBluetooth(BleBluetooth.this.bleBluetooth);
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (BleBluetooth.this.bleGattCallback != null) {
                            BleBluetooth.this.bleGattCallback.onConnectSuccess(BleBluetooth.this.bleDevice, gatt, status);
                        }
                    }
                });
            } else {
                BleBluetooth.this.closeBluetoothGatt();
                BleBluetooth.this.connectState = BleConnectState.CONNECT_FAILURE;
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (BleBluetooth.this.bleGattCallback != null) {
                            BleBluetooth.this.bleGattCallback.onConnectFail(new ConnectException(gatt, status));
                        }
                    }
                });
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, final BluetoothGattCharacteristic characteristic) {
            Object call;
            super.onCharacteristicChanged(gatt, characteristic);
            BleLog.i("BluetoothGattCallback\uff1aonCharacteristicChanged ");
            for (Map.Entry entry : BleBluetooth.this.bleNotifyCallbackHashMap.entrySet()) {
                call = entry.getValue();
                if (!(call instanceof BleNotifyCallback) || !characteristic.getUuid().toString().equals(((BleNotifyCallback)call).getKey())) continue;
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        ((BleNotifyCallback)call).onCharacteristicChanged(characteristic.getValue());
                    }
                });
            }
            for (Map.Entry entry : BleBluetooth.this.bleIndicateCallbackHashMap.entrySet()) {
                call = entry.getValue();
                if (!(call instanceof BleIndicateCallback) || !characteristic.getUuid().toString().equals(((BleIndicateCallback)call).getKey())) continue;
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        ((BleIndicateCallback)call).onCharacteristicChanged(characteristic.getValue());
                    }
                });
            }
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, final int status) {
            Object call;
            super.onDescriptorWrite(gatt, descriptor, status);
            BleLog.i("BleGattCallback\uff1aonDescriptorWrite ");
            for (Map.Entry entry : BleBluetooth.this.bleNotifyCallbackHashMap.entrySet()) {
                call = entry.getValue();
                if (!(call instanceof BleNotifyCallback) || !descriptor.getCharacteristic().getUuid().toString().equals(((BleNotifyCallback)call).getKey())) continue;
                ((BleNotifyCallback)call).getBleConnector().notifyMsgInit();
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (status == 0) {
                            ((BleNotifyCallback)call).onNotifySuccess();
                        } else {
                            ((BleNotifyCallback)call).onNotifyFailure(new GattException(status));
                        }
                    }
                });
            }
            for (Map.Entry entry : BleBluetooth.this.bleIndicateCallbackHashMap.entrySet()) {
                call = entry.getValue();
                if (!(call instanceof BleIndicateCallback) || !descriptor.getCharacteristic().getUuid().toString().equals(((BleIndicateCallback)call).getKey())) continue;
                ((BleIndicateCallback)call).getBleConnector().indicateMsgInit();
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (status == 0) {
                            ((BleIndicateCallback)call).onIndicateSuccess();
                        } else {
                            ((BleIndicateCallback)call).onIndicateFailure(new GattException(status));
                        }
                    }
                });
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, final int status) {
            super.onCharacteristicWrite(gatt, characteristic, status);
            BleLog.i("BluetoothGattCallback\uff1aonCharacteristicWrite ");
            for (Map.Entry entry : BleBluetooth.this.bleWriteCallbackHashMap.entrySet()) {
                final Object call = entry.getValue();
                if (!(call instanceof BleWriteCallback) || !characteristic.getUuid().toString().equals(((BleWriteCallback)call).getKey())) continue;
                ((BleWriteCallback)call).getBleConnector().writeMsgInit();
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (status == 0) {
                            ((BleWriteCallback)call).onWriteSuccess();
                        } else {
                            ((BleWriteCallback)call).onWriteFailure(new GattException(status));
                        }
                    }
                });
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, final BluetoothGattCharacteristic characteristic, final int status) {
            super.onCharacteristicRead(gatt, characteristic, status);
            BleLog.i("BluetoothGattCallback\uff1aonCharacteristicRead ");
            for (Map.Entry entry : BleBluetooth.this.bleReadCallbackHashMap.entrySet()) {
                final Object call = entry.getValue();
                if (!(call instanceof BleReadCallback) || !characteristic.getUuid().toString().equals(((BleReadCallback)call).getKey())) continue;
                ((BleReadCallback)call).getBleConnector().readMsgInit();
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (status == 0) {
                            ((BleReadCallback)call).onReadSuccess(characteristic.getValue());
                        } else {
                            ((BleReadCallback)call).onReadFailure(new GattException(status));
                        }
                    }
                });
            }
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, final int rssi, final int status) {
            super.onReadRemoteRssi(gatt, rssi, status);
            BleLog.i("BluetoothGattCallback\uff1aonReadRemoteRssi " + status);
            if (BleBluetooth.this.bleRssiCallback != null) {
                BleBluetooth.this.bleRssiCallback.getBleConnector().rssiMsgInit();
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (status == 0) {
                            BleBluetooth.this.bleRssiCallback.onRssiSuccess(rssi);
                        } else {
                            BleBluetooth.this.bleRssiCallback.onRssiFailure(new GattException(status));
                        }
                    }
                });
            }
        }

        public void onMtuChanged(BluetoothGatt gatt, final int mtu, final int status) {
            super.onMtuChanged(gatt, mtu, status);
            BleLog.i("BluetoothGattCallback\uff1aonMtuChanged ");
            if (BleBluetooth.this.bleMtuChangedCallback != null) {
                BleBluetooth.this.bleMtuChangedCallback.getBleConnector().mtuChangedMsgInit();
                BleBluetooth.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (status == 0) {
                            BleBluetooth.this.bleMtuChangedCallback.onMtuChanged(mtu);
                        } else {
                            BleBluetooth.this.bleMtuChangedCallback.onSetMTUFailure(new GattException(status));
                        }
                    }
                });
            }
        }
    };

    public BleBluetooth(BleDevice bleDevice) {
        this.bleBluetooth = this;
        this.bleDevice = bleDevice;
    }

    public BleConnector newBleConnector() {
        return new BleConnector(this);
    }

    public synchronized void addConnectGattCallback(BleGattCallback callback) {
        this.bleGattCallback = callback;
    }

    public synchronized void removeConnectGattCallback() {
        this.bleGattCallback = null;
    }

    public synchronized void addNotifyCallback(String uuid, BleNotifyCallback bleNotifyCallback) {
        this.bleNotifyCallbackHashMap.put(uuid, bleNotifyCallback);
    }

    public synchronized void addIndicateCallback(String uuid, BleIndicateCallback bleIndicateCallback) {
        this.bleIndicateCallbackHashMap.put(uuid, bleIndicateCallback);
    }

    public synchronized void addWriteCallback(String uuid, BleWriteCallback bleWriteCallback) {
        this.bleWriteCallbackHashMap.put(uuid, bleWriteCallback);
    }

    public synchronized void addReadCallback(String uuid, BleReadCallback bleReadCallback) {
        this.bleReadCallbackHashMap.put(uuid, bleReadCallback);
    }

    public synchronized void removeNotifyCallback(String uuid) {
        if (this.bleNotifyCallbackHashMap.containsKey(uuid)) {
            this.bleNotifyCallbackHashMap.remove(uuid);
        }
    }

    public synchronized void removeIndicateCallback(String uuid) {
        if (this.bleIndicateCallbackHashMap.containsKey(uuid)) {
            this.bleIndicateCallbackHashMap.remove(uuid);
        }
    }

    public synchronized void removeWriteCallback(String uuid) {
        if (this.bleWriteCallbackHashMap.containsKey(uuid)) {
            this.bleWriteCallbackHashMap.remove(uuid);
        }
    }

    public synchronized void removeReadCallback(String uuid) {
        if (this.bleReadCallbackHashMap.containsKey(uuid)) {
            this.bleReadCallbackHashMap.remove(uuid);
        }
    }

    public synchronized void clearCharacterCallback() {
        if (this.bleNotifyCallbackHashMap != null) {
            this.bleNotifyCallbackHashMap.clear();
        }
        if (this.bleIndicateCallbackHashMap != null) {
            this.bleIndicateCallbackHashMap.clear();
        }
        if (this.bleWriteCallbackHashMap != null) {
            this.bleWriteCallbackHashMap.clear();
        }
        if (this.bleReadCallbackHashMap != null) {
            this.bleReadCallbackHashMap.clear();
        }
    }

    public synchronized void addRssiCallback(BleRssiCallback callback) {
        this.bleRssiCallback = callback;
    }

    public synchronized void removeRssiCallback() {
        this.bleRssiCallback = null;
    }

    public synchronized void addMtuChangedCallback(BleMtuChangedCallback callback) {
        this.bleMtuChangedCallback = callback;
    }

    public synchronized void removeMtuChangedCallback() {
        this.bleMtuChangedCallback = null;
    }

    public String getDeviceKey() {
        return this.bleDevice.getKey();
    }

    public BleConnectState getConnectState() {
        return this.connectState;
    }

    public BleDevice getDevice() {
        return this.bleDevice;
    }

    public BluetoothGatt getBluetoothGatt() {
        return this.bluetoothGatt;
    }

    public synchronized BluetoothGatt connect(BleDevice bleDevice, boolean autoConnect, BleGattCallback callback) {
        BleLog.i("connect device: " + bleDevice.getName() + "\nmac: " + bleDevice.getMac() + "\nautoConnect: " + autoConnect);
        this.addConnectGattCallback(callback);
        BluetoothGatt gatt = Build.VERSION.SDK_INT >= 23 ? bleDevice.getDevice().connectGatt(BleManager.getInstance().getContext(), autoConnect, this.coreGattCallback, 2) : bleDevice.getDevice().connectGatt(BleManager.getInstance().getContext(), autoConnect, this.coreGattCallback);
        if (gatt != null) {
            if (this.bleGattCallback != null) {
                this.bleGattCallback.onStartConnect();
            }
            this.connectState = BleConnectState.CONNECT_CONNECTING;
        }
        return gatt;
    }

    public synchronized boolean refreshDeviceCache() {
        try {
            Method refresh = BluetoothGatt.class.getMethod("refresh", new Class[0]);
            if (refresh != null) {
                boolean success = (Boolean)refresh.invoke((Object)this.getBluetoothGatt(), new Object[0]);
                BleLog.i("refreshDeviceCache, is success:  " + success);
                return success;
            }
        }
        catch (Exception e) {
            BleLog.i("exception occur while refreshing device: " + e.getMessage());
            e.printStackTrace();
        }
        return false;
    }

    public synchronized void disconnect() {
        if (this.bluetoothGatt != null) {
            this.isActivityDisconnect = true;
            this.bluetoothGatt.disconnect();
        }
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
        }
    }

    private synchronized void closeBluetoothGatt() {
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.close();
        }
    }

    public synchronized void destroy() {
        this.connectState = BleConnectState.CONNECT_IDLE;
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.disconnect();
        }
        if (this.bluetoothGatt != null) {
            this.refreshDeviceCache();
        }
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.close();
        }
        this.removeConnectGattCallback();
        this.removeRssiCallback();
        this.removeMtuChangedCallback();
        this.clearCharacterCallback();
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
        }
    }
}

