/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble;

import android.annotation.TargetApi;
import android.app.Application;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Build;
import com.clj.fastble.bluetooth.BleBluetooth;
import com.clj.fastble.bluetooth.MultipleBluetoothController;
import com.clj.fastble.callback.BleGattCallback;
import com.clj.fastble.callback.BleIndicateCallback;
import com.clj.fastble.callback.BleMtuChangedCallback;
import com.clj.fastble.callback.BleNotifyCallback;
import com.clj.fastble.callback.BleReadCallback;
import com.clj.fastble.callback.BleRssiCallback;
import com.clj.fastble.callback.BleScanAndConnectCallback;
import com.clj.fastble.callback.BleScanCallback;
import com.clj.fastble.callback.BleWriteCallback;
import com.clj.fastble.data.BleConnectState;
import com.clj.fastble.data.BleDevice;
import com.clj.fastble.data.BleScanState;
import com.clj.fastble.exception.BleException;
import com.clj.fastble.exception.NotFoundDeviceException;
import com.clj.fastble.exception.OtherException;
import com.clj.fastble.exception.hanlder.DefaultBleExceptionHandler;
import com.clj.fastble.scan.BleScanRuleConfig;
import com.clj.fastble.scan.BleScanner;
import com.clj.fastble.utils.BleLog;
import java.util.List;
import java.util.UUID;

@TargetApi(value=18)
public class BleManager {
    private Application context;
    private BleScanRuleConfig bleScanRuleConfig;
    private BleScanner bleScanner;
    private BluetoothAdapter bluetoothAdapter;
    private MultipleBluetoothController multipleBluetoothController;
    private DefaultBleExceptionHandler bleExceptionHandler;
    public static final int DEFAULT_SCAN_TIME = 10000;
    private static final int DEFAULT_MAX_MULTIPLE_DEVICE = 7;
    private static final int DEFAULT_OPERATE_TIME = 5000;
    private static final int DEFAULT_MTU = 23;
    private static final int DEFAULT_MAX_MTU = 512;
    private int maxConnectCount = 7;
    private int operateTimeout = 5000;

    public static BleManager getInstance() {
        return BleManagerHolder.sBleManager;
    }

    public void init(Application app) {
        if (this.context == null && app != null) {
            this.context = app;
            BluetoothManager bluetoothManager = (BluetoothManager)this.context.getSystemService("bluetooth");
            if (bluetoothManager != null) {
                this.bluetoothAdapter = bluetoothManager.getAdapter();
            }
            this.bleExceptionHandler = new DefaultBleExceptionHandler();
            this.multipleBluetoothController = new MultipleBluetoothController();
            this.bleScanner = BleScanner.getInstance();
        }
    }

    public Context getContext() {
        return this.context;
    }

    public BluetoothAdapter getBluetoothAdapter() {
        return this.bluetoothAdapter;
    }

    public BleScanner getBleScanner() {
        return this.bleScanner;
    }

    public BleScanRuleConfig getScanRuleConfig() {
        return this.bleScanRuleConfig;
    }

    public void handleException(BleException exception) {
        this.bleExceptionHandler.handleException(exception);
    }

    public MultipleBluetoothController getMultipleBluetoothController() {
        return this.multipleBluetoothController;
    }

    public void initScanRule(BleScanRuleConfig scanRuleConfig) {
        this.bleScanRuleConfig = scanRuleConfig;
    }

    public int getMaxConnectCount() {
        return this.maxConnectCount;
    }

    public BleManager setMaxConnectCount(int maxCount) {
        if (maxCount > 7) {
            maxCount = 7;
        }
        this.maxConnectCount = maxCount;
        return this;
    }

    public int getOperateTimeout() {
        return this.operateTimeout;
    }

    public BleManager setOperateTimeout(int operateTimeout) {
        this.operateTimeout = operateTimeout;
        return this;
    }

    public BleManager enableLog(boolean enable) {
        BleLog.isPrint = enable;
        return this;
    }

    public void scan(BleScanCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("BleScanCallback can not be Null!");
        }
        if (!this.isBlueEnable()) {
            this.handleException(new OtherException("BlueTooth not enable!"));
            return;
        }
        UUID[] serviceUuids = this.bleScanRuleConfig.getServiceUuids();
        String[] deviceNames = this.bleScanRuleConfig.getDeviceNames();
        String deviceMac = this.bleScanRuleConfig.getDeviceMac();
        boolean fuzzy = this.bleScanRuleConfig.isFuzzy();
        long timeOut = this.bleScanRuleConfig.getScanTimeOut();
        this.bleScanner.scan(serviceUuids, deviceNames, deviceMac, fuzzy, timeOut, callback);
    }

    public void scanAndConnect(BleScanAndConnectCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("BleScanAndConnectCallback can not be Null!");
        }
        if (!this.isBlueEnable()) {
            this.handleException(new OtherException("BlueTooth not enable!"));
            return;
        }
        UUID[] serviceUuids = this.bleScanRuleConfig.getServiceUuids();
        String[] deviceNames = this.bleScanRuleConfig.getDeviceNames();
        String deviceMac = this.bleScanRuleConfig.getDeviceMac();
        boolean fuzzy = this.bleScanRuleConfig.isFuzzy();
        long timeOut = this.bleScanRuleConfig.getScanTimeOut();
        this.bleScanner.scanAndConnect(serviceUuids, deviceNames, deviceMac, fuzzy, timeOut, callback);
    }

    public BluetoothGatt connect(BleDevice bleDevice, BleGattCallback bleGattCallback) {
        if (bleGattCallback == null) {
            throw new IllegalArgumentException("BleGattCallback can not be Null!");
        }
        if (!this.isBlueEnable()) {
            this.handleException(new OtherException("BlueTooth not enable!"));
            return null;
        }
        if (bleDevice != null && bleDevice.getDevice() != null) {
            BleBluetooth bleBluetooth = new BleBluetooth(bleDevice);
            boolean autoConnect = this.bleScanRuleConfig.isAutoConnect();
            return bleBluetooth.connect(bleDevice, autoConnect, bleGattCallback);
        }
        bleGattCallback.onConnectFail(new NotFoundDeviceException());
        return null;
    }

    public void cancelScan() {
        this.bleScanner.stopLeScan();
    }

    public void notify(BleDevice bleDevice, String uuid_service, String uuid_notify, BleNotifyCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("BleNotifyCallback can not be Null!");
        }
        BleBluetooth bleBluetooth = this.multipleBluetoothController.getBleBluetooth(bleDevice);
        if (bleBluetooth == null) {
            callback.onNotifyFailure(new OtherException("This device not connect!"));
        } else {
            bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_notify).enableCharacteristicNotify(callback, uuid_notify);
        }
    }

    public void indicate(BleDevice bleDevice, String uuid_service, String uuid_indicate, BleIndicateCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("BleIndicateCallback can not be Null!");
        }
        BleBluetooth bleBluetooth = this.multipleBluetoothController.getBleBluetooth(bleDevice);
        if (bleBluetooth == null) {
            callback.onIndicateFailure(new OtherException("This device not connect!"));
        } else {
            bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_indicate).enableCharacteristicIndicate(callback, uuid_indicate);
        }
    }

    public boolean stopNotify(BleDevice bleDevice, String uuid_service, String uuid_notify) {
        BleBluetooth bleBluetooth = this.multipleBluetoothController.getBleBluetooth(bleDevice);
        if (bleBluetooth == null) {
            return false;
        }
        boolean success = bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_notify).disableCharacteristicNotify();
        if (success) {
            bleBluetooth.removeNotifyCallback(uuid_notify);
        }
        return success;
    }

    public boolean stopIndicate(BleDevice bleDevice, String uuid_service, String uuid_indicate) {
        BleBluetooth bleBluetooth = this.multipleBluetoothController.getBleBluetooth(bleDevice);
        if (bleBluetooth == null) {
            return false;
        }
        boolean success = bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_indicate).disableCharacteristicIndicate();
        if (success) {
            bleBluetooth.removeIndicateCallback(uuid_indicate);
        }
        return success;
    }

    public void write(BleDevice bleDevice, String uuid_service, String uuid_write, byte[] data, BleWriteCallback callback) {
        BleBluetooth bleBluetooth;
        if (callback == null) {
            throw new IllegalArgumentException("BleWriteCallback can not be Null!");
        }
        if (data == null) {
            BleLog.e("data is Null!");
            callback.onWriteFailure(new OtherException("data is Null !"));
            return;
        }
        if (data.length > 20) {
            BleLog.w("data's length beyond 20!");
        }
        if ((bleBluetooth = this.multipleBluetoothController.getBleBluetooth(bleDevice)) == null) {
            callback.onWriteFailure(new OtherException("This device not connect!"));
        } else {
            bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_write).writeCharacteristic(data, callback, uuid_write);
        }
    }

    public void read(BleDevice bleDevice, String uuid_service, String uuid_read, BleReadCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("BleReadCallback can not be Null!");
        }
        BleBluetooth bleBluetooth = this.multipleBluetoothController.getBleBluetooth(bleDevice);
        if (bleBluetooth == null) {
            callback.onReadFailure(new OtherException("this device not connect!"));
        } else {
            bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_read).readCharacteristic(callback, uuid_read);
        }
    }

    public void readRssi(BleDevice bleDevice, BleRssiCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("BleRssiCallback can not be Null!");
        }
        BleBluetooth bleBluetooth = this.multipleBluetoothController.getBleBluetooth(bleDevice);
        if (bleBluetooth == null) {
            callback.onRssiFailure(new OtherException("This device not connect!"));
        } else {
            bleBluetooth.newBleConnector().readRemoteRssi(callback);
        }
    }

    public void setMtu(BleDevice bleDevice, int mtu, BleMtuChangedCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("BleMtuChangedCallback can not be Null!");
        }
        if (mtu > 512) {
            BleLog.e("requiredMtu should lower than 512 !");
            callback.onsetMTUFailure(new OtherException("requiredMtu should lower than 512 !"));
            return;
        }
        if (mtu < 23) {
            BleLog.e("requiredMtu should higher than 23 !");
            callback.onsetMTUFailure(new OtherException("requiredMtu should higher than 23 !"));
            return;
        }
        BleBluetooth bleBluetooth = this.multipleBluetoothController.getBleBluetooth(bleDevice);
        if (bleBluetooth == null) {
            callback.onsetMTUFailure(new OtherException("This device not connect!"));
        } else {
            bleBluetooth.newBleConnector().setMtu(mtu, callback);
        }
    }

    public boolean isSupportBle() {
        return Build.VERSION.SDK_INT >= 18 && this.context.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    public void enableBluetooth() {
        if (this.bluetoothAdapter != null) {
            this.bluetoothAdapter.enable();
        }
    }

    public void disableBluetooth() {
        if (this.bluetoothAdapter != null && this.bluetoothAdapter.isEnabled()) {
            this.bluetoothAdapter.disable();
        }
    }

    public boolean isBlueEnable() {
        return this.bluetoothAdapter != null && this.bluetoothAdapter.isEnabled();
    }

    public BleBluetooth getBleBluetooth(BleDevice bleDevice) {
        if (this.multipleBluetoothController != null) {
            return this.multipleBluetoothController.getBleBluetooth(bleDevice);
        }
        return null;
    }

    public List<BleDevice> getAllConnectedDevice() {
        if (this.multipleBluetoothController == null) {
            return null;
        }
        return this.multipleBluetoothController.getDeviceList();
    }

    public BluetoothGatt getBluetoothGatt(BleDevice bleDevice) {
        BleBluetooth bleBluetooth = this.getBleBluetooth(bleDevice);
        if (bleBluetooth != null) {
            return bleBluetooth.getBluetoothGatt();
        }
        return null;
    }

    public BleScanState getScanSate() {
        return this.bleScanner.getScanState();
    }

    public BleConnectState getConnectState(BleDevice bleDevice) {
        if (this.multipleBluetoothController != null) {
            return this.multipleBluetoothController.getConnectState(bleDevice);
        }
        return BleConnectState.CONNECT_IDLE;
    }

    public boolean isConnected(BleDevice bleDevice) {
        if (this.multipleBluetoothController != null) {
            return this.multipleBluetoothController.isContainDevice(bleDevice);
        }
        return false;
    }

    public void disconnect(BleDevice bleDevice) {
        if (this.multipleBluetoothController != null) {
            this.multipleBluetoothController.disconnect(bleDevice);
        }
    }

    public void disconnectAllDevice() {
        if (this.multipleBluetoothController != null) {
            this.multipleBluetoothController.disconnectAllDevice();
        }
    }

    public void destroy() {
        if (this.multipleBluetoothController != null) {
            this.multipleBluetoothController.destroy();
        }
    }

    private static class BleManagerHolder {
        private static final BleManager sBleManager = new BleManager();

        private BleManagerHolder() {
        }
    }
}

