/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.scan;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.os.Handler;
import android.os.Looper;
import com.clj.fastble.BleManager;
import com.clj.fastble.callback.BleScanAndConnectCallback;
import com.clj.fastble.callback.BleScanCallback;
import com.clj.fastble.data.BleDevice;
import com.clj.fastble.data.BleScanState;
import com.clj.fastble.scan.BleScanPresenter;
import java.util.List;
import java.util.UUID;

@TargetApi(value=18)
public class BleScanner {
    private BleScanPresenter scanCallback;
    private BleScanState scanState = BleScanState.STATE_IDLE;

    public static BleScanner getInstance() {
        return BleScannerHolder.sBleScanner;
    }

    public void scan(UUID[] serviceUuids, String[] names, String mac, boolean fuzzy, long timeOut, final BleScanCallback callback) {
        this.startLeScan(serviceUuids, new BleScanPresenter(names, mac, fuzzy, false, timeOut){

            @Override
            public void onScanStarted(boolean success) {
                if (callback != null) {
                    callback.onScanStarted(success);
                }
            }

            @Override
            public void onScanning(BleDevice result) {
                if (callback != null) {
                    callback.onScanning(result);
                }
            }

            @Override
            public void onScanFinished(List<BleDevice> scanResultList) {
                if (callback != null) {
                    callback.onScanFinished(scanResultList);
                }
            }
        });
    }

    private synchronized void startLeScan(UUID[] serviceUuids, BleScanPresenter callback) {
        if (callback == null) {
            return;
        }
        this.scanCallback = callback;
        boolean success = BleManager.getInstance().getBluetoothAdapter().startLeScan(serviceUuids, (BluetoothAdapter.LeScanCallback)this.scanCallback);
        if (success) {
            this.scanState = BleScanState.STATE_SCANNING;
            this.scanCallback.notifyScanStarted(true);
        } else {
            this.scanCallback.notifyScanStarted(false);
            callback.removeHandlerMsg();
        }
    }

    public synchronized void stopLeScan() {
        if (this.scanCallback == null) {
            return;
        }
        BleManager.getInstance().getBluetoothAdapter().stopLeScan((BluetoothAdapter.LeScanCallback)this.scanCallback);
        this.scanCallback.notifyScanStopped();
        this.scanCallback = null;
        if (this.scanState == BleScanState.STATE_SCANNING) {
            this.scanState = BleScanState.STATE_IDLE;
        }
    }

    public void scanAndConnect(UUID[] serviceUuids, String[] names, String mac, boolean fuzzy, long timeOut, final BleScanAndConnectCallback callback) {
        this.startLeScan(serviceUuids, new BleScanPresenter(names, mac, fuzzy, true, timeOut){

            @Override
            public void onScanStarted(boolean success) {
                if (callback != null) {
                    callback.onScanStarted(success);
                }
            }

            @Override
            public void onScanning(BleDevice bleDevice) {
            }

            @Override
            public void onScanFinished(final List<BleDevice> bleDeviceList) {
                if (bleDeviceList == null || bleDeviceList.size() < 1) {
                    if (callback != null) {
                        callback.onScanFinished(null);
                    }
                } else {
                    if (callback != null) {
                        callback.onScanFinished(bleDeviceList.get(0));
                    }
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            BleManager.getInstance().connect((BleDevice)bleDeviceList.get(0), callback);
                        }
                    });
                }
            }
        });
    }

    private static class BleScannerHolder {
        private static final BleScanner sBleScanner = new BleScanner();

        private BleScannerHolder() {
        }
    }
}

