/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.scan;

import com.clj.fastble.BleManager;
import java.util.UUID;

public class BleScanRuleConfig {
    private UUID[] mServiceUuids = null;
    private String[] mDeviceNames = null;
    private String mDeviceMac = null;
    private boolean mAutoConnect = false;
    private boolean mFuzzy = false;
    private long mTimeOut = BleManager.getInstance().getScanTimeout();

    public UUID[] getServiceUuids() {
        return this.mServiceUuids;
    }

    public String[] getDeviceNames() {
        return this.mDeviceNames;
    }

    public String getDeviceMac() {
        return this.mDeviceMac;
    }

    public boolean isAutoConnect() {
        return this.mAutoConnect;
    }

    public boolean isFuzzy() {
        return this.mFuzzy;
    }

    public long getTimeOut() {
        return this.mTimeOut;
    }

    static /* synthetic */ UUID[] access$002(BleScanRuleConfig x0, UUID[] x1) {
        x0.mServiceUuids = x1;
        return x1;
    }

    static /* synthetic */ String[] access$102(BleScanRuleConfig x0, String[] x1) {
        x0.mDeviceNames = x1;
        return x1;
    }

    public static class Builder {
        private UUID[] mServiceUuids = null;
        private String[] mDeviceNames = null;
        private String mDeviceMac = null;
        private boolean mAutoConnect = false;
        private boolean mFuzzy = false;
        private long mTimeOut = 5000L;

        public Builder setServiceUuids(UUID[] uuids) {
            this.mServiceUuids = uuids;
            return this;
        }

        public Builder setDeviceName(boolean fuzzy, String ... name) {
            this.mFuzzy = fuzzy;
            this.mDeviceNames = name;
            return this;
        }

        public Builder setDeviceMac(String mac) {
            this.mDeviceMac = mac;
            return this;
        }

        public Builder setAutoConnect(boolean autoConnect) {
            this.mAutoConnect = autoConnect;
            return this;
        }

        public Builder setScanTimeOut(long timeOut) {
            this.mTimeOut = timeOut;
            return this;
        }

        void applyConfig(BleScanRuleConfig config) {
            BleScanRuleConfig.access$002(config, this.mServiceUuids);
            BleScanRuleConfig.access$102(config, this.mDeviceNames);
            config.mDeviceMac = this.mDeviceMac;
            config.mAutoConnect = this.mAutoConnect;
            config.mFuzzy = this.mFuzzy;
            config.mTimeOut = this.mTimeOut;
        }

        public BleScanRuleConfig build() {
            BleScanRuleConfig config = new BleScanRuleConfig();
            this.applyConfig(config);
            return config;
        }
    }
}

