/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.scan;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.clj.fastble.BleManager;
import com.clj.fastble.data.BleDevice;
import com.clj.fastble.utils.BleLog;
import com.clj.fastble.utils.HexUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=18)
public abstract class BleScanPresenter
implements BluetoothAdapter.LeScanCallback {
    private String[] mDeviceNames = null;
    private String mDeviceMac = null;
    private boolean mFuzzy = false;
    private boolean mNeedConnect = false;
    private List<BleDevice> mBleDeviceList = new ArrayList<BleDevice>();
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private long mScanTimeout = BleManager.getInstance().getScanTimeout();

    public BleScanPresenter(String[] names, String mac, boolean fuzzy, boolean needConnect, long timeOut) {
        this.mDeviceNames = names;
        this.mDeviceMac = mac;
        this.mFuzzy = fuzzy;
        this.mNeedConnect = needConnect;
        this.mScanTimeout = timeOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (device == null) {
            return;
        }
        BleDevice scanResult = new BleDevice(device, rssi, scanRecord, System.currentTimeMillis());
        BleScanPresenter bleScanPresenter = this;
        synchronized (bleScanPresenter) {
            if (TextUtils.isEmpty((CharSequence)this.mDeviceMac) && (this.mDeviceNames == null || this.mDeviceNames.length < 1)) {
                this.next(scanResult);
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)this.mDeviceMac) && !this.mDeviceMac.equalsIgnoreCase(device.getAddress())) {
                return;
            }
            if (this.mDeviceNames != null && this.mDeviceNames.length > 0) {
                AtomicBoolean equal = new AtomicBoolean(false);
                for (String name : this.mDeviceNames) {
                    String remoteName = device.getName();
                    if (remoteName == null) {
                        remoteName = "";
                    }
                    if (!(this.mFuzzy ? remoteName.contains(name) : remoteName.equalsIgnoreCase(name))) continue;
                    equal.set(true);
                }
                if (!equal.get()) {
                    return;
                }
            }
            this.next(scanResult);
        }
    }

    private void next(BleDevice bleDevice) {
        if (this.mNeedConnect) {
            BleLog.i("onScanning--------  name:" + bleDevice.getName() + "  mac:" + bleDevice.getMac() + "  Rssi:" + bleDevice.getRssi() + "  scanRecord:" + HexUtil.formatHexString(bleDevice.getScanRecord()));
            this.mBleDeviceList.add(bleDevice);
            BleManager.getInstance().getBleScanner().stopLeScan();
        } else {
            AtomicBoolean hasFound = new AtomicBoolean(false);
            for (BleDevice result : this.mBleDeviceList) {
                if (!result.getDevice().equals((Object)bleDevice.getDevice())) continue;
                hasFound.set(true);
            }
            if (!hasFound.get()) {
                BleLog.i("onScanning  ------  name: " + bleDevice.getName() + "  mac: " + bleDevice.getMac() + "  Rssi: " + bleDevice.getRssi() + "  scanRecord: " + HexUtil.formatHexString(bleDevice.getScanRecord()));
                this.mBleDeviceList.add(bleDevice);
                this.onScanning(bleDevice);
            }
        }
    }

    public final void notifyScanStarted(boolean success) {
        if (success) {
            this.mBleDeviceList.clear();
            this.onScanStarted(true);
            if (this.mScanTimeout > 0L) {
                this.removeHandlerMsg();
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BleManager.getInstance().getBleScanner().stopLeScan();
                    }
                }, this.mScanTimeout);
            }
        } else {
            this.onScanStarted(false);
        }
    }

    public final void notifyScanStopped() {
        this.removeHandlerMsg();
        this.onScanFinished(this.mBleDeviceList);
    }

    public final void removeHandlerMsg() {
        this.mHandler.removeCallbacksAndMessages(null);
    }

    public abstract void onScanStarted(boolean var1);

    public abstract void onScanning(BleDevice var1);

    public abstract void onScanFinished(List<BleDevice> var1);
}

