/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.clj.fastble.bluetooth.BleBluetooth;
import com.clj.fastble.callback.BleIndicateCallback;
import com.clj.fastble.callback.BleNotifyCallback;
import com.clj.fastble.callback.BleReadCallback;
import com.clj.fastble.callback.BleRssiCallback;
import com.clj.fastble.callback.BleWriteCallback;
import com.clj.fastble.exception.OtherException;
import com.clj.fastble.exception.TimeoutException;
import com.clj.fastble.utils.BleLog;
import java.util.UUID;

@TargetApi(value=18)
public class BleConnector {
    private static final String TAG = BleConnector.class.getSimpleName();
    private static final String UUID_CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR = "00002902-0000-1000-8000-00805f9b34fb";
    private static final int MSG_NOTIFY_CHA = 17;
    private static final int MSG_INDICATE_DES = 18;
    private static final int MSG_WRITE_CHA = 19;
    private static final int MSG_READ_CHA = 20;
    private static final int MSG_READ_RSSI = 21;
    private BluetoothGatt bluetoothGatt;
    private BluetoothGattService service;
    private BluetoothGattCharacteristic characteristic;
    private BleBluetooth bleBluetooth;
    private static int timeOutMillis = 10000;
    private Handler handler = new MyHandler();

    public BleConnector(BleBluetooth bleBluetooth) {
        this.bleBluetooth = bleBluetooth;
        this.bluetoothGatt = bleBluetooth.getBluetoothGatt();
        this.handler = new Handler(Looper.getMainLooper());
    }

    public BleConnector withUUID(UUID serviceUUID, UUID charactUUID) {
        if (serviceUUID != null && this.bluetoothGatt != null) {
            this.service = this.bluetoothGatt.getService(serviceUUID);
        }
        if (this.service != null && charactUUID != null) {
            this.characteristic = this.service.getCharacteristic(charactUUID);
        }
        return this;
    }

    public BleConnector withUUIDString(String serviceUUID, String charactUUID) {
        return this.withUUID(this.formUUID(serviceUUID), this.formUUID(charactUUID));
    }

    private UUID formUUID(String uuid) {
        return uuid == null ? null : UUID.fromString(uuid);
    }

    public void enableCharacteristicNotify(BleNotifyCallback bleCallback, String uuid_notify) {
        if (this.characteristic != null && (this.characteristic.getProperties() | 0x10) > 0) {
            BleLog.w(TAG, "characteristic.getProperties():" + this.characteristic.getProperties());
            this.handleCharacteristicNotificationCallback(bleCallback, uuid_notify);
            this.setCharacteristicNotification(this.bluetoothGatt, this.characteristic, true, bleCallback);
        } else if (bleCallback != null) {
            bleCallback.onNotifyFailure(new OtherException("this characteristic not support notify!"));
        }
    }

    public boolean disableCharacteristicNotify() {
        if (this.characteristic != null && (this.characteristic.getProperties() | 0x10) > 0) {
            BleLog.w(TAG, "characteristic.getProperties():" + this.characteristic.getProperties());
            return this.setCharacteristicNotification(this.bluetoothGatt, this.characteristic, false, null);
        }
        return false;
    }

    private boolean setCharacteristicNotification(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, boolean enable, BleNotifyCallback bleNotifyCallback) {
        if (gatt == null || characteristic == null) {
            if (bleNotifyCallback != null) {
                bleNotifyCallback.onNotifyFailure(new OtherException("gatt or characteristic equal null"));
            }
            return false;
        }
        boolean success1 = gatt.setCharacteristicNotification(characteristic, enable);
        if (!success1) {
            if (bleNotifyCallback != null) {
                bleNotifyCallback.onNotifyFailure(new OtherException("gatt setCharacteristicNotification fail"));
            }
            return false;
        }
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(this.formUUID(UUID_CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR));
        if (descriptor != null) {
            descriptor.setValue(enable ? BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
            boolean success2 = gatt.writeDescriptor(descriptor);
            if (!success2) {
                if (bleNotifyCallback != null) {
                    bleNotifyCallback.onNotifyFailure(new OtherException("gatt writeDescriptor fail"));
                }
                return false;
            }
            return true;
        }
        if (bleNotifyCallback != null) {
            bleNotifyCallback.onNotifyFailure(new OtherException("descriptor equals null"));
        }
        return false;
    }

    public void enableCharacteristicIndicate(BleIndicateCallback bleIndicateCallback, String uuid_indicate) {
        if (this.characteristic != null && (this.characteristic.getProperties() | 0x10) > 0) {
            BleLog.w(TAG, "characteristic.getProperties():" + this.characteristic.getProperties());
            this.handleCharacteristicIndicationCallback(bleIndicateCallback, uuid_indicate);
            this.setCharacteristicIndication(this.bluetoothGatt, this.characteristic, true, bleIndicateCallback);
        } else if (bleIndicateCallback != null) {
            bleIndicateCallback.onIndicateFailure(new OtherException("this characteristic not support indicate!"));
        }
    }

    public boolean disableCharacteristicIndicate() {
        if (this.characteristic != null && (this.characteristic.getProperties() | 0x10) > 0) {
            BleLog.w(TAG, "characteristic.getProperties():" + this.characteristic.getProperties());
            return this.setCharacteristicIndication(this.bluetoothGatt, this.characteristic, false, null);
        }
        return false;
    }

    private boolean setCharacteristicIndication(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, boolean enable, BleIndicateCallback bleIndicateCallback) {
        if (gatt == null || characteristic == null) {
            if (bleIndicateCallback != null) {
                bleIndicateCallback.onIndicateFailure(new OtherException("gatt or characteristic equal null"));
            }
            return false;
        }
        boolean success1 = gatt.setCharacteristicNotification(characteristic, enable);
        if (!success1) {
            if (bleIndicateCallback != null) {
                bleIndicateCallback.onIndicateFailure(new OtherException("gatt setCharacteristicNotification fail"));
            }
            return false;
        }
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(this.formUUID(UUID_CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR));
        if (descriptor != null) {
            descriptor.setValue(enable ? BluetoothGattDescriptor.ENABLE_INDICATION_VALUE : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
            boolean success2 = gatt.writeDescriptor(descriptor);
            if (!success2 && bleIndicateCallback != null) {
                bleIndicateCallback.onIndicateFailure(new OtherException("gatt writeDescriptor fail"));
            }
            return true;
        }
        if (bleIndicateCallback != null) {
            bleIndicateCallback.onIndicateFailure(new OtherException("descriptor equals null"));
        }
        return false;
    }

    public void writeCharacteristic(byte[] data, BleWriteCallback bleWriteCallback, String uuid_write) {
        if (data == null) {
            if (bleWriteCallback != null) {
                bleWriteCallback.onWriteFailure(new OtherException("the data to be written is empty"));
            }
            return;
        }
        if (this.characteristic == null || (this.characteristic.getProperties() & 0xC) == 0) {
            if (bleWriteCallback != null) {
                bleWriteCallback.onWriteFailure(new OtherException("this characteristic not support write!"));
            }
            return;
        }
        this.handleCharacteristicWriteCallback(bleWriteCallback, uuid_write);
        this.characteristic.setValue(data);
        boolean success = this.bluetoothGatt.writeCharacteristic(this.characteristic);
        if (!success) {
            bleWriteCallback.onWriteFailure(new OtherException("gatt writeCharacteristic fail"));
        }
    }

    public void readCharacteristic(BleReadCallback bleReadCallback, String uuid_read) {
        if (this.characteristic != null && (this.characteristic.getProperties() & 2) > 0) {
            this.handleCharacteristicReadCallback(bleReadCallback, uuid_read);
            boolean success = this.bluetoothGatt.readCharacteristic(this.characteristic);
            if (!success) {
                bleReadCallback.onReadFailure(new OtherException("gatt readCharacteristic fail"));
            }
        } else if (bleReadCallback != null) {
            bleReadCallback.onReadFailure(new OtherException("this characteristic not support read!"));
        }
    }

    public void readRemoteRssi(BleRssiCallback bleRssiCallback) {
        this.handleRSSIReadCallback(bleRssiCallback);
        boolean success = this.bluetoothGatt.readRemoteRssi();
        if (!success) {
            bleRssiCallback.onRssiFailure(new OtherException("gatt readRemoteRssi fail"));
        }
    }

    private void handleCharacteristicNotificationCallback(BleNotifyCallback bleNotifyCallback, String uuid_notify) {
        if (bleNotifyCallback != null) {
            this.handler.removeMessages(17, (Object)this);
            bleNotifyCallback.setBleConnector(this);
            bleNotifyCallback.setKey(uuid_notify);
            this.bleBluetooth.addNotifyCallback(uuid_notify, bleNotifyCallback);
            this.handler.sendMessageDelayed(this.handler.obtainMessage(17, (Object)bleNotifyCallback), (long)timeOutMillis);
        }
    }

    private void handleCharacteristicIndicationCallback(BleIndicateCallback bleIndicateCallback, String uuid_indicate) {
        if (bleIndicateCallback != null) {
            this.handler.removeMessages(18, (Object)this);
            bleIndicateCallback.setBleConnector(this);
            bleIndicateCallback.setKey(uuid_indicate);
            this.bleBluetooth.addIndicateCallback(uuid_indicate, bleIndicateCallback);
            this.handler.sendMessageDelayed(this.handler.obtainMessage(18, (Object)bleIndicateCallback), (long)timeOutMillis);
        }
    }

    private void handleCharacteristicWriteCallback(BleWriteCallback bleWriteCallback, String uuid_write) {
        if (bleWriteCallback != null) {
            this.handler.removeMessages(19, (Object)this);
            bleWriteCallback.setBleConnector(this);
            bleWriteCallback.setKey(uuid_write);
            this.bleBluetooth.addWriteCallback(uuid_write, bleWriteCallback);
            this.handler.sendMessageDelayed(this.handler.obtainMessage(19, (Object)bleWriteCallback), (long)timeOutMillis);
        }
    }

    private void handleCharacteristicReadCallback(BleReadCallback bleReadCallback, String uuid_read) {
        if (bleReadCallback != null) {
            this.handler.removeMessages(20, (Object)this);
            bleReadCallback.setBleConnector(this);
            bleReadCallback.setKey(uuid_read);
            this.bleBluetooth.addReadCallback(uuid_read, bleReadCallback);
            this.handler.sendMessageDelayed(this.handler.obtainMessage(20, (Object)bleReadCallback), (long)timeOutMillis);
        }
    }

    private void handleRSSIReadCallback(BleRssiCallback bleRssiCallback) {
        if (bleRssiCallback != null) {
            this.handler.removeMessages(21, (Object)this);
            bleRssiCallback.setBleConnector(this);
            this.bleBluetooth.addRssiCallback(bleRssiCallback);
            this.handler.sendMessageDelayed(this.handler.obtainMessage(21, (Object)bleRssiCallback), (long)timeOutMillis);
        }
    }

    public void notifySuccess() {
        this.handler.removeMessages(17, (Object)this);
    }

    public void indicateSuccess() {
        this.handler.removeMessages(18, (Object)this);
    }

    public void writeSuccess() {
        this.handler.removeMessages(19, (Object)this);
    }

    public void readSuccess() {
        this.handler.removeMessages(20, (Object)this);
    }

    public void rssiSuccess() {
        this.handler.removeMessages(21, (Object)this);
    }

    private static final class MyHandler
    extends Handler {
        private MyHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 17: {
                    BleNotifyCallback notifyCallback = (BleNotifyCallback)msg.obj;
                    if (notifyCallback != null) {
                        notifyCallback.onNotifyFailure(new TimeoutException());
                    }
                    msg.obj = null;
                    break;
                }
                case 18: {
                    BleIndicateCallback indicateCallback = (BleIndicateCallback)msg.obj;
                    if (indicateCallback != null) {
                        indicateCallback.onIndicateFailure(new TimeoutException());
                    }
                    msg.obj = null;
                    break;
                }
                case 19: {
                    BleWriteCallback writeCallback = (BleWriteCallback)msg.obj;
                    if (writeCallback != null) {
                        writeCallback.onWriteFailure(new TimeoutException());
                    }
                    msg.obj = null;
                    break;
                }
                case 20: {
                    BleReadCallback readCallback = (BleReadCallback)msg.obj;
                    if (readCallback != null) {
                        readCallback.onReadFailure(new TimeoutException());
                    }
                    msg.obj = null;
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }
}

