/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.data;

import android.bluetooth.BluetoothDevice;
import android.os.Parcel;
import android.os.Parcelable;

public class BleDevice
implements Parcelable {
    private BluetoothDevice mDevice;
    private byte[] mScanRecord;
    private int mRssi;
    private long mTimestampNanos;
    public static final Parcelable.Creator<BleDevice> CREATOR = new Parcelable.Creator<BleDevice>(){

        public BleDevice createFromParcel(Parcel in) {
            return new BleDevice(in);
        }

        public BleDevice[] newArray(int size) {
            return new BleDevice[size];
        }
    };

    public BleDevice(BluetoothDevice device, int rssi, byte[] scanRecord, long timestampNanos) {
        this.mDevice = device;
        this.mScanRecord = scanRecord;
        this.mRssi = rssi;
        this.mTimestampNanos = timestampNanos;
    }

    protected BleDevice(Parcel in) {
        this.mDevice = (BluetoothDevice)in.readParcelable(BluetoothDevice.class.getClassLoader());
        this.mScanRecord = in.createByteArray();
        this.mRssi = in.readInt();
        this.mTimestampNanos = in.readLong();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.mDevice, flags);
        dest.writeByteArray(this.mScanRecord);
        dest.writeInt(this.mRssi);
        dest.writeLong(this.mTimestampNanos);
    }

    public int describeContents() {
        return 0;
    }

    public String getName() {
        if (this.mDevice != null) {
            return this.mDevice.getName();
        }
        return null;
    }

    public String getMac() {
        if (this.mDevice != null) {
            return this.mDevice.getAddress();
        }
        return null;
    }

    public String getKey() {
        if (this.mDevice != null) {
            return this.mDevice.getName() + this.mDevice.getAddress();
        }
        return "";
    }

    public BluetoothDevice getDevice() {
        return this.mDevice;
    }

    public void setDevice(BluetoothDevice device) {
        this.mDevice = device;
    }

    public byte[] getScanRecord() {
        return this.mScanRecord;
    }

    public void setScanRecord(byte[] scanRecord) {
        this.mScanRecord = scanRecord;
    }

    public int getRssi() {
        return this.mRssi;
    }

    public void setRssi(int rssi) {
        this.mRssi = rssi;
    }

    public long getTimestampNanos() {
        return this.mTimestampNanos;
    }

    public void setTimestampNanos(long timestampNanos) {
        this.mTimestampNanos = timestampNanos;
    }
}

