/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble;

import android.content.Context;
import android.os.Build;
import com.clj.fastble.bluetooth.BleBluetooth;
import com.clj.fastble.conn.BleCharacterCallback;
import com.clj.fastble.conn.BleGattCallback;
import com.clj.fastble.conn.BleRssiCallback;
import com.clj.fastble.conn.BleScanCallback;
import com.clj.fastble.data.ScanResult;
import com.clj.fastble.exception.BleException;
import com.clj.fastble.exception.BlueToothNotEnableException;
import com.clj.fastble.exception.NotFoundDeviceException;
import com.clj.fastble.exception.hanlder.DefaultBleExceptionHandler;
import com.clj.fastble.scan.BleScanRuleConfig;
import java.util.UUID;

public class BleManager {
    private Context mContext;
    private BleBluetooth mBleBluetooth;
    private BleScanRuleConfig mScanRuleConfig;
    private DefaultBleExceptionHandler mBleExceptionHandler;

    public BleManager(Context context) {
        this.mContext = context;
        if (this.isSupportBle() && this.mBleBluetooth == null) {
            this.mBleBluetooth = new BleBluetooth(this.mContext);
        }
        this.mBleExceptionHandler = new DefaultBleExceptionHandler();
    }

    public void handleException(BleException exception) {
        this.mBleExceptionHandler.handleException(exception);
    }

    public void initScanRule(BleScanRuleConfig scanRuleConfig) {
        this.mScanRuleConfig = scanRuleConfig;
    }

    public BleScanRuleConfig getScanRuleConfig() {
        return this.mScanRuleConfig;
    }

    public boolean scan(BleScanCallback callback) {
        if (!this.isBlueEnable()) {
            this.handleException(new BlueToothNotEnableException());
            return false;
        }
        UUID[] serviceUuids = this.mScanRuleConfig.getServiceUuids();
        String[] deviceNames = this.mScanRuleConfig.getDeviceNames();
        String deviceMac = this.mScanRuleConfig.getDeviceMac();
        long timeOut = this.mScanRuleConfig.getTimeOut();
        return this.mBleBluetooth.scan(serviceUuids, deviceNames, deviceMac, false, timeOut, callback);
    }

    public void connect(ScanResult scanResult, BleGattCallback callback) {
        if (!this.isBlueEnable()) {
            this.handleException(new BlueToothNotEnableException());
            return;
        }
        if (scanResult == null || scanResult.getDevice() == null) {
            if (callback != null) {
                callback.onConnectError(new NotFoundDeviceException());
            }
        } else {
            if (callback != null) {
                callback.onFoundDevice(scanResult);
            }
            boolean autoConnect = this.mScanRuleConfig.isAutoConnect();
            this.mBleBluetooth.connect(scanResult, autoConnect, callback);
        }
    }

    public void scanAndConnect(BleGattCallback callback) {
        if (!this.isBlueEnable()) {
            this.handleException(new BlueToothNotEnableException());
            return;
        }
        UUID[] serviceUuids = this.mScanRuleConfig.getServiceUuids();
        String[] deviceNames = this.mScanRuleConfig.getDeviceNames();
        String deviceMac = this.mScanRuleConfig.getDeviceMac();
        boolean autoConnect = this.mScanRuleConfig.isAutoConnect();
        boolean fuzzy = this.mScanRuleConfig.isFuzzy();
        long timeOut = this.mScanRuleConfig.getTimeOut();
        this.mBleBluetooth.scanAndConnect(serviceUuids, deviceNames, deviceMac, fuzzy, autoConnect, timeOut, callback);
    }

    public void cancelScan() {
        this.mBleBluetooth.stopLeScan();
    }

    public boolean notify(String uuid_service, String uuid_notify, BleCharacterCallback callback) {
        return this.mBleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_notify, null).enableCharacteristicNotify(callback, uuid_notify);
    }

    public boolean indicate(String uuid_service, String uuid_indicate, BleCharacterCallback callback) {
        return this.mBleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_indicate, null).enableCharacteristicIndicate(callback, uuid_indicate);
    }

    public boolean stopNotify(String uuid_service, String uuid_notify) {
        boolean success = this.mBleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_notify, null).disableCharacteristicNotify();
        if (success) {
            this.mBleBluetooth.removeGattCallback(uuid_notify);
        }
        return success;
    }

    public boolean stopIndicate(String uuid_service, String uuid_indicate) {
        boolean success = this.mBleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_indicate, null).disableCharacteristicIndicate();
        if (success) {
            this.mBleBluetooth.removeGattCallback(uuid_indicate);
        }
        return success;
    }

    public boolean write(String uuid_service, String uuid_write, byte[] data, BleCharacterCallback callback) {
        return this.mBleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_write, null).writeCharacteristic(data, callback, uuid_write);
    }

    public boolean read(String uuid_service, String uuid_read, BleCharacterCallback callback) {
        return this.mBleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_read, null).readCharacteristic(callback, uuid_read);
    }

    public boolean readRssi(BleRssiCallback callback) {
        return this.mBleBluetooth.newBleConnector().readRemoteRssi(callback);
    }

    public void refreshDeviceCache() {
        this.mBleBluetooth.refreshDeviceCache();
    }

    public void closeBluetoothGatt() {
        if (this.mBleBluetooth != null) {
            this.mBleBluetooth.clearCallback();
            try {
                this.mBleBluetooth.closeBluetoothGatt();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isSupportBle() {
        return Build.VERSION.SDK_INT >= 18 && this.mContext.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    public void enableBluetooth() {
        if (this.mBleBluetooth != null) {
            this.mBleBluetooth.enableBluetoothIfDisabled();
        }
    }

    public void disableBluetooth() {
        if (this.mBleBluetooth != null) {
            this.mBleBluetooth.disableBluetooth();
        }
    }

    public boolean isBlueEnable() {
        return this.mBleBluetooth != null && this.mBleBluetooth.isBlueEnable();
    }

    public boolean isInScanning() {
        return this.mBleBluetooth.isInScanning();
    }

    public boolean isConnectingOrConnected() {
        return this.mBleBluetooth.isConnectingOrConnected();
    }

    public boolean isConnected() {
        return this.mBleBluetooth.isConnected();
    }

    public boolean isServiceDiscovered() {
        return this.mBleBluetooth.isServiceDiscovered();
    }

    public void stopListenCharacterCallback(String uuid) {
        this.mBleBluetooth.removeGattCallback(uuid);
    }

    public void stopListenConnectCallback() {
        this.mBleBluetooth.removeConnectGattCallback();
    }
}

