/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.scan;

import android.bluetooth.BluetoothDevice;
import android.text.TextUtils;
import com.clj.fastble.data.ScanResult;
import com.clj.fastble.scan.PeriodScanCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ScanCallback
extends PeriodScanCallback {
    private String[] mDeviceNames = null;
    private String mDeviceMac = null;
    private boolean mFuzzy = false;
    private boolean mNeedConnect = false;
    private AtomicBoolean hasFound = new AtomicBoolean(false);
    private List<ScanResult> mScanResultList = new ArrayList<ScanResult>();

    public ScanCallback(String[] names, String mac, boolean fuzzy, boolean needConnect, long timeoutMillis) {
        super(timeoutMillis);
        this.mDeviceNames = names;
        this.mDeviceMac = mac;
        this.mFuzzy = fuzzy;
        this.mNeedConnect = needConnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (device == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)device.getName())) {
            return;
        }
        ScanResult scanResult = new ScanResult(device, rssi, scanRecord, System.currentTimeMillis());
        if (this.mNeedConnect) {
            if (!this.hasFound.get()) {
                if (TextUtils.isEmpty((CharSequence)this.mDeviceMac) && (this.mDeviceNames == null || this.mDeviceNames.length > 0)) {
                    this.hasFound.set(true);
                    this.mScanResultList.add(scanResult);
                    this.bleBluetooth.stopLeScan();
                    return;
                }
                if (!TextUtils.isEmpty((CharSequence)this.mDeviceMac) && !this.mDeviceMac.equalsIgnoreCase(device.getAddress())) {
                    return;
                }
                if (this.mDeviceNames != null && this.mDeviceNames.length > 0) {
                    boolean equal = false;
                    for (String name : this.mDeviceNames) {
                        if (!(this.mFuzzy ? device.getName().contains(name) : name.equalsIgnoreCase(device.getName()))) continue;
                        equal = true;
                    }
                    if (!equal) {
                        return;
                    }
                }
                this.hasFound.set(true);
                this.mScanResultList.add(scanResult);
                this.bleBluetooth.stopLeScan();
            }
        } else {
            ScanCallback scanCallback = this;
            synchronized (scanCallback) {
                this.hasFound.set(false);
                for (ScanResult result : this.mScanResultList) {
                    if (!result.getDevice().equals((Object)device)) continue;
                    this.hasFound.set(true);
                }
                if (!this.hasFound.get()) {
                    this.mScanResultList.add(scanResult);
                    this.onScanning(scanResult);
                }
            }
        }
    }

    @Override
    public void onStarted() {
        this.mScanResultList.clear();
        this.hasFound.set(false);
        this.onScanStarted();
    }

    @Override
    public void onFinished() {
        this.onScanFinished(this.mScanResultList);
    }

    public abstract void onScanStarted();

    public abstract void onScanning(ScanResult var1);

    public abstract void onScanFinished(List<ScanResult> var1);
}

