/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.scan;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.os.Handler;
import android.os.Looper;
import com.clj.fastble.bluetooth.BleBluetooth;

@TargetApi(value=18)
public abstract class PeriodScanCallback
implements BluetoothAdapter.LeScanCallback {
    private Handler mHandler = new Handler(Looper.getMainLooper());
    protected BleBluetooth bleBluetooth;
    private long timeoutMillis = 10000L;

    PeriodScanCallback(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public abstract void onStarted();

    public abstract void onFinished();

    public void notifyScanStarted() {
        this.onStarted();
        if (this.timeoutMillis > 0L) {
            this.removeHandlerMsg();
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    PeriodScanCallback.this.bleBluetooth.stopLeScan();
                }
            }, this.timeoutMillis);
        }
    }

    public void notifyScanStopped() {
        this.removeHandlerMsg();
        this.onFinished();
    }

    public void removeHandlerMsg() {
        this.mHandler.removeCallbacksAndMessages(null);
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public PeriodScanCallback setTimeoutMillis(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public BleBluetooth getBleBluetooth() {
        return this.bleBluetooth;
    }

    public PeriodScanCallback setBleBluetooth(BleBluetooth bluetooth) {
        this.bleBluetooth = bluetooth;
        return this;
    }
}

