/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.clj.fastble.conn.BleConnector;
import com.clj.fastble.conn.BleGattCallback;
import com.clj.fastble.conn.BleScanCallback;
import com.clj.fastble.data.ScanResult;
import com.clj.fastble.exception.BleException;
import com.clj.fastble.exception.ConnectException;
import com.clj.fastble.exception.NotFoundDeviceException;
import com.clj.fastble.exception.ScanFailedException;
import com.clj.fastble.scan.PeriodScanCallback;
import com.clj.fastble.scan.ScanCallback;
import com.clj.fastble.utils.BleLog;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@TargetApi(value=18)
public class BleBluetooth {
    private static final String CONNECT_CALLBACK_KEY = "connect_key";
    public static final String READ_RSSI_KEY = "rssi_key";
    private static final int STATE_DISCONNECTED = 0;
    private static final int STATE_SCANNING = 1;
    private static final int STATE_CONNECTING = 2;
    private static final int STATE_CONNECTED = 3;
    private static final int STATE_SERVICES_DISCOVERED = 4;
    private int connectionState = 0;
    private Context context;
    private BluetoothAdapter bluetoothAdapter;
    private BluetoothGatt bluetoothGatt;
    private Handler handler = new Handler(Looper.getMainLooper());
    private HashMap<String, BluetoothGattCallback> callbackHashMap = new HashMap();
    private PeriodScanCallback periodScanCallback;
    private BleGattCallback coreGattCallback = new BleGattCallback(){

        @Override
        public void onScanStarted() {
            BleLog.i("BleGattCallback\uff1aonScanStarted ");
        }

        @Override
        public void onFoundDevice(ScanResult scanResult) {
            BleLog.i("BleGattCallback\uff1aonFoundDevice ");
        }

        @Override
        public void onConnecting(BluetoothGatt gatt, int status) {
            BleLog.i("BleGattCallback\uff1aonConnectSuccess ");
            BleBluetooth.this.bluetoothGatt = gatt;
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BleGattCallback)) continue;
                ((BleGattCallback)((Object)call)).onConnecting(gatt, status);
            }
        }

        @Override
        public void onConnectSuccess(BluetoothGatt gatt, int status) {
            BleLog.i("BleGattCallback\uff1aonConnectSuccess ");
            BleBluetooth.this.bluetoothGatt = gatt;
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BleGattCallback)) continue;
                ((BleGattCallback)((Object)call)).onConnectSuccess(gatt, status);
                gatt.discoverServices();
            }
        }

        @Override
        public void onDisConnected(BluetoothGatt gatt, int status, BleException exception) {
            BleLog.i("BleGattCallback\uff1aonConnectFailure ");
            BleBluetooth.this.closeBluetoothGatt();
            BleBluetooth.this.bluetoothGatt = null;
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BleGattCallback)) continue;
                ((BleGattCallback)((Object)call)).onDisConnected(gatt, status, exception);
            }
        }

        @Override
        public void onConnectError(BleException exception) {
            BleLog.i("BleGattCallback\uff1aonConnectError ");
        }

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            BleLog.i("BleGattCallback\uff1aonConnectionStateChange \nstatus: " + status + '\n' + "newState: " + newState + '\n' + "currentThread: " + Thread.currentThread().getId());
            if (newState == 2) {
                BleBluetooth.this.connectionState = 3;
                this.onConnectSuccess(gatt, status);
            } else if (newState == 0) {
                BleBluetooth.this.connectionState = 0;
                this.onDisConnected(gatt, status, new ConnectException(gatt, status));
            } else if (newState == 1) {
                BleBluetooth.this.connectionState = 2;
                this.onConnecting(gatt, status);
            }
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BluetoothGattCallback)) continue;
                ((BluetoothGattCallback)call).onConnectionStateChange(gatt, status, newState);
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            BleLog.i("BleGattCallback\uff1aonServicesDiscovered ");
            BleBluetooth.this.connectionState = 4;
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BluetoothGattCallback)) continue;
                ((BluetoothGattCallback)call).onServicesDiscovered(gatt, status);
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            BleLog.i("BleGattCallback\uff1aonCharacteristicRead ");
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BluetoothGattCallback)) continue;
                ((BluetoothGattCallback)call).onCharacteristicRead(gatt, characteristic, status);
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            BleLog.i("BleGattCallback\uff1aonCharacteristicWrite ");
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BluetoothGattCallback)) continue;
                ((BluetoothGattCallback)call).onCharacteristicWrite(gatt, characteristic, status);
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            BleLog.i("BleGattCallback\uff1aonCharacteristicChanged ");
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BluetoothGattCallback)) continue;
                ((BluetoothGattCallback)call).onCharacteristicChanged(gatt, characteristic);
            }
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            BleLog.i("BleGattCallback\uff1aonDescriptorRead ");
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BluetoothGattCallback)) continue;
                ((BluetoothGattCallback)call).onDescriptorRead(gatt, descriptor, status);
            }
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            BleLog.i("BleGattCallback\uff1aonDescriptorWrite ");
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BluetoothGattCallback)) continue;
                ((BluetoothGattCallback)call).onDescriptorWrite(gatt, descriptor, status);
            }
        }

        public void onReliableWriteCompleted(BluetoothGatt gatt, int status) {
            BleLog.i("BleGattCallback\uff1aonReliableWriteCompleted ");
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BluetoothGattCallback)) continue;
                ((BluetoothGattCallback)call).onReliableWriteCompleted(gatt, status);
            }
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
            BleLog.i("BleGattCallback\uff1aonReadRemoteRssi ");
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BluetoothGattCallback)) continue;
                ((BluetoothGattCallback)call).onReadRemoteRssi(gatt, rssi, status);
            }
        }
    };

    public BleBluetooth(Context context) {
        this.context = context = context.getApplicationContext();
        BluetoothManager bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
        if (bluetoothManager != null) {
            this.bluetoothAdapter = bluetoothManager.getAdapter();
        }
    }

    public BleConnector newBleConnector() {
        return new BleConnector(this);
    }

    public boolean isInScanning() {
        return this.connectionState == 1;
    }

    public boolean isConnectingOrConnected() {
        return this.connectionState >= 2;
    }

    public boolean isConnected() {
        return this.connectionState >= 3;
    }

    public boolean isServiceDiscovered() {
        return this.connectionState == 4;
    }

    private void addConnectGattCallback(BleGattCallback callback) {
        this.callbackHashMap.put(CONNECT_CALLBACK_KEY, callback);
    }

    public void addGattCallback(String uuid, BluetoothGattCallback callback) {
        this.callbackHashMap.put(uuid, callback);
    }

    public void removeConnectGattCallback() {
        this.callbackHashMap.remove(CONNECT_CALLBACK_KEY);
    }

    public void removeGattCallback(String key) {
        this.callbackHashMap.remove(key);
    }

    public void clearCallback() {
        this.callbackHashMap.clear();
    }

    public BluetoothGattCallback getGattCallback(String uuid) {
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            return null;
        }
        return this.callbackHashMap.get(uuid);
    }

    public boolean startLeScan(UUID[] serviceUuids, PeriodScanCallback callback) {
        if (callback == null) {
            return false;
        }
        this.periodScanCallback = callback;
        boolean success = this.bluetoothAdapter.startLeScan(serviceUuids, (BluetoothAdapter.LeScanCallback)this.periodScanCallback);
        if (success) {
            this.connectionState = 1;
            this.periodScanCallback.setBleBluetooth(this).notifyScanStarted();
        } else {
            callback.removeHandlerMsg();
        }
        return success;
    }

    public void stopLeScan() {
        if (this.periodScanCallback == null) {
            return;
        }
        this.bluetoothAdapter.stopLeScan((BluetoothAdapter.LeScanCallback)this.periodScanCallback);
        this.periodScanCallback.notifyScanStopped();
        this.periodScanCallback = null;
        if (this.connectionState == 1) {
            this.connectionState = 0;
        }
    }

    public synchronized BluetoothGatt connect(ScanResult scanResult, boolean autoConnect, BleGattCallback callback) {
        BleLog.i("connect device: " + scanResult.getDevice().getName() + "\nmac: " + scanResult.getDevice().getAddress() + "\nautoConnect: " + autoConnect);
        this.addConnectGattCallback(callback);
        return scanResult.getDevice().connectGatt(this.context, autoConnect, (BluetoothGattCallback)this.coreGattCallback);
    }

    public boolean scan(UUID[] serviceUuids, String[] names, String mac, boolean fuzzy, long timeOut, final BleScanCallback callback) {
        return this.startLeScan(serviceUuids, new ScanCallback(names, mac, fuzzy, false, timeOut){

            @Override
            public void onScanStarted() {
                if (callback != null) {
                    callback.onScanStarted();
                }
            }

            @Override
            public void onScanning(ScanResult result) {
                if (callback != null) {
                    callback.onScanning(result);
                }
            }

            @Override
            public void onScanFinished(List<ScanResult> scanResultList) {
                if (callback != null) {
                    callback.onScanFinished(scanResultList);
                }
            }
        });
    }

    public void scanAndConnect(UUID[] serviceUuids, String[] names, String mac, boolean fuzzy, final boolean autoConnect, long timeOut, final BleGattCallback callback) {
        boolean success = this.startLeScan(serviceUuids, new ScanCallback(names, mac, fuzzy, autoConnect, timeOut){

            @Override
            public void onScanStarted() {
                if (callback != null) {
                    callback.onScanStarted();
                }
            }

            @Override
            public void onScanning(ScanResult result) {
            }

            @Override
            public void onScanFinished(final List<ScanResult> scanResultList) {
                if (scanResultList == null || scanResultList.size() < 1) {
                    if (callback != null) {
                        callback.onConnectError(new NotFoundDeviceException());
                    }
                } else {
                    if (callback != null) {
                        callback.onFoundDevice(scanResultList.get(0));
                    }
                    BleBluetooth.this.runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            BleBluetooth.this.connect((ScanResult)scanResultList.get(0), autoConnect, callback);
                        }
                    });
                }
            }
        });
        if (!success && callback != null) {
            callback.onConnectError(new ScanFailedException());
        }
    }

    public boolean refreshDeviceCache() {
        try {
            Method refresh = BluetoothGatt.class.getMethod("refresh", new Class[0]);
            if (refresh != null) {
                boolean success = (Boolean)refresh.invoke((Object)this.getBluetoothGatt(), new Object[0]);
                BleLog.i("refreshDeviceCache, is success:  " + success);
                return success;
            }
        }
        catch (Exception e) {
            BleLog.i("exception occur while refreshing device: " + e.getMessage());
            e.printStackTrace();
        }
        return false;
    }

    public void closeBluetoothGatt() {
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.disconnect();
        }
        if (this.bluetoothGatt != null) {
            this.refreshDeviceCache();
        }
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.close();
        }
    }

    public void enableBluetoothIfDisabled() {
        if (!this.isBlueEnable()) {
            this.enableBluetooth();
        }
    }

    public boolean isBlueEnable() {
        return this.bluetoothAdapter.isEnabled();
    }

    public void enableBluetooth() {
        this.bluetoothAdapter.enable();
    }

    public void disableBluetooth() {
        this.bluetoothAdapter.disable();
    }

    private void runOnMainThread(Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
        } else {
            this.handler.post(runnable);
        }
    }

    public Context getContext() {
        return this.context;
    }

    public BluetoothAdapter getBluetoothAdapter() {
        return this.bluetoothAdapter;
    }

    public BluetoothGatt getBluetoothGatt() {
        return this.bluetoothGatt;
    }

    public int getConnectionState() {
        return this.connectionState;
    }
}

