/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.conn;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.clj.fastble.bluetooth.BleBluetooth;
import com.clj.fastble.conn.BleCallback;
import com.clj.fastble.conn.BleCharacterCallback;
import com.clj.fastble.conn.BleRssiCallback;
import com.clj.fastble.exception.GattException;
import com.clj.fastble.exception.OtherException;
import com.clj.fastble.exception.TimeoutException;
import com.clj.fastble.utils.BleLog;
import com.clj.fastble.utils.HexUtil;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class BleConnector {
    private static final String TAG = BleConnector.class.getSimpleName();
    private static final String UUID_CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR = "00002902-0000-1000-8000-00805f9b34fb";
    private static final int MSG_WRITE_CHA = 1;
    private static final int MSG_WRIATE_DES = 2;
    private static final int MSG_READ_CHA = 3;
    private static final int MSG_READ_DES = 4;
    private static final int MSG_READ_RSSI = 5;
    private static final int MSG_NOTIFY_CHA = 6;
    private static final int MSG_NOTIY_DES = 7;
    private static final int MSG_INDICATE_DES = 8;
    private BluetoothGatt bluetoothGatt;
    private BluetoothGattService service;
    private BluetoothGattCharacteristic characteristic;
    private BluetoothGattDescriptor descriptor;
    private BleBluetooth bleBluetooth;
    private static int timeOutMillis = 10000;
    private Handler handler = new MyHandler();

    public BleConnector(BleBluetooth bleBluetooth) {
        this.bleBluetooth = bleBluetooth;
        this.bluetoothGatt = bleBluetooth.getBluetoothGatt();
        this.handler = new Handler(Looper.getMainLooper());
    }

    public BleConnector(BleBluetooth bleBluetooth, BluetoothGattService service, BluetoothGattCharacteristic characteristic, BluetoothGattDescriptor descriptor) {
        this(bleBluetooth);
        this.service = service;
        this.characteristic = characteristic;
        this.descriptor = descriptor;
    }

    public BleConnector(BleBluetooth bleBluetooth, UUID serviceUUID, UUID charactUUID, UUID descriptorUUID, UUID client_characteristic_conifgUUID) {
        this(bleBluetooth);
        this.withUUID(serviceUUID, charactUUID, descriptorUUID);
    }

    public BleConnector(BleBluetooth bleBluetooth, String serviceUUID, String charactUUID, String descriptorUUID, String client_characteristic_conifgUUID) {
        this(bleBluetooth);
        this.withUUIDString(serviceUUID, charactUUID, descriptorUUID);
    }

    public BleConnector withUUID(UUID serviceUUID, UUID charactUUID, UUID descriptorUUID) {
        if (serviceUUID != null && this.bluetoothGatt != null) {
            this.service = this.bluetoothGatt.getService(serviceUUID);
        }
        if (this.service != null && charactUUID != null) {
            this.characteristic = this.service.getCharacteristic(charactUUID);
        }
        if (this.characteristic != null && descriptorUUID != null) {
            this.descriptor = this.characteristic.getDescriptor(descriptorUUID);
        }
        return this;
    }

    public BleConnector withUUIDString(String serviceUUID, String charactUUID, String descriptorUUID) {
        return this.withUUID(this.formUUID(serviceUUID), this.formUUID(charactUUID), this.formUUID(descriptorUUID));
    }

    private UUID formUUID(String uuid) {
        return uuid == null ? null : UUID.fromString(uuid);
    }

    public boolean enableCharacteristicNotify(BleCharacterCallback bleCallback, String uuid_notify) {
        if (this.getCharacteristic() != null && (this.getCharacteristic().getProperties() | 0x10) > 0) {
            BleLog.w(TAG, "characteristic.getProperties():" + this.getCharacteristic().getProperties());
            this.handleCharacteristicNotificationCallback(bleCallback, uuid_notify);
            return this.setCharacteristicNotification(this.getBluetoothGatt(), this.getCharacteristic(), true, bleCallback);
        }
        if (bleCallback != null) {
            bleCallback.onFailure(new OtherException("this characteristic not support notify!"));
            bleCallback.onInitiatedResult(false);
        }
        return false;
    }

    public boolean disableCharacteristicNotify() {
        if (this.getCharacteristic() != null && (this.getCharacteristic().getProperties() | 0x10) > 0) {
            BleLog.w(TAG, "characteristic.getProperties():" + this.getCharacteristic().getProperties());
            return this.setCharacteristicNotification(this.getBluetoothGatt(), this.getCharacteristic(), false, null);
        }
        return false;
    }

    private boolean setCharacteristicNotification(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, boolean enable, BleCharacterCallback bleCallback) {
        if (gatt == null || characteristic == null) {
            if (bleCallback != null) {
                bleCallback.onFailure(new OtherException("gatt or characteristic equal null"));
                bleCallback.onInitiatedResult(false);
            }
            return false;
        }
        boolean success = gatt.setCharacteristicNotification(characteristic, enable);
        BleLog.d(TAG, "setCharacteristicNotification: " + enable + "\nsuccess: " + success + "\ncharacteristic.getUuid(): " + characteristic.getUuid());
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(this.formUUID(UUID_CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR));
        if (descriptor != null) {
            descriptor.setValue(enable ? BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
            boolean success2 = gatt.writeDescriptor(descriptor);
            if (bleCallback != null) {
                bleCallback.onInitiatedResult(success2);
            }
            return success2;
        }
        if (bleCallback != null) {
            bleCallback.onFailure(new OtherException("notify operation failed"));
            bleCallback.onInitiatedResult(false);
        }
        return false;
    }

    public boolean enableCharacteristicIndicate(BleCharacterCallback bleCallback, String uuid_indicate) {
        if (this.getCharacteristic() != null && (this.getCharacteristic().getProperties() | 0x10) > 0) {
            BleLog.w(TAG, "characteristic.getProperties():" + this.getCharacteristic().getProperties());
            this.handleCharacteristicIndicationCallback(bleCallback, uuid_indicate);
            return this.setCharacteristicIndication(this.getBluetoothGatt(), this.getCharacteristic(), true, bleCallback);
        }
        if (bleCallback != null) {
            bleCallback.onFailure(new OtherException("this characteristic not support indicate!"));
        }
        return false;
    }

    public boolean disableCharacteristicIndicate() {
        if (this.getCharacteristic() != null && (this.getCharacteristic().getProperties() | 0x10) > 0) {
            BleLog.w(TAG, "characteristic.getProperties():" + this.getCharacteristic().getProperties());
            return this.setCharacteristicIndication(this.getBluetoothGatt(), this.getCharacteristic(), false, null);
        }
        return false;
    }

    private boolean setCharacteristicIndication(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, boolean enable, BleCharacterCallback bleCallback) {
        if (gatt == null || characteristic == null) {
            if (bleCallback != null) {
                bleCallback.onFailure(new OtherException("gatt or characteristic equal null"));
                bleCallback.onInitiatedResult(false);
            }
            return false;
        }
        boolean success = gatt.setCharacteristicNotification(characteristic, enable);
        BleLog.d(TAG, "setCharacteristicIndication:" + enable + "\nsuccess:" + success + "\ncharacteristic.getUuid():" + characteristic.getUuid());
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(this.formUUID(UUID_CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR));
        if (descriptor != null) {
            descriptor.setValue(enable ? BluetoothGattDescriptor.ENABLE_INDICATION_VALUE : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
            boolean success2 = gatt.writeDescriptor(descriptor);
            if (bleCallback != null) {
                bleCallback.onInitiatedResult(success2);
            }
            return success2;
        }
        if (bleCallback != null) {
            bleCallback.onFailure(new OtherException("indicate operation failed"));
            bleCallback.onInitiatedResult(false);
        }
        return false;
    }

    public boolean writeCharacteristic(byte[] data, BleCharacterCallback bleCallback, String uuid_write) {
        if (data == null) {
            if (bleCallback != null) {
                bleCallback.onFailure(new OtherException("the data to be written is empty"));
                bleCallback.onInitiatedResult(false);
            }
            return false;
        }
        if (this.getCharacteristic() == null || (this.getCharacteristic().getProperties() & 0xC) == 0) {
            if (bleCallback != null) {
                bleCallback.onFailure(new OtherException("this characteristic not support write!"));
                bleCallback.onInitiatedResult(false);
            }
            return false;
        }
        BleLog.d(TAG, this.getCharacteristic().getUuid() + "\ncharacteristic.getProperties():" + this.getCharacteristic().getProperties() + "\ncharacteristic.getValue(): " + Arrays.toString(this.getCharacteristic().getValue()) + "\ncharacteristic write bytes: " + Arrays.toString(data) + "\nhex: " + HexUtil.encodeHexStr(data));
        this.handleCharacteristicWriteCallback(bleCallback, uuid_write);
        this.getCharacteristic().setValue(data);
        return this.handleAfterInitialed(this.getBluetoothGatt().writeCharacteristic(this.getCharacteristic()), bleCallback);
    }

    public boolean readCharacteristic(BleCharacterCallback bleCallback, String uuid_read) {
        if (this.getCharacteristic() != null && (this.characteristic.getProperties() & 2) > 0) {
            BleLog.d(TAG, this.getCharacteristic().getUuid() + "\ncharacteristic.getProperties(): " + this.getCharacteristic().getProperties() + "\ncharacteristic.getValue(): " + Arrays.toString(this.getCharacteristic().getValue()));
            this.setCharacteristicNotification(this.getBluetoothGatt(), this.getCharacteristic(), false, bleCallback);
            this.handleCharacteristicReadCallback(bleCallback, uuid_read);
            return this.handleAfterInitialed(this.getBluetoothGatt().readCharacteristic(this.getCharacteristic()), bleCallback);
        }
        if (bleCallback != null) {
            bleCallback.onFailure(new OtherException("this characteristic not support read!"));
            bleCallback.onInitiatedResult(false);
        }
        return false;
    }

    public boolean readRemoteRssi(BleRssiCallback bleCallback) {
        this.handleRSSIReadCallback(bleCallback);
        return this.handleAfterInitialed(this.getBluetoothGatt().readRemoteRssi(), bleCallback);
    }

    private void handleCharacteristicNotificationCallback(final BleCharacterCallback bleCallback, final String uuid_notify) {
        if (bleCallback != null) {
            this.listenAndTimer(bleCallback, 6, uuid_notify, new BluetoothGattCallback(){
                AtomicBoolean msgRemoved = new AtomicBoolean(false);

                public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
                    if (!this.msgRemoved.getAndSet(true)) {
                        BleConnector.this.handler.removeMessages(6, (Object)this);
                    }
                    if (characteristic.getUuid().equals(UUID.fromString(uuid_notify))) {
                        bleCallback.onSuccess(characteristic);
                    }
                }
            });
        }
    }

    private void handleCharacteristicIndicationCallback(final BleCharacterCallback bleCallback, final String uuid_indicate) {
        if (bleCallback != null) {
            this.listenAndTimer(bleCallback, 8, uuid_indicate, new BluetoothGattCallback(){
                AtomicBoolean msgRemoved = new AtomicBoolean(false);

                public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
                    if (!this.msgRemoved.getAndSet(true)) {
                        BleConnector.this.handler.removeMessages(8, (Object)this);
                    }
                    if (characteristic.getUuid().equals(UUID.fromString(uuid_indicate))) {
                        bleCallback.onSuccess(characteristic);
                    }
                }
            });
        }
    }

    private void handleCharacteristicWriteCallback(final BleCharacterCallback bleCallback, final String uuid_write) {
        if (bleCallback != null) {
            this.listenAndTimer(bleCallback, 1, uuid_write, new BluetoothGattCallback(){

                public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
                    BleConnector.this.handler.removeMessages(1, (Object)this);
                    if (status == 0) {
                        if (characteristic.getUuid().equals(UUID.fromString(uuid_write))) {
                            bleCallback.onSuccess(characteristic);
                        }
                    } else {
                        bleCallback.onFailure(new GattException(status));
                    }
                }
            });
        }
    }

    private void handleCharacteristicReadCallback(final BleCharacterCallback bleCallback, final String uuid_read) {
        if (bleCallback != null) {
            this.listenAndTimer(bleCallback, 3, uuid_read, new BluetoothGattCallback(){
                AtomicBoolean msgRemoved = new AtomicBoolean(false);

                public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
                    if (!this.msgRemoved.getAndSet(true)) {
                        BleConnector.this.handler.removeMessages(3, (Object)this);
                    }
                    if (status == 0) {
                        if (characteristic.getUuid().equals(UUID.fromString(uuid_read))) {
                            bleCallback.onSuccess(characteristic);
                        }
                    } else {
                        bleCallback.onFailure(new GattException(status));
                    }
                }
            });
        }
    }

    private void handleRSSIReadCallback(final BleRssiCallback bleCallback) {
        if (bleCallback != null) {
            this.listenAndTimer(bleCallback, 5, "rssi_key", new BluetoothGattCallback(){

                public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
                    BleConnector.this.handler.removeMessages(5, (Object)this);
                    if (status == 0) {
                        bleCallback.onSuccess(rssi);
                    } else {
                        bleCallback.onFailure(new GattException(status));
                    }
                }
            });
        }
    }

    private boolean handleAfterInitialed(boolean initiated, BleCallback bleCallback) {
        if (bleCallback != null) {
            if (!initiated) {
                bleCallback.onFailure(new OtherException("write or read operation failed"));
            }
            bleCallback.onInitiatedResult(initiated);
        }
        return initiated;
    }

    private void listenAndTimer(BleCallback bleCallback, int what, String uuid, BluetoothGattCallback callback) {
        bleCallback.setBluetoothGattCallback(callback);
        this.bleBluetooth.addGattCallback(uuid, callback);
        Message msg = this.handler.obtainMessage(what, (Object)bleCallback);
        this.handler.sendMessageDelayed(msg, (long)timeOutMillis);
    }

    public BluetoothGatt getBluetoothGatt() {
        return this.bluetoothGatt;
    }

    public BleConnector setBluetoothGatt(BluetoothGatt bluetoothGatt) {
        this.bluetoothGatt = bluetoothGatt;
        return this;
    }

    public BluetoothGattService getService() {
        return this.service;
    }

    public BleConnector setService(BluetoothGattService service) {
        this.service = service;
        return this;
    }

    public BluetoothGattCharacteristic getCharacteristic() {
        return this.characteristic;
    }

    public BleConnector setCharacteristic(BluetoothGattCharacteristic characteristic) {
        this.characteristic = characteristic;
        return this;
    }

    public BluetoothGattDescriptor getDescriptor() {
        return this.descriptor;
    }

    public BleConnector setDescriptor(BluetoothGattDescriptor descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    public int getTimeOutMillis() {
        return timeOutMillis;
    }

    public BleConnector setTimeOutMillis(int timeOutMillis) {
        BleConnector.timeOutMillis = timeOutMillis;
        return this;
    }

    private static final class MyHandler
    extends Handler {
        private MyHandler() {
        }

        public void handleMessage(Message msg) {
            BleCallback call = (BleCallback)msg.obj;
            if (call != null) {
                call.onFailure(new TimeoutException());
            }
            msg.obj = null;
        }
    }
}

