/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.scan;

import android.bluetooth.BluetoothDevice;
import android.text.TextUtils;
import com.clj.fastble.data.ScanResult;
import com.clj.fastble.scan.PeriodScanCallback;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class MacScanCallback
extends PeriodScanCallback {
    private String mMac;
    private AtomicBoolean hasFound = new AtomicBoolean(false);

    public MacScanCallback(String mac, long timeoutMillis) {
        super(timeoutMillis);
        this.mMac = mac;
        if (TextUtils.isEmpty((CharSequence)mac)) {
            this.onDeviceNotFound();
        }
    }

    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (device == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)device.getAddress())) {
            return;
        }
        if (!this.hasFound.get()) {
            ScanResult scanResult = new ScanResult(device, rssi, scanRecord, System.currentTimeMillis());
            if (this.mMac.equalsIgnoreCase(device.getAddress())) {
                this.hasFound.set(true);
                this.bleBluetooth.stopScan(this);
                this.onDeviceFound(scanResult);
            }
        }
    }

    @Override
    public void onScanTimeout() {
        this.onDeviceNotFound();
    }

    @Override
    public void onScanCancel() {
    }

    public abstract void onDeviceFound(ScanResult var1);

    public abstract void onDeviceNotFound();
}

