/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble;

import android.content.Context;
import com.clj.fastble.bluetooth.BleBluetooth;
import com.clj.fastble.conn.BleCharacterCallback;
import com.clj.fastble.conn.BleGattCallback;
import com.clj.fastble.data.ScanResult;
import com.clj.fastble.exception.BleException;
import com.clj.fastble.exception.hanlder.DefaultBleExceptionHandler;
import com.clj.fastble.scan.ListScanCallback;
import com.clj.fastble.utils.BleLog;

public class BleManager {
    private Context mContext;
    private BleBluetooth bleBluetooth;
    private DefaultBleExceptionHandler bleExceptionHandler;

    public BleManager(Context context) {
        this.mContext = context;
        if (this.bleBluetooth == null) {
            this.bleBluetooth = new BleBluetooth(context);
        }
        this.bleExceptionHandler = new DefaultBleExceptionHandler(context);
    }

    public void handleException(BleException exception) {
        this.bleExceptionHandler.handleException(exception);
    }

    public boolean scanDevice(ListScanCallback callback) {
        return this.bleBluetooth.startLeScan(callback);
    }

    public void connectDevice(ScanResult scanResult, boolean autoConnect, BleGattCallback callback) {
        if (scanResult == null || scanResult.getDevice() == null) {
            if (callback != null) {
                callback.onNotFoundDevice();
            }
        } else {
            if (callback != null) {
                callback.onFoundDevice(scanResult);
            }
            this.bleBluetooth.connect(scanResult, autoConnect, callback);
        }
    }

    public boolean scanNameAndConnect(String deviceName, long time_out, boolean autoConnect, BleGattCallback callback) {
        return this.bleBluetooth.scanNameAndConnect(deviceName, time_out, autoConnect, callback);
    }

    public boolean scanNamesAndConnect(String[] deviceNames, long time_out, boolean autoConnect, BleGattCallback callback) {
        return this.bleBluetooth.scanNameAndConnect(deviceNames, time_out, autoConnect, callback);
    }

    public boolean scanfuzzyNameAndConnect(String fuzzyName, long time_out, boolean autoConnect, BleGattCallback callback) {
        return this.bleBluetooth.scanNameAndConnect(fuzzyName, time_out, autoConnect, true, callback);
    }

    public boolean scanfuzzyNamesAndConnect(String[] fuzzyNames, long time_out, boolean autoConnect, BleGattCallback callback) {
        return this.bleBluetooth.scanNameAndConnect(fuzzyNames, time_out, autoConnect, true, callback);
    }

    public boolean scanMacAndConnect(String deviceMac, long time_out, boolean autoConnect, BleGattCallback callback) {
        return this.bleBluetooth.scanMacAndConnect(deviceMac, time_out, autoConnect, callback);
    }

    public void cancelScan() {
        this.bleBluetooth.cancelScan();
    }

    public boolean notify(String uuid_service, String uuid_notify, BleCharacterCallback callback) {
        return this.bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_notify, null).enableCharacteristicNotify(callback, uuid_notify);
    }

    public boolean indicate(String uuid_service, String uuid_indicate, BleCharacterCallback callback) {
        return this.bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_indicate, null).enableCharacteristicIndicate(callback, uuid_indicate);
    }

    public boolean writeDevice(String uuid_service, String uuid_write, byte[] data, BleCharacterCallback callback) {
        return this.bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_write, null).writeCharacteristic(data, callback, uuid_write);
    }

    public boolean readDevice(String uuid_service, String uuid_read, BleCharacterCallback callback) {
        return this.bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_read, null).readCharacteristic(callback, uuid_read);
    }

    public void getBluetoothState() {
        BleLog.i("ConnectionState:  " + this.bleBluetooth.getConnectionState() + "\nisInScanning: " + this.bleBluetooth.isInScanning() + "\nisConnected: " + this.bleBluetooth.isConnected() + "\nisServiceDiscovered: " + this.bleBluetooth.isServiceDiscovered());
    }

    public void refreshDeviceCache() {
        this.bleBluetooth.refreshDeviceCache();
    }

    public void closeBluetoothGatt() {
        if (this.bleBluetooth != null) {
            this.bleBluetooth.clearCallback();
            try {
                this.bleBluetooth.closeBluetoothGatt();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isSupportBle() {
        return this.mContext.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    public void enableBluetooth() {
        if (this.bleBluetooth != null) {
            this.bleBluetooth.enableBluetoothIfDisabled();
        }
    }

    public void disableBluetooth() {
        if (this.bleBluetooth != null) {
            this.bleBluetooth.disableBluetooth();
        }
    }

    public boolean isBlueEnable() {
        return this.bleBluetooth != null && this.bleBluetooth.isBlueEnable();
    }

    public boolean isInScanning() {
        return this.bleBluetooth.isInScanning();
    }

    public boolean isConnectingOrConnected() {
        return this.bleBluetooth.isConnectingOrConnected();
    }

    public boolean isConnected() {
        return this.bleBluetooth.isConnected();
    }

    public boolean isServiceDiscovered() {
        return this.bleBluetooth.isServiceDiscovered();
    }

    public void stopListenCharacterCallback(String uuid) {
        this.bleBluetooth.removeGattCallback(uuid);
    }

    public void stopListenConnectCallback() {
        this.bleBluetooth.removeConnectGattCallback();
    }

    public boolean stopNotify(String uuid_service, String uuid_notify) {
        boolean success = this.bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_notify, null).disableCharacteristicNotify();
        if (success) {
            this.bleBluetooth.removeGattCallback(uuid_notify);
        }
        return success;
    }

    public boolean stopIndicate(String uuid_service, String uuid_indicate) {
        boolean success = this.bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_indicate, null).disableCharacteristicIndicate();
        if (success) {
            this.bleBluetooth.removeGattCallback(uuid_indicate);
        }
        return success;
    }
}

