/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.scan;

import android.bluetooth.BluetoothDevice;
import com.clj.fastble.data.ScanResult;
import com.clj.fastble.scan.PeriodScanCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ListScanCallback
extends PeriodScanCallback {
    private List<ScanResult> resultList = new ArrayList<ScanResult>();
    private AtomicBoolean hasFound = new AtomicBoolean(false);

    public ListScanCallback(long timeoutMillis) {
        super(timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (device == null) {
            return;
        }
        ScanResult scanResult = new ScanResult(device, rssi, scanRecord, System.currentTimeMillis());
        ListScanCallback listScanCallback = this;
        synchronized (listScanCallback) {
            this.hasFound.set(false);
            for (ScanResult result : this.resultList) {
                if (!result.getDevice().equals((Object)device)) continue;
                this.hasFound.set(true);
            }
            if (!this.hasFound.get()) {
                this.resultList.add(scanResult);
                this.onScanning(scanResult);
            }
        }
    }

    @Override
    public void onScanTimeout() {
        ScanResult[] results = new ScanResult[this.resultList.size()];
        for (int i = 0; i < results.length; ++i) {
            results[i] = this.resultList.get(i);
        }
        this.onScanComplete(results);
    }

    @Override
    public void onScanCancel() {
        ScanResult[] resultArr = this.resultList.toArray(new ScanResult[this.resultList.size()]);
        this.onScanComplete(resultArr);
    }

    public abstract void onScanning(ScanResult var1);

    public abstract void onScanComplete(ScanResult[] var1);
}

