/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.scan;

import android.bluetooth.BluetoothDevice;
import android.text.TextUtils;
import com.clj.fastble.scan.PeriodScanCallback;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class MacScanCallback
extends PeriodScanCallback {
    private String mMac;
    private AtomicBoolean hasFound = new AtomicBoolean(false);

    public MacScanCallback(String mac, long timeoutMillis) {
        super(timeoutMillis);
        this.mMac = mac;
        if (mac == null) {
            this.onDeviceNotFound();
        }
    }

    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (device == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)device.getAddress())) {
            return;
        }
        if (!this.hasFound.get() && this.mMac.equalsIgnoreCase(device.getAddress())) {
            this.hasFound.set(true);
            this.bleBluetooth.stopScan(this);
            this.onDeviceFound(device, rssi, scanRecord);
        }
    }

    @Override
    public void onScanTimeout() {
        this.onDeviceNotFound();
    }

    public abstract void onDeviceFound(BluetoothDevice var1, int var2, byte[] var3);

    public abstract void onDeviceNotFound();
}

