/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.clj.fastble.conn.BleConnector;
import com.clj.fastble.conn.BleGattCallback;
import com.clj.fastble.exception.BleException;
import com.clj.fastble.exception.ConnectException;
import com.clj.fastble.scan.MacScanCallback;
import com.clj.fastble.scan.NameScanCallback;
import com.clj.fastble.scan.PeriodScanCallback;
import com.clj.fastble.utils.BleLog;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class BleBluetooth {
    private static final String CONNECT_CALLBACK_KEY = "connect_key";
    public static final String READ_RSSI_KEY = "rssi_key";
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_SCANNING = 1;
    public static final int STATE_CONNECTING = 2;
    public static final int STATE_CONNECTED = 3;
    public static final int STATE_SERVICES_DISCOVERED = 4;
    private int connectionState = 0;
    private Context context;
    private BluetoothManager bluetoothManager;
    private BluetoothAdapter bluetoothAdapter;
    private BluetoothGatt bluetoothGatt;
    private Handler handler = new Handler(Looper.getMainLooper());
    private HashMap<String, BluetoothGattCallback> callbackHashMap = new HashMap();
    private BleGattCallback coreGattCallback = new BleGattCallback(){

        @Override
        public void onNotFoundDevice() {
            BleLog.i("coreGattCallback\uff1aonNotFoundDevice ");
            BleBluetooth.this.bluetoothGatt = null;
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BleGattCallback)) continue;
                ((BleGattCallback)((Object)call)).onNotFoundDevice();
            }
        }

        @Override
        public void onConnectSuccess(BluetoothGatt gatt, int status) {
            BleLog.i("coreGattCallback\uff1aonConnectSuccess ");
            BleBluetooth.this.bluetoothGatt = gatt;
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BleGattCallback)) continue;
                ((BleGattCallback)((Object)call)).onConnectSuccess(gatt, status);
            }
        }

        @Override
        public void onConnectFailure(BleException exception) {
            BleLog.i("coreGattCallback\uff1aonConnectFailure ");
            BleBluetooth.this.bluetoothGatt = null;
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BleGattCallback)) continue;
                ((BleGattCallback)((Object)call)).onConnectFailure(exception);
            }
        }

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            BleLog.i("coreGattCallback\uff1aonConnectionStateChange \nstatus: " + status + '\n' + "newState: " + newState + '\n' + "thread: " + Thread.currentThread().getId());
            if (newState == 2) {
                BleBluetooth.this.connectionState = 3;
                this.onConnectSuccess(gatt, status);
            } else if (newState == 0) {
                BleBluetooth.this.connectionState = 0;
                this.onConnectFailure(new ConnectException(gatt, status));
            } else if (newState == 1) {
                BleBluetooth.this.connectionState = 2;
            }
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BluetoothGattCallback)) continue;
                ((BluetoothGattCallback)call).onConnectionStateChange(gatt, status, newState);
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            BleLog.i("coreGattCallback\uff1aonServicesDiscovered ");
            BleBluetooth.this.connectionState = 4;
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BluetoothGattCallback)) continue;
                ((BluetoothGattCallback)call).onServicesDiscovered(gatt, status);
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            BleLog.i("coreGattCallback\uff1aonCharacteristicRead ");
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BluetoothGattCallback)) continue;
                ((BluetoothGattCallback)call).onCharacteristicRead(gatt, characteristic, status);
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            BleLog.i("coreGattCallback\uff1aonCharacteristicWrite ");
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BluetoothGattCallback)) continue;
                ((BluetoothGattCallback)call).onCharacteristicWrite(gatt, characteristic, status);
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            BleLog.i("coreGattCallback\uff1aonCharacteristicChanged ");
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BluetoothGattCallback)) continue;
                ((BluetoothGattCallback)call).onCharacteristicChanged(gatt, characteristic);
            }
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            BleLog.i("coreGattCallback\uff1aonDescriptorRead ");
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BluetoothGattCallback)) continue;
                ((BluetoothGattCallback)call).onDescriptorRead(gatt, descriptor, status);
            }
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            BleLog.i("coreGattCallback\uff1aonDescriptorWrite ");
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BluetoothGattCallback)) continue;
                ((BluetoothGattCallback)call).onDescriptorWrite(gatt, descriptor, status);
            }
        }

        public void onReliableWriteCompleted(BluetoothGatt gatt, int status) {
            BleLog.i("coreGattCallback\uff1aonReliableWriteCompleted ");
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BluetoothGattCallback)) continue;
                ((BluetoothGattCallback)call).onReliableWriteCompleted(gatt, status);
            }
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
            BleLog.i("coreGattCallback\uff1aonReadRemoteRssi ");
            for (Map.Entry entry : BleBluetooth.this.callbackHashMap.entrySet()) {
                Object call = entry.getValue();
                if (!(call instanceof BluetoothGattCallback)) continue;
                ((BluetoothGattCallback)call).onReadRemoteRssi(gatt, rssi, status);
            }
        }
    };

    public BleBluetooth(Context context) {
        this.context = context = context.getApplicationContext();
        this.bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
        this.bluetoothAdapter = this.bluetoothManager.getAdapter();
    }

    public BleConnector newBleConnector() {
        return new BleConnector(this);
    }

    public boolean isInScanning() {
        return this.connectionState == 1;
    }

    public boolean isConnectingOrConnected() {
        return this.connectionState >= 2;
    }

    public boolean isConnected() {
        return this.connectionState >= 3;
    }

    public boolean isServiceDiscovered() {
        return this.connectionState == 4;
    }

    private void addConnectGattCallback(BleGattCallback callback) {
        this.callbackHashMap.put(CONNECT_CALLBACK_KEY, callback);
    }

    public void addGattCallback(String uuid, BluetoothGattCallback callback) {
        this.callbackHashMap.put(uuid, callback);
    }

    public void removeConnectGattCallback() {
        this.callbackHashMap.remove(CONNECT_CALLBACK_KEY);
    }

    public void removeGattCallback(String key) {
        this.callbackHashMap.remove(key);
    }

    public void clearCallback() {
        this.callbackHashMap.clear();
    }

    public BluetoothGattCallback getGattCallback(String uuid) {
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            return null;
        }
        return this.callbackHashMap.get(uuid);
    }

    public boolean startLeScan(BluetoothAdapter.LeScanCallback callback) {
        boolean success = this.bluetoothAdapter.startLeScan(callback);
        if (success) {
            this.connectionState = 1;
        }
        return success;
    }

    public boolean startLeScan(PeriodScanCallback callback) {
        callback.setBleBluetooth(this).notifyScanStarted();
        boolean success = this.bluetoothAdapter.startLeScan((BluetoothAdapter.LeScanCallback)callback);
        if (success) {
            this.connectionState = 1;
        } else {
            callback.removeHandlerMsg();
        }
        return success;
    }

    public void stopScan(BluetoothAdapter.LeScanCallback callback) {
        if (callback instanceof PeriodScanCallback) {
            ((PeriodScanCallback)callback).removeHandlerMsg();
        }
        this.bluetoothAdapter.stopLeScan(callback);
        if (this.connectionState == 1) {
            this.connectionState = 0;
        }
    }

    public synchronized BluetoothGatt connect(BluetoothDevice device, boolean autoConnect, BleGattCallback callback) {
        BleLog.i("connect name: " + device.getName() + "\nmac: " + device.getAddress() + "\nautoConnect: " + autoConnect);
        this.addConnectGattCallback(callback);
        return device.connectGatt(this.context, autoConnect, (BluetoothGattCallback)this.coreGattCallback);
    }

    public boolean scanNameAndConnect(String name, long time_out, final boolean autoConnect, final BleGattCallback callback) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            if (callback != null) {
                callback.onNotFoundDevice();
            }
            return false;
        }
        return this.startLeScan(new NameScanCallback(name, time_out){

            @Override
            public void onDeviceFound(final BluetoothDevice device, int rssi, byte[] scanRecord) {
                BleBluetooth.this.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        BleBluetooth.this.connect(device, autoConnect, callback);
                    }
                });
            }

            @Override
            public void onDeviceNotFound() {
                if (callback != null) {
                    callback.onNotFoundDevice();
                }
            }
        });
    }

    public boolean scanMacAndConnect(String mac, long time_out, final boolean autoConnect, final BleGattCallback callback) {
        if (TextUtils.isEmpty((CharSequence)mac)) {
            if (callback != null) {
                callback.onNotFoundDevice();
            }
            return false;
        }
        return this.startLeScan(new MacScanCallback(mac, time_out){

            @Override
            public void onDeviceFound(final BluetoothDevice device, int rssi, byte[] scanRecord) {
                BleBluetooth.this.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        BleBluetooth.this.connect(device, autoConnect, callback);
                    }
                });
            }

            @Override
            public void onDeviceNotFound() {
                if (callback != null) {
                    callback.onNotFoundDevice();
                }
            }
        });
    }

    public boolean refreshDeviceCache() {
        try {
            Method refresh = BluetoothGatt.class.getMethod("refresh", new Class[0]);
            if (refresh != null) {
                boolean success = (Boolean)refresh.invoke((Object)this.getBluetoothGatt(), new Object[0]);
                BleLog.i("Refreshing result: " + success);
                return success;
            }
        }
        catch (Exception e) {
            BleLog.i("An exception occured while refreshing device", e);
        }
        return false;
    }

    public void closeBluetoothGatt() {
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.disconnect();
        }
        if (this.bluetoothGatt != null) {
            this.refreshDeviceCache();
        }
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.close();
        }
    }

    public void enableBluetoothIfDisabled() {
        if (!this.isBlueEnable()) {
            this.enableBluetooth();
        }
    }

    public boolean isBlueEnable() {
        return this.bluetoothAdapter.isEnabled();
    }

    public void enableBluetooth() {
        this.bluetoothAdapter.enable();
    }

    public void disableBluetooth() {
        this.bluetoothAdapter.disable();
    }

    private void runOnMainThread(Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
        } else {
            this.handler.post(runnable);
        }
    }

    public Context getContext() {
        return this.context;
    }

    public BluetoothManager getBluetoothManager() {
        return this.bluetoothManager;
    }

    public BluetoothAdapter getBluetoothAdapter() {
        return this.bluetoothAdapter;
    }

    public BluetoothGatt getBluetoothGatt() {
        return this.bluetoothGatt;
    }

    public int getConnectionState() {
        return this.connectionState;
    }
}

