package com.clj.fastble.scan;

import android.bluetooth.BluetoothDevice;
import android.text.TextUtils;

import java.util.concurrent.atomic.AtomicBoolean;


public abstract class NameScanCallback extends PeriodScanCallback {


    private String name;

    private AtomicBoolean hasFound = new AtomicBoolean(false);


    public NameScanCallback(String name, long timeoutMillis) {
        super(timeoutMillis);
        this.name = name;
        if (name == null) {
            throw new IllegalArgumentException("start scan, name can not be null!");
        }
    }

    @Override
    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (device == null)
            return;
        if (TextUtils.isEmpty(device.getName())) {
            return;
        }

        if (!hasFound.get()) {
            if (name.equalsIgnoreCase(device.getName())) {
                hasFound.set(true);
                bleBluetooth.stopScan(NameScanCallback.this);
                onDeviceFound(device, rssi, scanRecord);
            }
        }
    }

    public abstract void onDeviceFound(BluetoothDevice device, int rssi, byte[] scanRecord);
}
