/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.utils;

import android.app.Activity;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Intent;
import android.util.Log;
import com.clj.fastble.log.BleLog;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.UUID;

public class BluetoothUtil {
    private static final String TAG = "BluetoothUtil";

    public static void enableBluetooth(Activity activity, int requestCode) {
        Intent intent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
        activity.startActivityForResult(intent, requestCode);
    }

    public static void printServices(BluetoothGatt gatt) {
        if (gatt != null) {
            for (BluetoothGattService service : gatt.getServices()) {
                BleLog.i(TAG, "service: " + service.getUuid());
                for (BluetoothGattCharacteristic characteristic : service.getCharacteristics()) {
                    BleLog.d(TAG, "    characteristic: " + characteristic.getUuid() + "   ------  value: " + Arrays.toString(characteristic.getValue()) + "   ------  properties: " + characteristic.getProperties());
                    for (BluetoothGattDescriptor descriptor : characteristic.getDescriptors()) {
                        BleLog.v(TAG, "    descriptor: " + descriptor.getUuid() + "   ------  value: " + Arrays.toString(descriptor.getValue()));
                    }
                }
            }
        }
    }

    public static boolean refreshDeviceCache(BluetoothGatt gatt) {
        try {
            Method refresh = BluetoothGatt.class.getMethod("refresh", new Class[0]);
            if (refresh != null) {
                boolean success = (Boolean)refresh.invoke((Object)gatt, new Object[0]);
                Log.i((String)TAG, (String)("Refreshing result: " + success));
                return success;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"An exception occured while refreshing device", (Throwable)e);
        }
        return false;
    }

    public static void closeBluetoothGatt(BluetoothGatt gatt) {
        if (gatt != null) {
            gatt.disconnect();
            BluetoothUtil.refreshDeviceCache(gatt);
            gatt.close();
        }
    }

    public static BluetoothGattService getService(BluetoothGatt gatt, String serviceUUID) {
        return gatt.getService(UUID.fromString(serviceUUID));
    }

    public static BluetoothGattCharacteristic getCharacteristic(BluetoothGattService service, String charactUUID) {
        if (service != null) {
            return service.getCharacteristic(UUID.fromString(charactUUID));
        }
        return null;
    }

    public static BluetoothGattCharacteristic getCharacteristic(BluetoothGatt gatt, String serviceUUID, String charactUUID) {
        BluetoothGattService service = gatt.getService(UUID.fromString(serviceUUID));
        if (service != null) {
            return service.getCharacteristic(UUID.fromString(charactUUID));
        }
        return null;
    }
}

