/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.scan;

import android.bluetooth.BluetoothDevice;
import android.text.TextUtils;
import com.clj.fastble.scan.PeriodScanCallback;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class MacScanCallback
extends PeriodScanCallback {
    private String mac;
    private AtomicBoolean hasFound = new AtomicBoolean(false);

    public MacScanCallback(String mac, long timeoutMillis) {
        super(timeoutMillis);
        this.mac = mac;
        if (mac == null) {
            throw new IllegalArgumentException("start scan, mac can not be null!");
        }
    }

    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (device == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)device.getAddress())) {
            return;
        }
        if (!this.hasFound.get() && this.mac.equalsIgnoreCase(device.getAddress())) {
            this.hasFound.set(true);
            this.bleBluetooth.stopScan(this);
            this.onDeviceFound(device, rssi, scanRecord);
        }
    }

    public abstract void onDeviceFound(BluetoothDevice var1, int var2, byte[] var3);
}

