/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble;

import android.app.Activity;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.util.Log;
import com.clj.fastble.bluetooth.BleBluetooth;
import com.clj.fastble.bluetooth.BleGattCallback;
import com.clj.fastble.conn.BleCharacterCallback;
import com.clj.fastble.exception.BleException;
import com.clj.fastble.exception.hanlder.DefaultBleExceptionHandler;
import com.clj.fastble.scan.ListScanCallback;

public class BleManager {
    private static final String TAG = "BleManager";
    private Context mContext;
    private static BleManager manager;
    private static BleBluetooth bleBluetooth;
    private DefaultBleExceptionHandler bleExceptionHandler;

    public static BleManager getInstance() {
        if (manager == null) {
            manager = new BleManager();
        }
        return manager;
    }

    public void init(Context context) {
        this.mContext = context.getApplicationContext();
        if (bleBluetooth == null) {
            bleBluetooth = new BleBluetooth(context);
        }
        bleBluetooth.enableBluetoothIfDisabled((Activity)context, 1);
        this.bleExceptionHandler = new DefaultBleExceptionHandler(context);
    }

    public void handleException(BleException exception) {
        this.bleExceptionHandler.handleException(exception);
    }

    public boolean scanDevice(ListScanCallback callback) {
        return this.scanAllDevice(callback);
    }

    public void connectDevice(BluetoothDevice device, boolean autoConnect, BleGattCallback callback) {
        this.connect(device, autoConnect, callback);
    }

    public boolean connectDevice(String deviceName, long time_out, boolean autoConnect, BleGattCallback callback) {
        return this.scanNameAndConnect(deviceName, time_out, autoConnect, callback);
    }

    public boolean connectMac(String mac, long time_out, boolean autoConnect, BleGattCallback callback) {
        return this.scanMacAndConnect(mac, time_out, autoConnect, callback);
    }

    public boolean notifyDevice(String uuid_service, String uuid_notification, BleCharacterCallback callback) {
        return this.enableNotifyOfCharacteristic(uuid_service, uuid_notification, callback);
    }

    public boolean indicateDevice(String uuid_service, String uuid_indication, BleCharacterCallback callback) {
        return this.enableIndicateOfCharacteristic(uuid_service, uuid_indication, callback);
    }

    public boolean writeDevice(String uuid_service, String uuid_write, byte[] data, BleCharacterCallback callback) {
        return this.writeDataToCharacteristic(uuid_service, uuid_write, data, callback);
    }

    public boolean readDevice(String uuid_service, String uuid_read, BleCharacterCallback callback) {
        return this.readDataFromCharacteristic(uuid_service, uuid_read, callback);
    }

    public void getBluetoothState() {
        Log.d((String)TAG, (String)("ConnectionState:  " + bleBluetooth.getConnectionState() + "\nisInScanning: " + bleBluetooth.isInScanning() + "\nisConnected: " + bleBluetooth.isConnected() + "\nisServiceDiscovered: " + bleBluetooth.isServiceDiscovered()));
    }

    public void refreshDeviceCache() {
        bleBluetooth.refreshDeviceCache();
    }

    public void closeBluetoothGatt() {
        if (bleBluetooth != null) {
            bleBluetooth.clearCallback();
            try {
                bleBluetooth.closeBluetoothGatt();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isSupportBle() {
        return this.mContext.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    public void enableBluetooth() {
        if (bleBluetooth != null) {
            bleBluetooth.enableBluetooth();
        }
    }

    public void disableBluetooth() {
        if (bleBluetooth != null) {
            bleBluetooth.disableBluetooth();
        }
    }

    public boolean isBlueEnable() {
        if (bleBluetooth != null) {
            return bleBluetooth.isBlueEnable();
        }
        return false;
    }

    public boolean isInScanning() {
        return bleBluetooth.isInScanning();
    }

    public boolean isConnectingOrConnected() {
        return bleBluetooth.isConnectingOrConnected();
    }

    public boolean isConnected() {
        return bleBluetooth.isConnected();
    }

    public boolean isServiceDiscovered() {
        return bleBluetooth.isServiceDiscovered();
    }

    public void stopListenCharacterCallback(String uuid) {
        bleBluetooth.removeGattCallback(uuid);
    }

    public void stopListenConnectCallback() {
        bleBluetooth.removeConnectGattCallback();
    }

    public boolean stopNotify(String uuid_service, String uuid_notify) {
        return bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_notify, null).disableCharacteristicNotify();
    }

    public boolean stopIndicate(String uuid_service, String uuid_notify) {
        return bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_notify, null).disableCharacteristicIndicate();
    }

    private boolean scanAllDevice(ListScanCallback callback) {
        return bleBluetooth.startLeScan(callback);
    }

    private void connect(BluetoothDevice device, boolean autoConnect, BleGattCallback callback) {
        bleBluetooth.connect(device, autoConnect, callback);
    }

    private boolean scanNameAndConnect(String deviceName, long time_out, boolean autoConnect, BleGattCallback callback) {
        return bleBluetooth.scanNameAndConnect(deviceName, time_out, autoConnect, callback);
    }

    private boolean scanMacAndConnect(String deviceName, long time_out, boolean autoConnect, BleGattCallback callback) {
        return bleBluetooth.scanMacAndConnect(deviceName, time_out, autoConnect, callback);
    }

    private boolean enableNotifyOfCharacteristic(String uuid_service, String uuid_notify, BleCharacterCallback callback) {
        return bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_notify, null).enableCharacteristicNotify(callback, uuid_notify);
    }

    private boolean enableIndicateOfCharacteristic(String uuid_service, String uuid_indicate, BleCharacterCallback callback) {
        return bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_indicate, null).enableCharacteristicIndicate(callback, uuid_indicate);
    }

    private boolean writeDataToCharacteristic(String uuid_service, String uuid_write, byte[] data, BleCharacterCallback callback) {
        return bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_write, null).writeCharacteristic(data, callback, uuid_write);
    }

    private boolean readDataFromCharacteristic(String uuid_service, String uuid_read, BleCharacterCallback callback) {
        return bleBluetooth.newBleConnector().withUUIDString(uuid_service, uuid_read, null).readCharacteristic(callback, uuid_read);
    }
}

