/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.scan;

import android.bluetooth.BluetoothDevice;
import android.text.TextUtils;
import com.clj.fastble.scan.PeriodScanCallback;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NameScanCallback
extends PeriodScanCallback {
    private String name;
    private AtomicBoolean hasFound = new AtomicBoolean(false);

    public NameScanCallback(String name, long timeoutMillis) {
        super(timeoutMillis);
        this.name = name;
        if (name == null) {
            throw new IllegalArgumentException("start scan, name can not be null!");
        }
    }

    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (device == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)device.getName())) {
            return;
        }
        if (!this.hasFound.get() && this.name.equalsIgnoreCase(device.getName())) {
            this.hasFound.set(true);
            this.bleBluetooth.stopScan(this);
            this.onDeviceFound(device, rssi, scanRecord);
        }
    }

    public abstract void onDeviceFound(BluetoothDevice var1, int var2, byte[] var3);
}

