/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.conn;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.clj.fastble.bluetooth.BleBluetooth;
import com.clj.fastble.conn.BleCallback;
import com.clj.fastble.conn.BleCharacterCallback;
import com.clj.fastble.conn.BleRssiCallback;
import com.clj.fastble.exception.BleException;
import com.clj.fastble.exception.GattException;
import com.clj.fastble.exception.InitiatedException;
import com.clj.fastble.exception.OtherException;
import com.clj.fastble.log.BleLog;
import com.clj.fastble.utils.HexUtil;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class BleConnector {
    private static final String TAG = "BleConnector";
    private static final String UUID_CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR = "00002902-0000-1000-8000-00805f9b34fb";
    private static final int MSG_WRITE_CHA = 1;
    private static final int MSG_WRIATE_DES = 2;
    private static final int MSG_READ_CHA = 3;
    private static final int MSG_READ_DES = 4;
    private static final int MSG_READ_RSSI = 5;
    private static final int MSG_NOTIFY_CHA = 6;
    private static final int MSG_NOTIY_DES = 7;
    private static final int MSG_INDICATE_DES = 8;
    private BluetoothGatt bluetoothGatt;
    private BluetoothGattService service;
    private BluetoothGattCharacteristic characteristic;
    private BluetoothGattDescriptor descriptor;
    private BleBluetooth liteBluetooth;
    private int timeOutMillis = 20000;
    private Handler handler = new MyHandler();

    public BleConnector(BleBluetooth liteBluetooth) {
        this.liteBluetooth = liteBluetooth;
        this.bluetoothGatt = liteBluetooth.getBluetoothGatt();
        this.handler = new Handler(Looper.getMainLooper());
    }

    public BleConnector(BleBluetooth liteBluetooth, BluetoothGattService service, BluetoothGattCharacteristic characteristic, BluetoothGattDescriptor descriptor) {
        this(liteBluetooth);
        this.service = service;
        this.characteristic = characteristic;
        this.descriptor = descriptor;
    }

    public BleConnector(BleBluetooth liteBluetooth, UUID serviceUUID, UUID charactUUID, UUID descriptorUUID, UUID client_characteristic_conifgUUID) {
        this(liteBluetooth);
        this.withUUID(serviceUUID, charactUUID, descriptorUUID);
    }

    public BleConnector(BleBluetooth liteBluetooth, String serviceUUID, String charactUUID, String descriptorUUID, String client_characteristic_conifgUUID) {
        this(liteBluetooth);
        this.withUUIDString(serviceUUID, charactUUID, descriptorUUID);
    }

    public BleConnector withUUID(UUID serviceUUID, UUID charactUUID, UUID descriptorUUID) {
        if (serviceUUID != null && this.bluetoothGatt != null) {
            this.service = this.bluetoothGatt.getService(serviceUUID);
        }
        if (this.service != null && charactUUID != null) {
            this.characteristic = this.service.getCharacteristic(charactUUID);
        }
        if (this.characteristic != null && descriptorUUID != null) {
            this.descriptor = this.characteristic.getDescriptor(descriptorUUID);
        }
        return this;
    }

    public BleConnector withUUIDString(String serviceUUID, String charactUUID, String descriptorUUID) {
        return this.withUUID(this.formUUID(serviceUUID), this.formUUID(charactUUID), this.formUUID(descriptorUUID));
    }

    private UUID formUUID(String uuid) {
        return uuid == null ? null : UUID.fromString(uuid);
    }

    public boolean enableCharacteristicNotify(BleCharacterCallback bleCallback, String uuid_notify) {
        return this.enableCharacteristicNotify(this.getCharacteristic(), bleCallback, uuid_notify);
    }

    public boolean enableCharacteristicNotify(BluetoothGattCharacteristic characteristic, BleCharacterCallback bleCallback, String uuid_notify) {
        if (characteristic != null && (characteristic.getProperties() | 0x10) > 0) {
            BleLog.w(TAG, "characteristic.getProperties():" + characteristic.getProperties());
            this.handleCharacteristicNotificationCallback(bleCallback, uuid_notify);
            return this.setCharacteristicNotification(this.getBluetoothGatt(), characteristic, true);
        }
        if (bleCallback != null) {
            bleCallback.onFailure(new OtherException("Characteristic not support notify!"));
        }
        return false;
    }

    public boolean disableCharacteristicNotify() {
        return this.disableCharacteristicNotify(this.getCharacteristic());
    }

    public boolean disableCharacteristicNotify(BluetoothGattCharacteristic characteristic) {
        if (characteristic != null && (characteristic.getProperties() | 0x10) > 0) {
            BleLog.w(TAG, "characteristic.getProperties():" + characteristic.getProperties());
            return this.setCharacteristicNotification(this.getBluetoothGatt(), characteristic, false);
        }
        return false;
    }

    public boolean enableCharacteristicIndicate(BleCharacterCallback bleCallback, String uuid_indicate) {
        return this.enableCharacteristicIndicate(this.getCharacteristic(), bleCallback, uuid_indicate);
    }

    public boolean enableCharacteristicIndicate(BluetoothGattCharacteristic characteristic, BleCharacterCallback bleCallback, String uuid_indicate) {
        if (characteristic != null && (characteristic.getProperties() | 0x10) > 0) {
            BleLog.w(TAG, "characteristic.getProperties():" + characteristic.getProperties());
            this.handleCharacteristicIndicationCallback(bleCallback, uuid_indicate);
            return this.setCharacteristicIndication(this.getBluetoothGatt(), characteristic, true);
        }
        if (bleCallback != null) {
            bleCallback.onFailure(new OtherException("Characteristic not support indicate!"));
        }
        return false;
    }

    public boolean disableCharacteristicIndicate() {
        return this.disableCharacteristicIndicate(this.getCharacteristic());
    }

    public boolean disableCharacteristicIndicate(BluetoothGattCharacteristic characteristic) {
        if (characteristic != null && (characteristic.getProperties() | 0x10) > 0) {
            BleLog.w(TAG, "characteristic.getProperties():" + characteristic.getProperties());
            return this.setCharacteristicIndication(this.getBluetoothGatt(), characteristic, false);
        }
        return false;
    }

    public boolean writeCharacteristic(byte[] data, BleCharacterCallback bleCallback, String uuid_write) {
        if (data == null) {
            return false;
        }
        return this.writeCharacteristic(this.getCharacteristic(), data, bleCallback, uuid_write);
    }

    public boolean writeCharacteristic(BluetoothGattCharacteristic character, byte[] data, BleCharacterCallback bleCallback, String uuid_write) {
        if (character == null || (character.getProperties() & 0xC) == 0) {
            if (bleCallback != null) {
                bleCallback.onFailure(new OtherException("Characteristic not support write!"));
            }
            return false;
        }
        BleLog.d(TAG, character.getUuid() + "\ncharacteristic.getProperties():" + character.getProperties() + "\n characteristic.getValue(): " + Arrays.toString(character.getValue()) + "\n characteristic write bytes: " + Arrays.toString(data) + "\n hex: " + HexUtil.encodeHexStr(data));
        this.handleCharacteristicWriteCallback(bleCallback, uuid_write);
        character.setValue(data);
        return this.handleAfterInitialed(this.getBluetoothGatt().writeCharacteristic(character), bleCallback);
    }

    public boolean readCharacteristic(BleCharacterCallback bleCallback, String uuid_read) {
        return this.readCharacteristic(this.getCharacteristic(), bleCallback, uuid_read);
    }

    public boolean readCharacteristic(BluetoothGattCharacteristic character, BleCharacterCallback bleCallback, String uuid_read) {
        if (character != null && (this.characteristic.getProperties() & 2) > 0) {
            BleLog.d(TAG, character.getUuid() + "\ncharacteristic.getProperties():" + character.getProperties() + "\n characteristic.getValue(): " + Arrays.toString(character.getValue()));
            this.setCharacteristicNotification(this.getBluetoothGatt(), character, false);
            this.handleCharacteristicReadCallback(bleCallback, uuid_read);
            return this.handleAfterInitialed(this.getBluetoothGatt().readCharacteristic(character), bleCallback);
        }
        if (bleCallback != null) {
            bleCallback.onFailure(new OtherException("Characteristic not support read!"));
        }
        return false;
    }

    public boolean readRemoteRssi(BleRssiCallback bleCallback) {
        this.handleRSSIReadCallback(bleCallback);
        return this.handleAfterInitialed(this.getBluetoothGatt().readRemoteRssi(), bleCallback);
    }

    private boolean handleAfterInitialed(boolean initiated, BleCallback bleCallback) {
        if (bleCallback != null) {
            BleLog.d(TAG, "initiated:" + initiated);
            if (initiated) {
                bleCallback.onInitiatedSuccess();
            } else {
                bleCallback.onFailure(new InitiatedException());
            }
        }
        return initiated;
    }

    public boolean setCharacteristicNotification(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, boolean enable) {
        if (gatt == null || characteristic == null) {
            BleLog.w(TAG, "gatt or characteristic equal null");
            return false;
        }
        int properties = characteristic.getProperties();
        if ((properties & 0x10) == 0) {
            BleLog.w(TAG, "Check characteristic property: false");
            return false;
        }
        boolean success = gatt.setCharacteristicNotification(characteristic, enable);
        BleLog.d(TAG, "setCharacteristicNotification----" + enable + "----success:" + success + '\n' + "characteristic.getUuid():" + characteristic.getUuid());
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(this.formUUID(UUID_CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR));
        if (descriptor != null) {
            descriptor.setValue(enable ? BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
            return gatt.writeDescriptor(descriptor);
        }
        return false;
    }

    public boolean setCharacteristicIndication(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, boolean enable) {
        if (gatt == null || characteristic == null) {
            BleLog.w(TAG, "gatt or characteristic equal null");
            return false;
        }
        int properties = characteristic.getProperties();
        if ((properties & 0x20) == 0) {
            Log.w((String)TAG, (String)"Check characteristic property: false");
            return false;
        }
        boolean success = gatt.setCharacteristicNotification(characteristic, enable);
        BleLog.d(TAG, "setCharacteristicIndication----" + enable + "----success:" + success + '\n' + "characteristic.getUuid():" + characteristic.getUuid());
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(this.formUUID(UUID_CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR));
        if (descriptor != null) {
            descriptor.setValue(enable ? BluetoothGattDescriptor.ENABLE_INDICATION_VALUE : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
            return gatt.writeDescriptor(descriptor);
        }
        return false;
    }

    private void handleCharacteristicNotificationCallback(final BleCharacterCallback bleCallback, final String uuid_notify) {
        if (bleCallback != null) {
            this.listenAndTimer(bleCallback, 6, uuid_notify, new BluetoothGattCallback(){
                AtomicBoolean msgRemoved = new AtomicBoolean(false);

                public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
                    if (!this.msgRemoved.getAndSet(true)) {
                        BleConnector.this.handler.removeMessages(6, (Object)this);
                    }
                    if (characteristic.getUuid().equals(UUID.fromString(uuid_notify))) {
                        bleCallback.onSuccess(characteristic);
                    }
                }
            });
        }
    }

    private void handleCharacteristicIndicationCallback(final BleCharacterCallback bleCallback, final String uuid_indicate) {
        if (bleCallback != null) {
            this.listenAndTimer(bleCallback, 8, uuid_indicate, new BluetoothGattCallback(){
                AtomicBoolean msgRemoved = new AtomicBoolean(false);

                public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
                    if (!this.msgRemoved.getAndSet(true)) {
                        BleConnector.this.handler.removeMessages(8, (Object)this);
                    }
                    if (characteristic.getUuid().equals(UUID.fromString(uuid_indicate))) {
                        bleCallback.onSuccess(characteristic);
                    }
                }
            });
        }
    }

    private void handleCharacteristicWriteCallback(final BleCharacterCallback bleCallback, final String uuid_write) {
        if (bleCallback != null) {
            this.listenAndTimer(bleCallback, 1, uuid_write, new BluetoothGattCallback(){

                public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
                    BleConnector.this.handler.removeMessages(1, (Object)this);
                    if (status == 0) {
                        if (characteristic.getUuid().equals(UUID.fromString(uuid_write))) {
                            bleCallback.onSuccess(characteristic);
                        }
                    } else {
                        bleCallback.onFailure(new GattException(status));
                    }
                }
            });
        }
    }

    private void handleCharacteristicReadCallback(final BleCharacterCallback bleCallback, final String uuid_read) {
        if (bleCallback != null) {
            this.listenAndTimer(bleCallback, 3, uuid_read, new BluetoothGattCallback(){
                AtomicBoolean msgRemoved = new AtomicBoolean(false);

                public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
                    if (!this.msgRemoved.getAndSet(true)) {
                        BleConnector.this.handler.removeMessages(3, (Object)this);
                    }
                    if (status == 0) {
                        if (characteristic.getUuid().equals(UUID.fromString(uuid_read))) {
                            bleCallback.onSuccess(characteristic);
                        }
                    } else {
                        bleCallback.onFailure(new GattException(status));
                    }
                }
            });
        }
    }

    private void handleRSSIReadCallback(final BleRssiCallback bleCallback) {
        if (bleCallback != null) {
            this.listenAndTimer(bleCallback, 5, "rssi_key", new BluetoothGattCallback(){

                public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
                    BleConnector.this.handler.removeMessages(5, (Object)this);
                    if (status == 0) {
                        bleCallback.onSuccess(rssi);
                    } else {
                        bleCallback.onFailure(new GattException(status));
                    }
                }
            });
        }
    }

    private void listenAndTimer(BleCallback bleCallback, int what, String uuid, BluetoothGattCallback callback) {
        bleCallback.setBluetoothGattCallback(callback);
        this.liteBluetooth.addGattCallback(uuid, callback);
        Message msg = this.handler.obtainMessage(what, (Object)bleCallback);
        this.handler.sendMessageDelayed(msg, (long)this.timeOutMillis);
    }

    public BluetoothGatt getBluetoothGatt() {
        return this.bluetoothGatt;
    }

    public BleConnector setBluetoothGatt(BluetoothGatt bluetoothGatt) {
        this.bluetoothGatt = bluetoothGatt;
        return this;
    }

    public BluetoothGattService getService() {
        return this.service;
    }

    public BleConnector setService(BluetoothGattService service) {
        this.service = service;
        return this;
    }

    public BluetoothGattCharacteristic getCharacteristic() {
        return this.characteristic;
    }

    public BleConnector setCharacteristic(BluetoothGattCharacteristic characteristic) {
        this.characteristic = characteristic;
        return this;
    }

    public BluetoothGattDescriptor getDescriptor() {
        return this.descriptor;
    }

    public BleConnector setDescriptor(BluetoothGattDescriptor descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    public int getTimeOutMillis() {
        return this.timeOutMillis;
    }

    public BleConnector setTimeOutMillis(int timeOutMillis) {
        this.timeOutMillis = timeOutMillis;
        return this;
    }

    @SuppressLint(value={"HandlerLeak"})
    private class MyHandler
    extends Handler {
        private MyHandler() {
        }

        public void handleMessage(Message msg) {
            BleCallback call = (BleCallback)msg.obj;
            if (call != null) {
                call.onFailure(BleException.TIMEOUT_EXCEPTION);
            }
            msg.obj = null;
        }
    }
}

