[#-- This template contains the core logic for generating the various parser routines. --]

[#import "CommonUtils.inc.ftl" as CU]

[#var nodeNumbering = 0]
[#var NODE_USES_PARSER = settings.nodeUsesParser]
[#var NODE_PREFIX = grammar.nodePrefix]
[#var currentProduction]

[#macro Productions]
// ===================================================================
// Start of methods for BNF Productions
// This code is generated by the ParserProductions.inc.ftl template.
// ===================================================================
[#list grammar.parserProductions as production]
  [@CU.firstSetVar production.expansion/]
   [#if !production.onlyForLookahead]
    [#set currentProduction = production]
    [@ParserProduction production/]
   [/#if]
[/#list]
[#if settings.faultTolerant]
  [@BuildRecoverRoutines /]
[/#if]
[/#macro]

[#macro ParserProduction production]
        ${production.leadingComments}
        // ${production.location}
        ${globals.startProduction()}${globals.translateModifiers(production.accessModifier)} ${globals.translateType(production.returnType)} Parse${production.name}([#if production.parameterList?has_content]${globals.translateParameters(production.parameterList)}[/#if]) {
            var prevProduction = _currentlyParsedProduction;
            _currentlyParsedProduction = "${production.name}";
${BuildCode(production.expansion, 12)}
        }
        // end of Parse${production.name}${globals.endProduction()}

[/#macro]

[#macro BuildCode expansion indent]
[#var is=""?right_pad(indent)]
[#-- // DBG > BuildCode ${indent} ${expansion.simpleName} --]
  [#if expansion.simpleName != "ExpansionSequence" && expansion.simpleName != "ExpansionWithParentheses"]
// Code for ${expansion.simpleName} specified at ${expansion.location}
  [/#if]
     [@CU.HandleLexicalStateChange expansion false indent; indent]
      [#if settings.faultTolerant && expansion.requiresRecoverMethod && !expansion.possiblyEmpty]
if (_pendingRecovery) {
    ${expansion.recoverMethodName}();
}
      [/#if]
       [@TreeBuildingAndRecovery expansion indent/]
     [/@CU.HandleLexicalStateChange]
[#-- // DBG < BuildCode ${indent} ${expansion.simpleName} --]
[/#macro]

[#macro TreeBuildingAndRecovery expansion indent]
[#-- This macro handles both tree building AND recovery. It doesn't seem right.
     It should probably be two macros. Also, it is too darned big. --]
[#var is=""?right_pad(indent)]
[#-- // DBG > TreeBuildingAndRecovery ${indent} --]
    [#var nodeVarName,
          nodeTypeName,
          production,
          treeNodeBehavior,
          treeNodeLHS,
          buildTreeNode=false,
          closeCondition = "true",
          javaCodePrologue = null,
          parseExceptionVar = CU.newVarName("parseException"),
          callStackSizeVar = CU.newVarName("callStackSize"),
          canRecover = settings.faultTolerant && expansion.tolerantParsing && expansion.simpleName != "Terminal"
    ]
    [#set treeNodeBehavior = expansion.treeNodeBehavior]
    [#if treeNodeBehavior?? && expansion.treeNodeBehavior.LHS??]
          [#set treeNodeLHS = expansion.treeNodeBehavior.LHS]
    [/#if]
    [#if expansion.parent.simpleName = "BNFProduction"]
      [#set production = expansion.parent]
      [#set javaCodePrologue = production.javaCode]
    [/#if]
    [#if settings.treeBuildingEnabled]
      [#set buildTreeNode = (treeNodeBehavior?is_null && production?? && !settings.nodeDefaultVoid)
                        || (treeNodeBehavior?? && !treeNodeBehavior.neverInstantiated)]
    [/#if]
    [#if !buildTreeNode && !canRecover]
${globals.translateCodeBlock(javaCodePrologue, indent)}[#rt]
${BuildExpansionCode(expansion, indent)}
    [#else]
     [#-- buildTreeNode || canRecover --]
     [#if buildTreeNode]
       [#if production??]
       [#set nodeVarName = "thisProduction"] 
       [#-- this is so that (potentially deeply nested) code blocks can easily reference the production node.
         Instead could be a currentProduction.name with the first char lower-cased, maybe, but I don't think so. Also,
         I didn't change CURRENT_NODE to refer to this because it would affect TBA nodes below the top level, but if
         CURRENT_NODE is meant to refer to the current production, then it probably should be changed.  I suspect that
         uses of CURRENT_NODE are all at the top level now anyway and the need to reference the current node just built is relatively
         rare and could use peek(). --]
       [#else]
       [#set nodeNumbering = nodeNumbering +1]
       [#set nodeVarName = currentProduction.name + nodeNumbering] 
       [/#if]
       ${globals.pushNodeVariableName(nodeVarName)!}
       [#set nodeTypeName = nodeClassName(treeNodeBehavior)]      
       [#if !treeNodeBehavior?? && !production?is_null]
         [#if settings.smartNodeCreation]
            [#set treeNodeBehavior = {"name" : production.name, "condition" : "1", "gtNode" : true, "void" :false, "initialShorthand" : " > "}]
         [#else]
            [#set treeNodeBehavior = {"name" : production.name, "condition" : null, "gtNode" : false, "void" : false}]
         [/#if]
      [/#if]
      [#if treeNodeBehavior.condition?has_content]
         [#set closeCondition = globals.translateString(treeNodeBehavior.condition)]
         [#if treeNodeBehavior.gtNode]
            [#set closeCondition = "NodeArity" + treeNodeBehavior.initialShorthand + closeCondition]
         [/#if]
      [/#if]
      [@createNode treeNodeBehavior nodeVarName indent /]
      [/#if]
         [#-- I put this here for the hypertechnical reason
              that I want the initial code block to be able to
              reference CURRENT_NODE. --]
${globals.translateCodeBlock(javaCodePrologue, indent)}
ParseException ${parseExceptionVar} = null;
var ${callStackSizeVar} = ParsingStack.Count;
try {
[#--     pass  # in case there's nothing else in the try clause! --]
[#--     # nested code starts, passing indent of ${indent + 4} --]
${BuildExpansionCode(expansion, indent + 4)}
[#--     # nested code ends --]
}
catch (ParseException e) {
    ${parseExceptionVar} = e;
            [#if !canRecover]
              [#if settings.faultTolerant]
    if (IsTolerant) _pendingRecovery = true;
              [/#if]
    throw;
            [#else]
    if (!IsTolerant) throw;
    _pendingRecovery = true;
         ${expansion.customErrorRecoveryBlock!}
             [#if !production?is_null && production.returnType != "void"]
                [#var rt = production.returnType]
                [#-- We need a return statement here or the code won't compile! --]
                [#if rt = "int" || rt="char" || rt=="byte" || rt="short" || rt="long" || rt="float"|| rt="double"]
       return 0;
                [#else]
       return null;
                [/#if]
             [/#if]
          [/#if]
}
finally {
    RestoreCallStack(${callStackSizeVar});
[#if buildTreeNode]
    if (${nodeVarName} != null) {
        if (${parseExceptionVar} == null) {
            CloseNodeScope(${nodeVarName}, ${closeCondition});
  [#if treeNodeLHS??]
             try {
                 ${treeNodeLHS} = (${nodeTypeName}) PeekNode();
             } catch (Exception) {
                  ${treeNodeLHS} = null;
             }
  [/#if]
  [#list grammar.closeNodeHooksByClass[nodeClassName(treeNodeBehavior)]! as hook]
            ${hook}(${nodeVarName});
  [/#list]
        }
        else {
    [#if settings.faultTolerant]
            CloseNodeScope(${nodeVarName}, true);
            ${nodeVarName}.dirty = true;
    [#else]
            ClearNodeScope();
    [/#if]
                ${globals.popNodeVariableName()!}
        }
[/#if]
        _currentlyParsedProduction = prevProduction;
    }
}
[/#if]
[#-- // DBG < TreeBuildingAndRecovery ${indent} --]
[/#macro]

[#--  Boilerplate code to create the node variable --]
[#macro createNode treeNodeBehavior nodeVarName indent]
[#var is=""?right_pad(indent)]
   [#var nodeName = nodeClassName(treeNodeBehavior)]
${nodeName} ${nodeVarName} = null;
if (BuildTree) {
    ${nodeVarName} = new ${nodeName}([#if settings.nodeUsesParser]this[#else]tokenSource[/#if]);
    OpenNodeScope(${nodeVarName});
}
[/#macro]

[#function nodeClassName treeNodeBehavior]
   [#if treeNodeBehavior?? && treeNodeBehavior.nodeName??]
      [#return NODE_PREFIX + treeNodeBehavior.nodeName]
   [/#if]
   [#return NODE_PREFIX + currentProduction.name]
[/#function]


[#macro BuildExpansionCode expansion indent]
[#var is=""?right_pad(indent)]
[#var classname=expansion.simpleName]
[#-- // DBG > BuildExpansionCode ${indent} ${classname} --]
    [#var prevLexicalStateVar = CU.newVarName("previousLexicalState")]
    [#if classname = "ExpansionWithParentheses"]
${BuildExpansionCode(expansion.nestedExpansion, indent)}
    [#elseif classname = "CodeBlock"]
${globals.translateCodeBlock(expansion, indent)}
    [#elseif classname = "Failure"]
       [@BuildCodeFailure expansion indent /]
    [#elseif classname = "TokenTypeActivation"]
       [@BuildCodeTokenTypeActivation expansion indent /]
    [#elseif classname = "ExpansionSequence"]
       [@BuildCodeSequence expansion indent /]
    [#elseif classname = "NonTerminal"]
       [@BuildCodeNonTerminal expansion indent /]
    [#elseif classname = "Terminal"]
       [@BuildCodeTerminal expansion indent /]
    [#elseif classname = "TryBlock"]
       [@BuildCodeTryBlock expansion indent /]
    [#elseif classname = "AttemptBlock"]
       [@BuildCodeAttemptBlock expansion indent /]
    [#elseif classname = "ZeroOrOne"]
       [@BuildCodeZeroOrOne expansion indent /]
    [#elseif classname = "ZeroOrMore"]
       [@BuildCodeZeroOrMore expansion indent /]
    [#elseif classname = "OneOrMore"]
        [@BuildCodeOneOrMore expansion indent /]
    [#elseif classname = "ExpansionChoice"]
        [@BuildCodeChoice expansion indent /]
    [#elseif classname = "Assertion"]
        [@BuildAssertionCode expansion indent /]
    [/#if]
[#-- // DBG < BuildExpansionCode ${indent} ${classname} --]
[/#macro]

[#macro BuildCodeFailure fail indent]
[#var is = ""?right_pad(indent)]
[#-- // DBG > BuildCodeFailure ${indent} --]
    [#if fail.code?is_null]
      [#if fail.exp??]
Fail("Failure: " + ${fail.exp});
      [#else]
Fail("Failure");
      [/#if]
    [#else]
${globals.translateCodeBlock(fail.code, indent)}
    [/#if]
[#-- // DBG < BuildCodeFailure ${indent} --]
[/#macro]

[#macro BuildCodeTokenTypeActivation activation indent]
[#var is = ""?right_pad(indent)]
[#-- // DBG > BuildCodeTokenTypeActivation ${indent} --]
[#if activation.deactivate]
DeactivateTokenTypes(
[#else]
ActivateTokenTypes(
[/#if]
[#list activation.tokenNames as name]
    ${name}[#if name_has_next],[/#if]
[/#list]
);
[#-- // DBG < BuildCodeTokenTypeActivation ${indent} --]
[/#macro]

[#macro BuildCodeSequence expansion indent]
[#var is = ""?right_pad(indent)]
[#-- // DBG > BuildCodeSequence ${indent} --]
  [#list expansion.units as subexp]
${BuildCode(subexp, indent)}
  [/#list]
[#-- // DBG < BuildCodeSequence ${indent} --]
[/#macro]

[#macro BuildCodeTerminal terminal indent]
[#var regexp =terminal.regexp]
[#var is = ""?right_pad(indent)]
[#-- // DBG > BuildCodeRegexp ${indent} --]
   [#var LHS = ""]
   [#if terminal.lhs??][#set LHS = terminal.lhs + " = "][/#if]
   [#if !settings.faultTolerant]
${LHS}ConsumeToken(TokenType.${regexp.label});
   [#else]
       [#var tolerant = terminal.tolerantParsing?string("true", "false")]
       [#var followSetVarName = terminal.followSetVarName]
       [#if terminal.followSet.incomplete]
         [#set followSetVarName = "followSet" + CU.newID()]
HashSet<TokenType> ${followSetVarName} = null;
if (OuterFollowSet != null) {
    ${followSetVarName} = ${terminal.followSetVarName}.Clone();
    ${followSetVarName}.AddAll(OuterFollowSet);
}
       [/#if]
${LHS}ConsumeToken(${CU.TT}${regexp.label}, ${tolerant}, ${followSetVarName});
   [/#if]
   [#if !terminal.childName?is_null]
if (BuildTree) {
    Node child = PeekNode();
    string name = "${terminal.childName}";
    [#if terminal.multipleChildren]
    ${globals.currentNodeVariableName}.AddToNamedChildList(name, child);
    [#else]
    ${globals.currentNodeVariableName}.SetNamedChild(name, child);
    [/#if]
}
   [/#if]

[#-- // DBG < BuildCodeRegexp ${indent} --]
[/#macro]

[#macro BuildCodeTryBlock tryblock indent]
[#var is = ""?right_pad(indent)]
// DBG > BuildCodeTryBlock ${indent}
try:
${BuildCode(tryblock.nestedExpansion, indent + 4)}
   [#list tryblock.catchBlocks as catchBlock]
   # TODO verify indentation
${catchBlock}
   [/#list]
   # TODO verify indentation
${tryblock.finallyBlock!}
// DBG < BuildCodeTryBlock ${indent}
[/#macro]


[#macro BuildCodeAttemptBlock attemptBlock indent]
[#var is = ""?right_pad(indent)]
// DBG > BuildCodeAttemptBlock ${indent}
try {
    StashParseState();
${BuildCode(attemptBlock.nestedExpansion, indent + 4)}
    PopParseState();
}
catch (ParseException) {
    RestoreStashedParseState();
${BuildCode(attemptBlock.recoveryExpansion, indent + 4)}
}
// DBG < BuildCodeAttemptBlock ${indent}
[/#macro]

[#macro BuildCodeNonTerminal nonterminal indent]
[#var is = ""?right_pad(indent)]
[#-- // DBG > BuildCodeNonTerminal ${indent} ${nonterminal.production.name} --]
   [#var production = nonterminal.production]
PushOntoCallStack("${nonterminal.containingProduction.name}", "${nonterminal.inputSource?j_string}", ${nonterminal.beginLine}, ${nonterminal.beginColumn});
   [#var followSet = nonterminal.followSet]
   [#if !followSet.incomplete]
      [#if !nonterminal.beforeLexicalStateSwitch]
OuterFollowSet = ${nonterminal.followSetVarName};
      [#else]
OuterFollowSet = null;
      [/#if]
   [#else]
     [#if !followSet.isEmpty()]
if (OuterFollowSet != null) {
    var newFollowSet = new HashSet<TokenType>(${nonterminal.followSetVarName});
    newFollowSet.UnionWith(OuterFollowSet);
    OuterFollowSet = newFollowSet;
}
     [/#if]
   [/#if]
try {
   [#if !nonterminal.LHS?is_null && production.returnType != "void"]
    ${nonterminal.LHS} =
   [/#if]
    Parse${nonterminal.name}(${globals.translateNonterminalArgs(nonterminal.args)});
   [#if !nonterminal.LHS?is_null && production.returnType = "void"]
    try {
        ${nonterminal.LHS} = PeekNode();
    }
    catch (Exception) {
        ${nonterminal.LHS} = null;
    }
   [/#if]
   [#if !nonterminal.childName?is_null]
    if (BuildTree) {
        Node child = PeekNode();
        String name = "${nonterminal.childName}";
    [#if nonterminal.multipleChildren]
        ${globals.currentNodeVariableName}.AddToNamedChildList(name, child);
    [#else]
        ${globals.currentNodeVariableName}.SetNamedChild(name, child);
    [/#if]
    }
   [/#if]
}
finally {
    PopCallStack();
}
[#-- // DBG < BuildCodeNonTerminal ${indent} ${nonterminal.production.name} --]
[/#macro]


[#macro BuildCodeZeroOrOne zoo indent]
[#var is = ""?right_pad(indent)]
[#-- // DBG > BuildCodeZeroOrOne ${indent} ${zoo.nestedExpansion.class.simpleName} --]
    [#if zoo.nestedExpansion.class.simpleName = "ExpansionChoice"]
${BuildCode(zoo.nestedExpansion, indent)}
    [#else]
if (${ExpansionCondition(zoo.nestedExpansion)}) {
${BuildCode(zoo.nestedExpansion, indent + 4)}
}
    [/#if]
[#-- // DBG < BuildCodeZeroOrOne ${indent} ${zoo.nestedExpansion.class.simpleName} --]
[/#macro]

[#var inFirstVarName = "", inFirstIndex =0]

[#macro BuildCodeOneOrMore oom indent]
[#var is = ""?right_pad(indent)]
[#-- // DBG > BuildCodeOneOrMore ${indent} --]
[#var nestedExp=oom.nestedExpansion, prevInFirstVarName = inFirstVarName/]
   [#if nestedExp.simpleName = "ExpansionChoice"]
     [#set inFirstVarName = "inFirst" + inFirstIndex, inFirstIndex = inFirstIndex +1 /]
var ${inFirstVarName} = true;
   [/#if]
while (true) {
${RecoveryLoop(oom, indent + 4)}
      [#if nestedExp.simpleName = "ExpansionChoice"]
    ${inFirstVarName} = false;
      [#else]
    if (!(${ExpansionCondition(oom.nestedExpansion)})) break;
      [/#if]
}
   [#set inFirstVarName = prevInFirstVarName /]
[#-- // DBG < BuildCodeOneOrMore ${indent} --]
[/#macro]

[#macro BuildCodeZeroOrMore zom indent]
[#var is = ""?right_pad(indent)]
[#-- // DBG > BuildCodeZeroOrMore ${indent} --]
while (true) {
       [#if zom.nestedExpansion.class.simpleName != "ExpansionChoice"]
    if (!(${ExpansionCondition(zom.nestedExpansion)})) break;
       [/#if]
       [@RecoveryLoop zom indent + 4 /]
}
[#-- // DBG < BuildCodeZeroOrMore ${indent} --]
[/#macro]

[#macro RecoveryLoop loopExpansion indent]
[#var is = ""?right_pad(indent)]
[#-- // DBG > RecoveryLoop ${indent} --]
[#if !settings.faultTolerant || !loopExpansion.requiresRecoverMethod]
${BuildCode(loopExpansion.nestedExpansion, indent)}
[#else]
[#var initialTokenVarName = "initialToken" + CU.newID()]
${initialTokenVarName} = LastConsumedToken;
try {
${BuildCode(loopExpansion.nestedExpansion, indent + 4)}
}
catch (ParseException pe) {
    if (!IsTolerant) throw;
    if (debugFaultTolerant) {
        // logger.info('Handling exception. Last consumed token: %s at: %s', lastConsumedToken.image, lastConsumedToken.location)
    }
    if (${initialTokenVarName} == LastConsumedToken) {
        LastConsumedToken = NextToken(LastConsumedToken);
        // We have to skip a token in this spot or
        // we'll be stuck in an infinite loop!
        LastConsumedToken.skipped = true;
        if (debugFaultTolerant) {
            // logger.info('Skipping token %s at: %s', lastConsumedToken.image, lastConsumedToken.location)
        }
    }
    if (debugFaultTolerant) {
        // logger.info('Repeat re-sync for expansion at: ${loopExpansion.location?j_string}');
    }
    ${loopExpansion.recoverMethodName}();
    if (pendingRecovery) throw;
   [/#if]
[#-- // DBG < RecoveryLoop ${indent} --]
[/#macro]

[#macro BuildCodeChoice choice indent]
[#var is = ""?right_pad(indent)]
[#-- // DBG > BuildCodeChoice ${indent} --]
   [#list choice.choices as expansion]
${(expansion_index=0)?string("if", "else if")} (${ExpansionCondition(expansion)}) {
${BuildCode(expansion, indent + 4)}
}
   [/#list]
   [#if choice.parent.simpleName == "ZeroOrMore"]
else {
    break;
}
   [#elseif choice.parent.simpleName = "OneOrMore"]
else if (${inFirstVarName}) {
    PushOntoCallStack("${currentProduction.name}", "${choice.inputSource?j_string}", ${choice.beginLine}, ${choice.beginColumn});
    throw new ParseException(this, ${choice.firstSetVarName});
}
else {
    break;
}
   [#elseif choice.parent.simpleName != "ZeroOrOne"]
else {
    PushOntoCallStack("${currentProduction.name}", "${choice.inputSource?j_string}", ${choice.beginLine}, ${choice.beginColumn});
    throw new ParseException(this, ${choice.firstSetVarName});
}
   [/#if]
[#-- // DBG < BuildCodeChoice ${indent} --]
[/#macro]

[#--
     Macro to generate the condition for entering an expansion
     including the default single-token lookahead
--]
[#macro ExpansionCondition expansion]
[#if expansion.requiresPredicateMethod]${ScanAheadCondition(expansion)}[#else]${SingleTokenCondition(expansion)}[/#if]
[/#macro]


[#-- Generates code for when we need a scanahead --]
[#macro ScanAheadCondition expansion]
[#if expansion.lookahead?? && expansion.lookahead.LHS??](${expansion.lookahead.LHS} = [/#if][#if expansion.hasSemanticLookahead && !expansion.lookahead.semanticLookaheadNested](${globals.translateExpression(expansion.semanticLookahead)}) && [/#if]${expansion.predicateMethodName}()[#if expansion.lookahead?? && expansion.lookahead.LHS??])[/#if]
[/#macro]


[#-- Generates code for when we don't need any scanahead routine --]
[#macro SingleTokenCondition expansion]
   [#if expansion.hasSemanticLookahead](${globals.translateExpression(expansion.semanticLookahead)}) && [/#if]
   [#if expansion.firstSet.tokenNames?size = 0 || expansion.lookaheadAmount ==0 || expansion.minimumSize=0]true[#elseif expansion.firstSet.tokenNames?size < 5][#list expansion.firstSet.tokenNames as name](NextTokenType == TokenType.${name})[#if name_has_next] || [/#if][/#list][#else](${expansion.firstSetVarName}.Contains(NextTokenType))[/#if]
[/#macro]

[#macro BuildAssertionCode assertion indent]
[#var is = ""?right_pad(indent)]
[#var optionalPart = ""]
[#if assertion.messageExpression??]
  [#set optionalPart = " + " + globals.translateExpression(assertion.messageExpression)]
[/#if]
   [#var assertionMessage = "Assertion at: " + assertion.location?j_string + " failed. "]
   [#if assertion.assertionExpression??]
if (!(${globals.translateExpression(assertion.assertionExpression)})) {
    Fail("${assertionMessage}"${optionalPart});
}
   [/#if]
   [#if assertion.expansion??]
if ([#if !assertion.expansionNegated]![/#if]${assertion.expansion.scanRoutineName}()) {
    Fail("${assertionMessage}"${optionalPart});
}
   [/#if]
[/#macro]


[#--
   Macro to build routines that scan up to the start of an expansion
   as part of a recovery routine
--]
[#macro BuildRecoverRoutines]
   [#list grammar.expansionsNeedingRecoverMethod as expansion]
    def ${expansion.recoverMethodName}(self):
        Token initialToken = LastConsumedToken;
        IList<Token> skippedTokens = new List<Token>();
        bool success = false;

        while (LastConsumedToken.Type != TokenType.EOF) {
[#if expansion.simpleName = "OneOrMore" || expansion.simpleName = "ZeroOrMore"]
            if (${ExpansionCondition(expansion.nestedExpansion)}) {
[#else]
            if (${ExpansionCondition(expansion)}) {
[/#if]
                success = true;
                break;
            }
            [#if expansion.simpleName = "ZeroOrMore" || expansion.simpleName = "OneOrMore"]
               [#var followingExpansion = expansion.followingExpansion]
               [#list 1..1000000 as unused]
                [#if followingExpansion?is_null][#break][/#if]
                [#if followingExpansion.maximumSize >0]
                 [#if followingExpansion.simpleName = "OneOrMore" || followingExpansion.simpleName = "ZeroOrOne" || followingExpansion.simpleName = "ZeroOrMore"]
                if (${ExpansionCondition(followingExpansion.nestedExpansion)}):
                 [#else]
                if (${ExpansionCondition(followingExpansion)}):
                 [/#if]
                    success = true;
                    break;
                }
                [/#if]
                [#if !followingExpansion.possiblyEmpty][#break][/#if]
                [#if followingExpansion.followingExpansion?is_null]
                if (OuterFollowSet != null) {
                    if (OuterFollowSet.Contains(NextTokenType)) {
                        success = true;
                        break;
                    }
                }
                 [#break/]
                [/#if]
                [#set followingExpansion = followingExpansion.followingExpansion]
               [/#list]
             [/#if]
            LastConsumedToken = NextToken(LastConsumedToken);
            skippedTokens.AddLastConsumedToken);
        if (!success && skippedTokens.Count > 0) {
             LastConsumedToken = initialToken;
        }
        if (success && skippedTokens.Count > 0) {
            iv = InvalidNode(self);
            foreach (var tok in skippedTokens) {
                iv.AddChild(tok);
            }
            if (debugFaultTolerant) {
                // logger.info('Skipping %s tokens starting at: %s', len(skippedTokens), skippedTokens[0].location)
            }
            PushNode(iv);
        pendingRecovery = !success;

   [/#list]
[/#macro]
