/*
 * Decompiled with CFR 0.152.
 */
package org.parsers.csharp.ppline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.parsers.csharp.ppline.PPDirectiveLineLexer;
import org.parsers.csharp.ppline.TokenSource;

public class Token
implements CharSequence {
    private PPDirectiveLineLexer tokenSource;
    private TokenType type = TokenType.DUMMY;
    private int beginOffset;
    private int endOffset;
    private boolean unparsed;

    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public PPDirectiveLineLexer getTokenSource() {
        return this.tokenSource;
    }

    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = (PPDirectiveLineLexer)tokenSource;
    }

    public boolean isInvalid() {
        return this.getType().isInvalid();
    }

    public TokenType getType() {
        return this.type;
    }

    protected void setType(TokenType type) {
        this.type = type;
    }

    public boolean isVirtual() {
        return this.type == TokenType.EOF;
    }

    public boolean isSkipped() {
        return false;
    }

    public int getBeginLine() {
        PPDirectiveLineLexer flm = this.getTokenSource();
        return flm == null ? 0 : flm.getLineFromOffset(this.getBeginOffset());
    }

    public int getEndLine() {
        PPDirectiveLineLexer flm = this.getTokenSource();
        return flm == null ? 0 : flm.getLineFromOffset(this.getEndOffset() - 1);
    }

    public int getBeginColumn() {
        PPDirectiveLineLexer flm = this.getTokenSource();
        return flm == null ? 0 : flm.getCodePointColumnFromOffset(this.getBeginOffset());
    }

    public int getEndColumn() {
        PPDirectiveLineLexer flm = this.getTokenSource();
        return flm == null ? 0 : flm.getCodePointColumnFromOffset(this.getEndOffset());
    }

    public String getInputSource() {
        PPDirectiveLineLexer flm = this.getTokenSource();
        return flm != null ? flm.getInputSource() : "input";
    }

    public int getBeginOffset() {
        return this.beginOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public final Token getNext() {
        return this.getNextParsedToken();
    }

    public final Token getPrevious() {
        Token result;
        for (result = this.previousCachedToken(); result != null && result.isUnparsed(); result = result.previousCachedToken()) {
        }
        return result;
    }

    private Token getNextParsedToken() {
        Token result;
        for (result = this.nextCachedToken(); result != null && result.isUnparsed(); result = result.nextCachedToken()) {
        }
        return result;
    }

    public Token nextCachedToken() {
        if (this.getType() == TokenType.EOF) {
            return null;
        }
        PPDirectiveLineLexer tokenSource = this.getTokenSource();
        return tokenSource != null ? tokenSource.nextCachedToken(this.getEndOffset()) : null;
    }

    public Token previousCachedToken() {
        if (this.getTokenSource() == null) {
            return null;
        }
        return this.getTokenSource().previousCachedToken(this.getBeginOffset());
    }

    Token getPreviousToken() {
        return this.previousCachedToken();
    }

    public Token replaceType(TokenType type) {
        Token result = Token.newToken(type, this.getTokenSource(), this.getBeginOffset(), this.getEndOffset());
        this.getTokenSource().cacheToken(result);
        return result;
    }

    public String getSource() {
        if (this.type == TokenType.EOF) {
            return "";
        }
        PPDirectiveLineLexer flm = this.getTokenSource();
        return flm == null ? null : flm.getText(this.getBeginOffset(), this.getEndOffset());
    }

    protected Token() {
    }

    public Token(TokenType type, PPDirectiveLineLexer tokenSource, int beginOffset, int endOffset) {
        this.type = type;
        this.tokenSource = tokenSource;
        this.beginOffset = beginOffset;
        this.endOffset = endOffset;
    }

    public boolean isUnparsed() {
        return this.unparsed;
    }

    public void setUnparsed(boolean unparsed) {
        this.unparsed = unparsed;
    }

    public Iterator<Token> precedingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.previousCachedToken() != null;
            }

            @Override
            public Token next() {
                Token previous = this.currentPoint.previousCachedToken();
                if (previous == null) {
                    throw new NoSuchElementException("No previous token!");
                }
                this.currentPoint = previous;
                return this.currentPoint;
            }
        };
    }

    public List<Token> precedingUnparsedTokens() {
        ArrayList<Token> result = new ArrayList<Token>();
        for (Token t = this.previousCachedToken(); t != null && t.isUnparsed(); t = t.previousCachedToken()) {
            result.add(t);
        }
        Collections.reverse(result);
        return result;
    }

    public Iterator<Token> followingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.nextCachedToken() != null;
            }

            @Override
            public Token next() {
                Token next = this.currentPoint.nextCachedToken();
                if (next == null) {
                    throw new NoSuchElementException("No next token!");
                }
                this.currentPoint = next;
                return this.currentPoint;
            }
        };
    }

    public void copyLocationInfo(Token from) {
        this.setTokenSource(from.getTokenSource());
        this.setBeginOffset(from.getBeginOffset());
        this.setEndOffset(from.getEndOffset());
    }

    public void copyLocationInfo(Token start, Token end) {
        this.setTokenSource(start.getTokenSource());
        if (this.tokenSource == null) {
            this.setTokenSource(end.getTokenSource());
        }
        this.setBeginOffset(start.getBeginOffset());
        this.setEndOffset(end.getEndOffset());
    }

    public static Token newToken(TokenType type, PPDirectiveLineLexer tokenSource, int beginOffset, int endOffset) {
        return new Token(type, tokenSource, beginOffset, endOffset);
    }

    public String getLocation() {
        return this.getInputSource() + ":" + this.getBeginLine() + ":" + this.getBeginColumn();
    }

    @Override
    public int length() {
        return this.endOffset - this.beginOffset;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.getTokenSource().subSequence(this.beginOffset + start, this.beginOffset + end);
    }

    @Override
    public char charAt(int offset) {
        return this.getTokenSource().charAt(this.beginOffset + offset);
    }

    @Deprecated
    public String getImage() {
        return this.getSource();
    }

    @Override
    public String toString() {
        return this.getSource();
    }

    public static enum TokenType {
        EOF,
        TRUE,
        FALSE,
        OR,
        AND,
        LPAREN,
        RPAREN,
        NOT,
        EQUALS,
        NOT_EQUALS,
        WS,
        EOL,
        IDENTIFIER,
        IF,
        ELIF,
        DEFINE,
        UNDEF,
        ELSE,
        ENDIF,
        IGNORED_DIRECTIVE,
        UNKNOWN_DIRECTIVE,
        DUMMY,
        INVALID;


        public boolean isUndefined() {
            return this == DUMMY;
        }

        public boolean isInvalid() {
            return this == INVALID;
        }

        public boolean isEOF() {
            return this == EOF;
        }
    }
}

