/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.parser.tree;

import java.util.ArrayList;
import java.util.List;
import org.congocc.parser.Token;
import org.congocc.parser.tree.Backslash;
import org.congocc.parser.tree.BaseNode;

public class LookBehind
extends BaseNode {
    private boolean negated;
    private String routineName;

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    public boolean isBackward() {
        return this.getChild(0) instanceof Backslash || this.getChild(1) instanceof Backslash;
    }

    public boolean getHasFinalEllipsis() {
        Token t = (Token)this.getChild(this.getChildCount() - 1);
        return t.toString().equals("...");
    }

    public List<String> getPath() {
        ArrayList<String> result = new ArrayList<String>();
        boolean negated = false;
        for (Token t : this.childrenOfType(Token.class)) {
            String img = t.toString();
            if (img.charAt(0) == '\\' || img.charAt(0) == '/') {
                negated = false;
                continue;
            }
            if (img.equals("~")) {
                negated = true;
                continue;
            }
            if (negated) {
                result.add("~" + img);
            } else {
                result.add(img);
            }
            negated = false;
        }
        if (((String)result.get(0)).equals("~")) {
            result.remove(0);
        }
        return result;
    }

    public boolean getHasEndingSlash() {
        Token lastToken = (Token)this.getChild(this.getChildCount() - 1);
        String img = lastToken.toString();
        return img.equals("\\") || img.equals("/");
    }

    public String getRoutineName() {
        if (this.routineName == null) {
            String prefix = this.getAppSettings().generateIdentifierPrefix("backscan");
            this.routineName = this.getAppSettings().generateUniqueIdentifier(prefix, this);
        }
        return this.routineName;
    }
}

