/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.parser.tree;

import java.util.ArrayList;
import org.congocc.parser.Node;
import org.congocc.parser.Token;
import org.congocc.parser.tree.BaseNode;
import org.congocc.parser.tree.CharacterLiteral;
import org.congocc.parser.tree.StringLiteral;

public class CharacterRange
extends BaseNode {
    private int left;
    private int right;

    public int getRight() {
        return this.right;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public CharacterRange() {
    }

    public CharacterRange(int left, int right) {
        this.setRange(left, right);
    }

    public void setRange(int left, int right) {
        if (left > right) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.left = left;
        this.right = right;
    }

    public boolean isSingleChar() {
        return this.left == this.right;
    }

    private static boolean isSingleChar(String s) {
        if (s.length() == 1) {
            return true;
        }
        if (s.length() == 2) {
            return Character.isSurrogatePair(s.charAt(0), s.charAt(1));
        }
        return false;
    }

    @Override
    public void close() {
        String leftBound;
        ArrayList<Token> bounds = new ArrayList<Token>();
        for (Node n : this.children()) {
            if (n instanceof StringLiteral) {
                bounds.add((Token)n);
            }
            if (n instanceof CharacterLiteral) {
                bounds.add((Token)n);
            }
            if (bounds.size() <= 1) continue;
            break;
        }
        String rightBound = leftBound = StringLiteral.removeEscapesAndQuotes(((Token)bounds.get(0)).toString());
        if (bounds.size() > 1) {
            rightBound = StringLiteral.removeEscapesAndQuotes(((Token)bounds.get(1)).toString());
        }
        if (!CharacterRange.isSingleChar(leftBound)) {
            this.getErrors().addError((Node)bounds.get(0), "String in character list may contain only one character.");
        }
        this.left = this.right = leftBound.codePointAt(0);
        if (!leftBound.equals(rightBound) && !CharacterRange.isSingleChar(rightBound)) {
            this.getErrors().addError((Node)bounds.get(1), "String in character list may contain only one character.");
        }
        if (bounds.size() > 1) {
            String right = StringLiteral.removeEscapesAndQuotes(((Token)bounds.get(1)).toString());
            if (!CharacterRange.isSingleChar(right)) {
                this.getErrors().addError((Node)bounds.get(1), "String in character list may contain only one character.");
            }
            this.right = right.codePointAt(0);
        }
        if (this.left > this.right) {
            this.getErrors().addError(this, "The left side of the character range must be a lower ordinal (in Unicode) value than the right side.");
        }
    }
}

