/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.parser.python;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.congocc.core.Grammar;
import org.congocc.parser.Node;
import org.congocc.parser.TokenSource;
import org.congocc.parser.python.InvalidToken;
import org.congocc.parser.python.PythonLexer;
import org.congocc.parser.python.ast.BADNAME;
import org.congocc.parser.python.ast.Comment;
import org.congocc.parser.python.ast.DedentToken;
import org.congocc.parser.python.ast.Delimiter;
import org.congocc.parser.python.ast.IndentToken;
import org.congocc.parser.python.ast.Keyword;
import org.congocc.parser.python.ast.Name;
import org.congocc.parser.python.ast.Newline;
import org.congocc.parser.python.ast.NumericalLiteral;
import org.congocc.parser.python.ast.Operator;
import org.congocc.parser.python.ast.SPACE;
import org.congocc.parser.python.ast.StringLiteral;
import org.congocc.parser.python.ast.Whitespace;

public class PythonToken
implements CharSequence,
Node.TerminalNode {
    private Grammar grammar;
    private PythonLexer tokenSource;
    private TokenType type = TokenType.DUMMY;
    private int beginOffset;
    private int endOffset;
    private boolean unparsed;
    private Node parent;
    private String cachedImage;
    private PythonToken prependedToken;
    private PythonToken appendedToken;
    private boolean inserted;

    public List<Integer> getIndents() {
        return null;
    }

    boolean startsLine() {
        Iterator<PythonToken> toks = this.precedingTokens();
        while (toks.hasNext()) {
            PythonToken t = toks.next();
            if (t.getType() == TokenType.CONTINUE_LINE) {
                return false;
            }
            if (t.isUnparsed()) continue;
            return t.getEndLine() != this.getBeginLine();
        }
        return true;
    }

    public PythonToken getPreviousToken() {
        return this.previousCachedToken();
    }

    @Override
    public Grammar getGrammar() {
        return this.grammar;
    }

    @Override
    public void setGrammar(Grammar grammar) {
        this.grammar = grammar;
    }

    @Deprecated
    public void setImage(String image) {
        this.setCachedImage(image);
    }

    public void setCachedImage(String image) {
        this.cachedImage = image;
    }

    public String getCachedImage() {
        return this.cachedImage;
    }

    public PythonToken(TokenType type, String image, PythonLexer tokenSource) {
        this.type = type;
        this.cachedImage = image;
        this.tokenSource = tokenSource;
    }

    public static PythonToken newToken(TokenType type, String image, PythonLexer tokenSource) {
        PythonToken result = PythonToken.newToken(type, tokenSource, 0, 0);
        result.setCachedImage(image);
        return result;
    }

    public boolean isInserted() {
        return this.inserted;
    }

    public void preInsert(PythonToken prependedToken) {
        if (prependedToken == this.prependedToken) {
            return;
        }
        prependedToken.appendedToken = this;
        PythonToken existingPreviousToken = this.previousCachedToken();
        if (existingPreviousToken != null) {
            existingPreviousToken.appendedToken = prependedToken;
            prependedToken.prependedToken = existingPreviousToken;
        }
        prependedToken.inserted = true;
        prependedToken.beginOffset = prependedToken.endOffset = this.beginOffset;
        this.prependedToken = prependedToken;
    }

    void unsetAppendedToken() {
        this.appendedToken = null;
    }

    @Override
    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    @Override
    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    @Override
    public PythonLexer getTokenSource() {
        return this.tokenSource;
    }

    @Override
    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = (PythonLexer)tokenSource;
    }

    public boolean isInvalid() {
        return this.getType().isInvalid();
    }

    @Override
    public TokenType getType() {
        return this.type;
    }

    protected void setType(TokenType type) {
        this.type = type;
    }

    public boolean isVirtual() {
        return this.type == TokenType.EOF;
    }

    public boolean isSkipped() {
        return false;
    }

    @Override
    public int getBeginOffset() {
        return this.beginOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public final PythonToken getNext() {
        return this.getNextParsedToken();
    }

    public final PythonToken getPrevious() {
        PythonToken result;
        for (result = this.previousCachedToken(); result != null && result.isUnparsed(); result = result.previousCachedToken()) {
        }
        return result;
    }

    private PythonToken getNextParsedToken() {
        PythonToken result;
        for (result = this.nextCachedToken(); result != null && result.isUnparsed(); result = result.nextCachedToken()) {
        }
        return result;
    }

    public PythonToken nextCachedToken() {
        if (this.getType() == TokenType.EOF) {
            return null;
        }
        if (this.appendedToken != null) {
            return this.appendedToken;
        }
        PythonLexer tokenSource = this.getTokenSource();
        return tokenSource != null ? (PythonToken)tokenSource.nextCachedToken(this.getEndOffset()) : null;
    }

    public PythonToken previousCachedToken() {
        if (this.prependedToken != null) {
            return this.prependedToken;
        }
        if (this.getTokenSource() == null) {
            return null;
        }
        return (PythonToken)this.getTokenSource().previousCachedToken(this.getBeginOffset());
    }

    public PythonToken replaceType(TokenType type) {
        PythonToken result = PythonToken.newToken(type, this.getTokenSource(), this.getBeginOffset(), this.getEndOffset());
        result.prependedToken = this.prependedToken;
        result.appendedToken = this.appendedToken;
        result.inserted = this.inserted;
        if (result.appendedToken != null) {
            result.appendedToken.prependedToken = result;
        }
        if (result.prependedToken != null) {
            result.prependedToken.appendedToken = result;
        }
        if (!result.inserted) {
            this.getTokenSource().cacheToken(result);
        }
        return result;
    }

    @Override
    public String getSource() {
        if (this.type == TokenType.EOF) {
            return "";
        }
        PythonLexer flm = this.getTokenSource();
        return flm == null ? null : flm.getText(this.getBeginOffset(), this.getEndOffset());
    }

    protected PythonToken() {
    }

    public PythonToken(TokenType type, PythonLexer tokenSource, int beginOffset, int endOffset) {
        this.type = type;
        this.tokenSource = tokenSource;
        this.beginOffset = beginOffset;
        this.endOffset = endOffset;
    }

    @Override
    public boolean isUnparsed() {
        return this.unparsed;
    }

    @Override
    public void setUnparsed(boolean unparsed) {
        this.unparsed = unparsed;
    }

    public Iterator<PythonToken> precedingTokens() {
        return new Iterator<PythonToken>(){
            PythonToken currentPoint;
            {
                this.currentPoint = PythonToken.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.previousCachedToken() != null;
            }

            @Override
            public PythonToken next() {
                PythonToken previous = this.currentPoint.previousCachedToken();
                if (previous == null) {
                    throw new NoSuchElementException("No previous token!");
                }
                this.currentPoint = previous;
                return this.currentPoint;
            }
        };
    }

    public List<PythonToken> precedingUnparsedTokens() {
        ArrayList<PythonToken> result = new ArrayList<PythonToken>();
        for (PythonToken t = this.previousCachedToken(); t != null && t.isUnparsed(); t = t.previousCachedToken()) {
            result.add(t);
        }
        Collections.reverse(result);
        return result;
    }

    public Iterator<PythonToken> followingTokens() {
        return new Iterator<PythonToken>(){
            PythonToken currentPoint;
            {
                this.currentPoint = PythonToken.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.nextCachedToken() != null;
            }

            @Override
            public PythonToken next() {
                PythonToken next = this.currentPoint.nextCachedToken();
                if (next == null) {
                    throw new NoSuchElementException("No next token!");
                }
                this.currentPoint = next;
                return this.currentPoint;
            }
        };
    }

    @Override
    public void copyLocationInfo(Node from) {
        Node.TerminalNode.super.copyLocationInfo(from);
        if (from instanceof PythonToken) {
            PythonToken otherTok = (PythonToken)from;
            this.appendedToken = otherTok.appendedToken;
            this.prependedToken = otherTok.prependedToken;
        }
        this.setTokenSource(from.getTokenSource());
    }

    @Override
    public void copyLocationInfo(Node start, Node end) {
        Node.TerminalNode.super.copyLocationInfo(start, end);
        if (start instanceof PythonToken) {
            this.prependedToken = ((PythonToken)start).prependedToken;
        }
        if (end instanceof PythonToken) {
            PythonToken endToken = (PythonToken)end;
            this.appendedToken = endToken.appendedToken;
        }
    }

    public static PythonToken newToken(TokenType type, PythonLexer tokenSource, int beginOffset, int endOffset) {
        switch (type) {
            case HOOK: {
                return new Operator(TokenType.HOOK, tokenSource, beginOffset, endOffset);
            }
            case HEXNUMBER: {
                return new NumericalLiteral(TokenType.HEXNUMBER, tokenSource, beginOffset, endOffset);
            }
            case BADDECNUMBER: {
                return new NumericalLiteral(TokenType.BADDECNUMBER, tokenSource, beginOffset, endOffset);
            }
            case MINUS: {
                return new Operator(TokenType.MINUS, tokenSource, beginOffset, endOffset);
            }
            case STARASSIGN: {
                return new Delimiter(TokenType.STARASSIGN, tokenSource, beginOffset, endOffset);
            }
            case SEMICOLON: {
                return new Delimiter(TokenType.SEMICOLON, tokenSource, beginOffset, endOffset);
            }
            case BREAK: {
                return new Keyword(TokenType.BREAK, tokenSource, beginOffset, endOffset);
            }
            case ELSE: {
                return new Keyword(TokenType.ELSE, tokenSource, beginOffset, endOffset);
            }
            case NONE: {
                return new Keyword(TokenType.NONE, tokenSource, beginOffset, endOffset);
            }
            case BINNUMBER: {
                return new NumericalLiteral(TokenType.BINNUMBER, tokenSource, beginOffset, endOffset);
            }
            case IF: {
                return new Keyword(TokenType.IF, tokenSource, beginOffset, endOffset);
            }
            case CONTINUE_LINE: {
                return new Whitespace(TokenType.CONTINUE_LINE, tokenSource, beginOffset, endOffset);
            }
            case ELIF: {
                return new Keyword(TokenType.ELIF, tokenSource, beginOffset, endOffset);
            }
            case IN: {
                return new Keyword(TokenType.IN, tokenSource, beginOffset, endOffset);
            }
            case LPAREN: {
                return new Delimiter(TokenType.LPAREN, tokenSource, beginOffset, endOffset);
            }
            case DOT: {
                return new Operator(TokenType.DOT, tokenSource, beginOffset, endOffset);
            }
            case IS: {
                return new Keyword(TokenType.IS, tokenSource, beginOffset, endOffset);
            }
            case CASE: {
                return new Keyword(TokenType.CASE, tokenSource, beginOffset, endOffset);
            }
            case AS: {
                return new Keyword(TokenType.AS, tokenSource, beginOffset, endOffset);
            }
            case AT: {
                return new Delimiter(TokenType.AT, tokenSource, beginOffset, endOffset);
            }
            case ELLIPSIS: {
                return new Operator(TokenType.ELLIPSIS, tokenSource, beginOffset, endOffset);
            }
            case PASS: {
                return new Keyword(TokenType.PASS, tokenSource, beginOffset, endOffset);
            }
            case SLASHASSIGN: {
                return new Delimiter(TokenType.SLASHASSIGN, tokenSource, beginOffset, endOffset);
            }
            case XOR: {
                return new Operator(TokenType.XOR, tokenSource, beginOffset, endOffset);
            }
            case LBRACE: {
                return new Delimiter(TokenType.LBRACE, tokenSource, beginOffset, endOffset);
            }
            case ASSIGN: {
                return new Delimiter(TokenType.ASSIGN, tokenSource, beginOffset, endOffset);
            }
            case ORASSIGN: {
                return new Delimiter(TokenType.ORASSIGN, tokenSource, beginOffset, endOffset);
            }
            case COMMENT: {
                return new Comment(TokenType.COMMENT, tokenSource, beginOffset, endOffset);
            }
            case SPACE: {
                return new SPACE(TokenType.SPACE, tokenSource, beginOffset, endOffset);
            }
            case IMPORT: {
                return new Keyword(TokenType.IMPORT, tokenSource, beginOffset, endOffset);
            }
            case PLUSASSIGN: {
                return new Delimiter(TokenType.PLUSASSIGN, tokenSource, beginOffset, endOffset);
            }
            case COMMA: {
                return new Delimiter(TokenType.COMMA, tokenSource, beginOffset, endOffset);
            }
            case YIELD: {
                return new Keyword(TokenType.YIELD, tokenSource, beginOffset, endOffset);
            }
            case LBRACKET: {
                return new Delimiter(TokenType.LBRACKET, tokenSource, beginOffset, endOffset);
            }
            case COLONEQUALS: {
                return new Operator(TokenType.COLONEQUALS, tokenSource, beginOffset, endOffset);
            }
            case RAISE: {
                return new Keyword(TokenType.RAISE, tokenSource, beginOffset, endOffset);
            }
            case RARROW: {
                return new Operator(TokenType.RARROW, tokenSource, beginOffset, endOffset);
            }
            case CONTINUE: {
                return new Keyword(TokenType.CONTINUE, tokenSource, beginOffset, endOffset);
            }
            case STAR: {
                return new Delimiter(TokenType.STAR, tokenSource, beginOffset, endOffset);
            }
            case PERCENT: {
                return new Operator(TokenType.PERCENT, tokenSource, beginOffset, endOffset);
            }
            case _ASSERT: {
                return new Keyword(TokenType._ASSERT, tokenSource, beginOffset, endOffset);
            }
            case LE: {
                return new Operator(TokenType.LE, tokenSource, beginOffset, endOffset);
            }
            case STARSTARASSIGN: {
                return new Delimiter(TokenType.STARSTARASSIGN, tokenSource, beginOffset, endOffset);
            }
            case LT: {
                return new Operator(TokenType.LT, tokenSource, beginOffset, endOffset);
            }
            case AWAIT: {
                return new Keyword(TokenType.AWAIT, tokenSource, beginOffset, endOffset);
            }
            case PEG_PARSER: {
                return new Keyword(TokenType.PEG_PARSER, tokenSource, beginOffset, endOffset);
            }
            case CLASS: {
                return new Keyword(TokenType.CLASS, tokenSource, beginOffset, endOffset);
            }
            case FROM: {
                return new Keyword(TokenType.FROM, tokenSource, beginOffset, endOffset);
            }
            case FINALLY: {
                return new Keyword(TokenType.FINALLY, tokenSource, beginOffset, endOffset);
            }
            case XORASSIGN: {
                return new Delimiter(TokenType.XORASSIGN, tokenSource, beginOffset, endOffset);
            }
            case REMASSIGN: {
                return new Delimiter(TokenType.REMASSIGN, tokenSource, beginOffset, endOffset);
            }
            case TRY: {
                return new Keyword(TokenType.TRY, tokenSource, beginOffset, endOffset);
            }
            case MINUSASSIGN: {
                return new Delimiter(TokenType.MINUSASSIGN, tokenSource, beginOffset, endOffset);
            }
            case DECNUMBER: {
                return new NumericalLiteral(TokenType.DECNUMBER, tokenSource, beginOffset, endOffset);
            }
            case ANDASSIGN: {
                return new Delimiter(TokenType.ANDASSIGN, tokenSource, beginOffset, endOffset);
            }
            case SLASHSLASH: {
                return new Operator(TokenType.SLASHSLASH, tokenSource, beginOffset, endOffset);
            }
            case NEWLINE: {
                return new Newline(TokenType.NEWLINE, tokenSource, beginOffset, endOffset);
            }
            case FOR: {
                return new Keyword(TokenType.FOR, tokenSource, beginOffset, endOffset);
            }
            case TRUE: {
                return new Keyword(TokenType.TRUE, tokenSource, beginOffset, endOffset);
            }
            case RPAREN: {
                return new Delimiter(TokenType.RPAREN, tokenSource, beginOffset, endOffset);
            }
            case NONLOCAL: {
                return new Keyword(TokenType.NONLOCAL, tokenSource, beginOffset, endOffset);
            }
            case EQ: {
                return new Delimiter(TokenType.EQ, tokenSource, beginOffset, endOffset);
            }
            case EXCEPT: {
                return new Keyword(TokenType.EXCEPT, tokenSource, beginOffset, endOffset);
            }
            case LAMBDA: {
                return new Keyword(TokenType.LAMBDA, tokenSource, beginOffset, endOffset);
            }
            case NAME: {
                return new Name(TokenType.NAME, tokenSource, beginOffset, endOffset);
            }
            case NOT: {
                return new Keyword(TokenType.NOT, tokenSource, beginOffset, endOffset);
            }
            case RBRACE: {
                return new Delimiter(TokenType.RBRACE, tokenSource, beginOffset, endOffset);
            }
            case NE: {
                return new Operator(TokenType.NE, tokenSource, beginOffset, endOffset);
            }
            case AND: {
                return new Keyword(TokenType.AND, tokenSource, beginOffset, endOffset);
            }
            case ATASSIGN: {
                return new Delimiter(TokenType.ATASSIGN, tokenSource, beginOffset, endOffset);
            }
            case BIT_OR: {
                return new Operator(TokenType.BIT_OR, tokenSource, beginOffset, endOffset);
            }
            case PLUS: {
                return new Operator(TokenType.PLUS, tokenSource, beginOffset, endOffset);
            }
            case FLOAT: {
                return new NumericalLiteral(TokenType.FLOAT, tokenSource, beginOffset, endOffset);
            }
            case RSHIFTASSIGN: {
                return new Delimiter(TokenType.RSHIFTASSIGN, tokenSource, beginOffset, endOffset);
            }
            case STAR_STAR: {
                return new Delimiter(TokenType.STAR_STAR, tokenSource, beginOffset, endOffset);
            }
            case LSHIFTASSIGN: {
                return new Delimiter(TokenType.LSHIFTASSIGN, tokenSource, beginOffset, endOffset);
            }
            case OCTNUMBER: {
                return new NumericalLiteral(TokenType.OCTNUMBER, tokenSource, beginOffset, endOffset);
            }
            case RETURN: {
                return new Keyword(TokenType.RETURN, tokenSource, beginOffset, endOffset);
            }
            case GLOBAL: {
                return new Keyword(TokenType.GLOBAL, tokenSource, beginOffset, endOffset);
            }
            case BADNAME: {
                return new BADNAME(TokenType.BADNAME, tokenSource, beginOffset, endOffset);
            }
            case BIT_AND: {
                return new Operator(TokenType.BIT_AND, tokenSource, beginOffset, endOffset);
            }
            case GE: {
                return new Operator(TokenType.GE, tokenSource, beginOffset, endOffset);
            }
            case COMPLEX: {
                return new NumericalLiteral(TokenType.COMPLEX, tokenSource, beginOffset, endOffset);
            }
            case OR: {
                return new Keyword(TokenType.OR, tokenSource, beginOffset, endOffset);
            }
            case DEF: {
                return new Keyword(TokenType.DEF, tokenSource, beginOffset, endOffset);
            }
            case SLASHSLASHASSIGN: {
                return new Delimiter(TokenType.SLASHSLASHASSIGN, tokenSource, beginOffset, endOffset);
            }
            case ASYNC: {
                return new Keyword(TokenType.ASYNC, tokenSource, beginOffset, endOffset);
            }
            case SLASH: {
                return new Operator(TokenType.SLASH, tokenSource, beginOffset, endOffset);
            }
            case COLON: {
                return new Delimiter(TokenType.COLON, tokenSource, beginOffset, endOffset);
            }
            case RBRACKET: {
                return new Delimiter(TokenType.RBRACKET, tokenSource, beginOffset, endOffset);
            }
            case DEL: {
                return new Keyword(TokenType.DEL, tokenSource, beginOffset, endOffset);
            }
            case GT: {
                return new Operator(TokenType.GT, tokenSource, beginOffset, endOffset);
            }
            case WITH: {
                return new Keyword(TokenType.WITH, tokenSource, beginOffset, endOffset);
            }
            case RSHIFT: {
                return new Operator(TokenType.RSHIFT, tokenSource, beginOffset, endOffset);
            }
            case LSHIFT: {
                return new Operator(TokenType.LSHIFT, tokenSource, beginOffset, endOffset);
            }
            case TILDE: {
                return new Operator(TokenType.TILDE, tokenSource, beginOffset, endOffset);
            }
            case FALSE: {
                return new Keyword(TokenType.FALSE, tokenSource, beginOffset, endOffset);
            }
            case WHILE: {
                return new Keyword(TokenType.WHILE, tokenSource, beginOffset, endOffset);
            }
            case STRING_LITERAL: {
                return new StringLiteral(TokenType.STRING_LITERAL, tokenSource, beginOffset, endOffset);
            }
            case MATCH: {
                return new Keyword(TokenType.MATCH, tokenSource, beginOffset, endOffset);
            }
            case INDENT: {
                return new IndentToken(TokenType.INDENT, tokenSource, beginOffset, endOffset);
            }
            case DEDENT: {
                return new DedentToken(TokenType.DEDENT, tokenSource, beginOffset, endOffset);
            }
            case INVALID: {
                return new InvalidToken(tokenSource, beginOffset, endOffset);
            }
        }
        return new PythonToken(type, tokenSource, beginOffset, endOffset);
    }

    @Override
    public String getLocation() {
        return this.getInputSource() + ":" + this.getBeginLine() + ":" + this.getBeginColumn();
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Node parent) {
        this.parent = parent;
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public int length() {
        if (this.cachedImage != null) {
            return this.cachedImage.length();
        }
        this.cachedImage = this.toString();
        return this.cachedImage.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (this.cachedImage != null) {
            return this.cachedImage.substring(start, end);
        }
        return this.getTokenSource().subSequence(this.beginOffset + start, this.beginOffset + end);
    }

    @Override
    public char charAt(int offset) {
        if (this.cachedImage != null) {
            return this.cachedImage.charAt(offset);
        }
        this.cachedImage = this.toString();
        return this.cachedImage.charAt(offset);
    }

    @Override
    @Deprecated
    public String getImage() {
        if (this.cachedImage != null) {
            return this.cachedImage;
        }
        return this.getSource();
    }

    @Override
    public String toString() {
        if (this.cachedImage != null) {
            return this.cachedImage;
        }
        return this.getSource();
    }

    public static enum TokenType implements Node.NodeType
    {
        EOF,
        CONTINUE_LINE,
        ASSIGN,
        AT,
        COLON,
        COMMA,
        EQ,
        LBRACE,
        RBRACE,
        LBRACKET,
        RBRACKET,
        LPAREN,
        RPAREN,
        SEMICOLON,
        STAR,
        STAR_STAR,
        MINUSASSIGN,
        PLUSASSIGN,
        STARASSIGN,
        ATASSIGN,
        SLASHASSIGN,
        REMASSIGN,
        ANDASSIGN,
        ORASSIGN,
        XORASSIGN,
        LSHIFTASSIGN,
        RSHIFTASSIGN,
        STARSTARASSIGN,
        SLASHSLASHASSIGN,
        BIT_AND,
        BIT_OR,
        XOR,
        TILDE,
        COLONEQUALS,
        DOT,
        ELLIPSIS,
        LE,
        GE,
        NE,
        GT,
        LT,
        MINUS,
        PLUS,
        SLASH,
        SLASHSLASH,
        PERCENT,
        LSHIFT,
        RSHIFT,
        HOOK,
        RARROW,
        AND,
        AS,
        _ASSERT,
        ASYNC,
        AWAIT,
        BREAK,
        CASE,
        CLASS,
        CONTINUE,
        DEF,
        DEL,
        EXCEPT,
        FINALLY,
        FOR,
        FROM,
        GLOBAL,
        IF,
        IN,
        IS,
        ELIF,
        ELSE,
        FALSE,
        IMPORT,
        LAMBDA,
        MATCH,
        NONLOCAL,
        NONE,
        NOT,
        OR,
        PASS,
        PEG_PARSER,
        RAISE,
        RETURN,
        TRUE,
        TRY,
        WHILE,
        WITH,
        YIELD,
        SPACE,
        COMMENT,
        NEWLINE,
        DECNUMBER,
        BADDECNUMBER,
        HEXNUMBER,
        OCTNUMBER,
        BINNUMBER,
        FLOAT,
        COMPLEX,
        STRING_LITERAL,
        NAME,
        BADNAME,
        INDENT,
        DEDENT,
        DUMMY,
        INVALID;


        @Override
        public boolean isUndefined() {
            return this == DUMMY;
        }

        @Override
        public boolean isInvalid() {
            return this == INVALID;
        }

        @Override
        public boolean isEOF() {
            return this == EOF;
        }
    }
}

