/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.core.nfa;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.congocc.core.RegularExpression;
import org.congocc.core.nfa.CompositeStateSet;
import org.congocc.core.nfa.LexicalStateData;

public class NfaState {
    final LexicalStateData lexicalState;
    private RegularExpression type;
    private NfaState nextState;
    private Set<NfaState> epsilonMoves = new HashSet<NfaState>();
    private String movesArrayName;
    private boolean isFinal;
    private List<Integer> moveRanges = new ArrayList<Integer>();

    NfaState(LexicalStateData lexicalState, RegularExpression type) {
        this.lexicalState = lexicalState;
        this.type = type;
        lexicalState.addState(this);
    }

    void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public String getMethodName() {
        return this.getComposite().getMethodName();
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    void setMovesArrayName(int index) {
        String lexicalStateName = this.lexicalState.getName();
        this.movesArrayName = lexicalStateName.equals("DEFAULT") ? "NFA_MOVES_" + index : "NFA_MOVES_" + lexicalStateName + "_" + index;
    }

    public String getMovesArrayName() {
        return this.movesArrayName;
    }

    public List<Integer> getMoveRanges() {
        return this.moveRanges;
    }

    public List<Integer> getAsciiMoveRanges() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < this.moveRanges.size(); i += 2) {
            int left = this.moveRanges.get(i);
            int right = this.moveRanges.get(i + 1);
            if (left >= 128) break;
            result.add(left);
            result.add(right);
            if (right >= 128) break;
        }
        return result;
    }

    public List<Integer> getNonAsciiMoveRanges() {
        return this.moveRanges.subList(this.getAsciiMoveRanges().size(), this.moveRanges.size());
    }

    public boolean getHasAsciiMoves() {
        return this.moveRanges.get(0) < 128;
    }

    public boolean getHasNonAsciiMoves() {
        return this.moveRanges.get(this.moveRanges.size() - 1) >= 128;
    }

    public RegularExpression getType() {
        return this.type;
    }

    public LexicalStateData getLexicalState() {
        return this.lexicalState;
    }

    public NfaState getNextState() {
        return this.nextState;
    }

    public int getNextStateIndex() {
        return this.nextState.getComposite().getIndex();
    }

    void setNextState(NfaState nextState) {
        assert (nextState != this);
        this.nextState = nextState;
    }

    public CompositeStateSet getComposite() {
        return this.lexicalState.getCanonicalComposite(this.epsilonMoves);
    }

    boolean isMoveCodeNeeded() {
        if (this.nextState == null) {
            return false;
        }
        return this.nextState.isFinal() || !this.nextState.epsilonMoves.isEmpty();
    }

    void setType(RegularExpression type) {
        this.type = type;
    }

    void addEpsilonMove(NfaState newState) {
        this.epsilonMoves.add(newState);
    }

    void addRange(int left, int right) {
        this.moveRanges.add(left);
        this.moveRanges.add(right);
    }

    void setCharMove(int c, boolean ignoreCase) {
        this.moveRanges.clear();
        if (!ignoreCase) {
            this.addRange(c, c);
        } else {
            int upper = Character.toUpperCase(c);
            int lower = Character.toLowerCase(c);
            this.addRange(upper, upper);
            if (upper != lower) {
                this.addRange(lower, lower);
            }
            if (c != upper && c != lower) {
                this.addRange(c, c);
            }
            if (this.moveRanges.size() > 2) {
                Collections.sort(this.moveRanges);
            }
        }
    }

    void doEpsilonClosure(Set<NfaState> alreadyVisited) {
        if (alreadyVisited.contains(this)) {
            return;
        }
        alreadyVisited.add(this);
        for (NfaState state2 : new ArrayList<NfaState>(this.epsilonMoves)) {
            state2.doEpsilonClosure(alreadyVisited);
            if (this.isFinal) {
                state2.isFinal = true;
            }
            if (state2.isFinal) {
                this.isFinal = true;
            }
            for (NfaState otherState : state2.epsilonMoves) {
                this.addEpsilonMove(otherState);
                otherState.doEpsilonClosure(alreadyVisited);
            }
        }
        this.addEpsilonMove(this);
        this.epsilonMoves.removeIf(state -> state.moveRanges.isEmpty());
    }

    public boolean overlaps(Collection<NfaState> states) {
        return states.stream().anyMatch(state -> this.overlaps((NfaState)state));
    }

    private boolean overlaps(NfaState other) {
        return this == other || NfaState.intersect(this.moveRanges, other.moveRanges);
    }

    private static BitSet moveRangesToBS(List<Integer> ranges) {
        BitSet result = new BitSet();
        for (int i = 0; i < ranges.size(); i += 2) {
            int left = ranges.get(i);
            int right = ranges.get(i + 1);
            result.set(left, right + 1);
        }
        return result;
    }

    private static boolean intersect(List<Integer> moves1, List<Integer> moves2) {
        BitSet bs1 = NfaState.moveRangesToBS(moves1);
        BitSet bs2 = NfaState.moveRangesToBS(moves2);
        return bs1.intersects(bs2);
    }
}

