/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.core.nfa;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.congocc.core.Grammar;
import org.congocc.core.RegularExpression;
import org.congocc.core.nfa.LexicalStateData;
import org.congocc.core.nfa.NfaState;
import org.congocc.parser.Node;
import org.congocc.parser.tree.CharacterList;
import org.congocc.parser.tree.CharacterRange;
import org.congocc.parser.tree.OneOrMoreRegexp;
import org.congocc.parser.tree.RegexpChoice;
import org.congocc.parser.tree.RegexpRef;
import org.congocc.parser.tree.RegexpSequence;
import org.congocc.parser.tree.RegexpStringLiteral;
import org.congocc.parser.tree.RepetitionRange;
import org.congocc.parser.tree.ZeroOrMoreRegexp;
import org.congocc.parser.tree.ZeroOrOneRegexp;

class NfaBuilder
extends Node.Visitor {
    private NfaState start;
    private NfaState end;
    private boolean ignoreCase;
    private LexicalStateData lexicalState;
    final Grammar grammar;
    private RegularExpression type;
    private static BitSet lowerCaseDiffSet = NfaBuilder.caseDiffSetInit(false);
    private static BitSet upperCaseDiffSet = NfaBuilder.caseDiffSetInit(true);

    NfaBuilder(LexicalStateData lexicalState, RegularExpression type, boolean ignoreCase) {
        this.lexicalState = lexicalState;
        this.type = type;
        this.grammar = lexicalState.grammar;
        this.ignoreCase = ignoreCase;
    }

    void buildStates() {
        this.visit(this.type);
        this.end.setFinal(true);
        this.lexicalState.getInitialState().addEpsilonMove(this.start);
    }

    void visit(CharacterList charList) {
        List<CharacterRange> ranges = NfaBuilder.orderedRanges(charList, this.ignoreCase);
        this.start = new NfaState(this.lexicalState, this.type);
        this.end = new NfaState(this.lexicalState, this.type);
        for (CharacterRange cr : ranges) {
            this.start.addRange(cr.getLeft(), cr.getRight());
        }
        this.start.setNextState(this.end);
    }

    void visit(ZeroOrMoreRegexp zom) {
        NfaState startState = new NfaState(this.lexicalState, this.type);
        NfaState finalState = new NfaState(this.lexicalState, this.type);
        this.visit(zom.getRegexp());
        startState.addEpsilonMove(this.start);
        startState.addEpsilonMove(finalState);
        this.end.addEpsilonMove(finalState);
        this.end.addEpsilonMove(this.start);
        this.start = startState;
        this.end = finalState;
    }

    void visit(OneOrMoreRegexp oom) {
        NfaState startState = new NfaState(this.lexicalState, this.type);
        NfaState finalState = new NfaState(this.lexicalState, this.type);
        this.visit(oom.getRegexp());
        startState.addEpsilonMove(this.start);
        this.end.addEpsilonMove(this.start);
        this.end.addEpsilonMove(finalState);
        this.start = startState;
        this.end = finalState;
    }

    void visit(RegexpChoice choice) {
        List<RegularExpression> choices = choice.getChoices();
        if (choices.size() == 1) {
            this.visit(choices.get(0));
            return;
        }
        NfaState startState = new NfaState(this.lexicalState, this.type);
        NfaState finalState = new NfaState(this.lexicalState, this.type);
        for (RegularExpression curRE : choices) {
            this.visit(curRE);
            startState.addEpsilonMove(this.start);
            this.end.addEpsilonMove(finalState);
        }
        this.start = startState;
        this.end = finalState;
    }

    void visit(RegexpStringLiteral stringLiteral) {
        this.end = this.start = new NfaState(this.lexicalState, this.type);
        NfaState state = this.start;
        for (int ch : stringLiteral.getLiteralString().codePoints().toArray()) {
            state.setCharMove(ch, this.ignoreCase || this.grammar.getAppSettings().isIgnoreCase());
            this.end = new NfaState(this.lexicalState, this.type);
            state.setNextState(this.end);
            state = this.end;
        }
    }

    void visit(ZeroOrOneRegexp zoo) {
        NfaState startState = new NfaState(this.lexicalState, this.type);
        NfaState finalState = new NfaState(this.lexicalState, this.type);
        this.visit(zoo.getRegexp());
        startState.addEpsilonMove(this.start);
        startState.addEpsilonMove(finalState);
        this.end.addEpsilonMove(finalState);
        this.start = startState;
        this.end = finalState;
    }

    void visit(RegexpRef ref) {
        this.visit(ref.getRegexp());
    }

    void visit(RegexpSequence sequence) {
        if (sequence.getUnits().size() == 1) {
            this.visit(sequence.getUnits().get(0));
            return;
        }
        NfaState startState = new NfaState(this.lexicalState, this.type);
        NfaState finalState = new NfaState(this.lexicalState, this.type);
        NfaState prevStartState = null;
        NfaState prevEndState = null;
        for (RegularExpression re : sequence.getUnits()) {
            this.visit(re);
            if (prevStartState == null) {
                startState.addEpsilonMove(this.start);
            } else {
                prevEndState.addEpsilonMove(this.start);
            }
            prevStartState = this.start;
            prevEndState = this.end;
        }
        this.end.addEpsilonMove(finalState);
        this.start = startState;
        this.end = finalState;
    }

    void visit(RepetitionRange repRange) {
        int i;
        RegexpSequence seq = new RegexpSequence();
        for (i = 0; i < repRange.getMin(); ++i) {
            seq.add(repRange.getRegexp());
        }
        if (repRange.hasMax() && repRange.getMax() == -1) {
            ZeroOrMoreRegexp zom = new ZeroOrMoreRegexp();
            zom.setGrammar(this.grammar);
            zom.setRegexp(repRange.getRegexp());
            seq.add(zom);
        } else {
            for (i = repRange.getMin(); i < repRange.getMax(); ++i) {
                ZeroOrOneRegexp zoo = new ZeroOrOneRegexp();
                zoo.setGrammar(this.grammar);
                zoo.setRegexp(repRange.getRegexp());
                seq.add(zoo);
            }
        }
        this.visit(seq);
    }

    private static List<CharacterRange> orderedRanges(CharacterList charList, boolean caseNeutral) {
        BitSet bs = NfaBuilder.rangeListToBS(charList.getDescriptors());
        if (caseNeutral) {
            BitSet upperCaseDiffPoints = (BitSet)bs.clone();
            BitSet lowerCaseDiffPoints = (BitSet)bs.clone();
            upperCaseDiffPoints.and(upperCaseDiffSet);
            lowerCaseDiffPoints.and(lowerCaseDiffSet);
            upperCaseDiffPoints.stream().forEach(ch -> bs.set(Character.toUpperCase(ch)));
            lowerCaseDiffPoints.stream().forEach(ch -> bs.set(Character.toLowerCase(ch)));
        }
        if (charList.isNegated()) {
            bs.flip(0, 0x110000);
        }
        return NfaBuilder.bsToRangeList(bs);
    }

    private static BitSet caseDiffSetInit(boolean upper) {
        BitSet result = new BitSet();
        for (int ch = 0; ch <= 93823; ++ch) {
            int converted;
            int n = converted = upper ? Character.toUpperCase(ch) : Character.toLowerCase(ch);
            if (converted == ch) continue;
            result.set(ch);
        }
        return result;
    }

    private static BitSet rangeListToBS(List<CharacterRange> ranges) {
        BitSet result = new BitSet();
        for (CharacterRange range : ranges) {
            result.set(range.getLeft(), range.getRight() + 1);
        }
        return result;
    }

    private static List<CharacterRange> bsToRangeList(BitSet bs) {
        ArrayList<CharacterRange> result = new ArrayList<CharacterRange>();
        if (bs.isEmpty()) {
            return result;
        }
        int curPos = 0;
        while (curPos >= 0) {
            int left = bs.nextSetBit(curPos);
            int right = bs.nextClearBit(left) - 1;
            result.add(new CharacterRange(left, right));
            curPos = bs.nextSetBit(right + 1);
        }
        return result;
    }
}

