/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.core.ast.ASTVisitor;
import freemarker.core.ast.AssignmentInstruction;
import freemarker.core.ast.Comment;
import freemarker.core.ast.LibraryLoad;
import freemarker.core.ast.Macro;
import freemarker.core.ast.MixedContent;
import freemarker.core.ast.PropertySetting;
import freemarker.core.ast.TemplateElement;
import freemarker.core.ast.TextBlock;
import freemarker.core.ast.VarDirective;
import freemarker.template.PostParseVisitor;
import freemarker.template.Template;
import java.util.ArrayList;

public class WhitespaceAdjuster
extends ASTVisitor {
    private Template template;

    public WhitespaceAdjuster(Template template) {
        this.template = template;
    }

    boolean ignoresSandwichedWhitespace(TemplateElement elem) {
        return elem instanceof Macro || elem instanceof AssignmentInstruction || elem instanceof VarDirective || elem instanceof LibraryLoad || elem instanceof PropertySetting || elem instanceof Comment;
    }

    @Override
    public void visit(MixedContent node) {
        boolean atTopLevel = node.getParent() == null;
        super.visit(node);
        ArrayList<TemplateElement> childElements = new ArrayList<TemplateElement>();
        TemplateElement prev = null;
        for (TemplateElement elem : node.getNestedElements()) {
            if (elem.isIgnorable()) continue;
            childElements.add(elem);
        }
        for (int i = 0; i < childElements.size(); ++i) {
            TextBlock text;
            TemplateElement next;
            TemplateElement elem;
            elem = (TemplateElement)childElements.get(i);
            TemplateElement previous = i == 0 ? null : (TemplateElement)childElements.get(i - 1);
            TemplateElement templateElement = next = i == childElements.size() - 1 ? null : (TemplateElement)childElements.get(i + 1);
            if (!(elem instanceof TextBlock) || !(text = (TextBlock)elem).isWhitespace()) continue;
            if (this.ignoresSandwichedWhitespace(previous) && this.ignoresSandwichedWhitespace(next)) {
                text.setIgnore(true);
            }
            if (previous == null && atTopLevel && (node.getBeginColumn() != 1 || this.ignoresSandwichedWhitespace(next))) {
                text.setIgnore(true);
            }
            if (next != null || !atTopLevel || !this.ignoresSandwichedWhitespace(prev)) continue;
            text.setIgnore(true);
        }
    }

    @Override
    public void visit(TextBlock node) {
        boolean ignorable;
        int nodeType = node.getType();
        if (nodeType != 2 && nodeType != 3) {
            return;
        }
        int lineNumber = node.getBeginLine();
        if (this.template.lineSaysNoTrim(lineNumber)) {
            return;
        }
        boolean inMacro = PostParseVisitor.getContainingMacro(node) != null;
        boolean bl = ignorable = this.template.stripWhitespace && !this.template.isOutputtingLine(lineNumber, inMacro);
        if (nodeType == 2) {
            boolean deliberateLeftTrim = this.template.lineSaysLeftTrim(lineNumber);
            if (ignorable || deliberateLeftTrim) {
                node.setIgnore(true);
            }
        }
        if (nodeType == 3) {
            boolean deliberateRightTrim = this.template.lineSaysRightTrim(lineNumber);
            if (ignorable || deliberateRightTrim) {
                node.setIgnore(true);
            }
        }
    }
}

