/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.WrappingTemplateModel;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SimpleHash
extends WrappingTemplateModel
implements TemplateHashModelEx,
Serializable {
    private static final long serialVersionUID = -5942587725941500249L;
    private Map map;
    private boolean putFailed;
    private Map unwrappedMap;

    public SimpleHash() {
        this((ObjectWrapper)null);
    }

    public SimpleHash(Map map) {
        this(map, null);
    }

    public SimpleHash(ObjectWrapper wrapper) {
        super(wrapper);
        this.map = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleHash(Map map, ObjectWrapper wrapper) {
        super(wrapper);
        try {
            this.map = this.copyMap(map);
        }
        catch (ConcurrentModificationException cme) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Map map2 = map;
            synchronized (map2) {
                this.map = this.copyMap(map);
            }
        }
    }

    protected Map copyMap(Map map) {
        if (map instanceof HashMap) {
            return (Map)((HashMap)map).clone();
        }
        if (map instanceof SortedMap) {
            if (map instanceof TreeMap) {
                return (Map)((TreeMap)map).clone();
            }
            return new TreeMap((SortedMap)map);
        }
        return new LinkedHashMap(map);
    }

    public void put(String key, Object obj) {
        if (obj == null) {
            obj = JAVA_NULL;
        }
        this.map.put(key, obj);
        this.unwrappedMap = null;
    }

    public void put(String key, boolean b) {
        this.put(key, b ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TemplateModel get(String key) {
        Object putKey;
        Object result;
        block8: {
            result = this.map.get(key);
            if (result == null) {
                if (key.length() == 1) {
                    Character charKey = Character.valueOf(key.charAt(0));
                    result = this.map.get(charKey);
                    if (result == null) {
                        if (!this.map.containsKey(key) && !this.map.containsKey(charKey)) {
                            return null;
                        }
                        TemplateModel templateModel = JAVA_NULL;
                        return templateModel;
                    }
                    putKey = charKey;
                    break block8;
                } else {
                    if (!this.map.containsKey(key)) return null;
                    TemplateModel templateModel = JAVA_NULL;
                    return templateModel;
                }
            }
            putKey = key;
        }
        if (result instanceof TemplateModel) {
            return (TemplateModel)result;
        }
        TemplateModel tm = this.wrap(result);
        if (this.putFailed) return tm;
        try {
            if (tm == null) return tm;
            this.map.put(putKey, tm);
            return tm;
        }
        catch (Exception e) {
            this.putFailed = true;
        }
        return tm;
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public void putAll(Map m) {
        for (Map.Entry entry : m.entrySet()) {
            this.put((String)entry.getKey(), entry.getValue());
        }
    }

    public Map toMap() {
        if (this.unwrappedMap == null) {
            Class<?> mapClass = this.map.getClass();
            Map m = null;
            try {
                m = (Map)mapClass.newInstance();
            }
            catch (Exception e) {
                throw new TemplateModelException("Error instantiating map of type " + mapClass.getName() + "\n" + e.getMessage());
            }
            BeansWrapper bw = BeansWrapper.getDefaultInstance();
            for (Map.Entry entry : this.map.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof TemplateModel) {
                    value = bw.unwrap((TemplateModel)value);
                }
                m.put(key, value);
            }
            this.unwrappedMap = m;
        }
        return this.unwrappedMap;
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    @Override
    public TemplateCollectionModel keys() {
        return new SimpleCollection(this.map.keySet(), this.getObjectWrapper());
    }

    @Override
    public TemplateCollectionModel values() {
        return new SimpleCollection(this.map.values(), this.getObjectWrapper());
    }

    public SimpleHash synchronizedWrapper() {
        return new SynchronizedHash();
    }

    private class SynchronizedHash
    extends SimpleHash {
        private static final long serialVersionUID = -5266601722334529216L;

        private SynchronizedHash() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                return SimpleHash.this.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(String key, Object obj) {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                SimpleHash.this.put(key, obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TemplateModel get(String key) {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                return SimpleHash.this.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(String key) {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                SimpleHash.this.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                return SimpleHash.this.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TemplateCollectionModel keys() {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                return SimpleHash.this.keys();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TemplateCollectionModel values() {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                return SimpleHash.this.values();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map toMap() {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                return SimpleHash.this.toMap();
            }
        }
    }
}

