/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.parser;

import freemarker.core.parser.Token;
import freemarker.template.Template;
import java.util.Locale;

public class TemplateLocation {
    protected int beginLine;
    protected int beginColumn;
    protected int endLine;
    protected int endColumn;
    protected Template template;
    public static int TAB_SIZE = 8;

    public final String getDescription(Locale locale) {
        return "";
    }

    public String getDescription() {
        return "";
    }

    public int getBeginColumnTabAdjusted() {
        return this.template == null ? this.beginColumn : this.template.getTabAdjustedColumn(this.beginLine, this.beginColumn, TAB_SIZE);
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int getEndColumnTabAdjusted() {
        return this.template == null ? this.endColumn : this.template.getTabAdjustedColumn(this.beginLine, this.endColumn, TAB_SIZE);
    }

    public String getSource() {
        return this.template.getSource(this.beginColumn, this.beginLine, this.endColumn, this.endLine);
    }

    public String toString(Locale locale) {
        return this.toString();
    }

    public String toString() {
        String templateName = this.template == null ? "input" : this.template.getName();
        return "on line " + this.getBeginLine() + ", column " + this.beginColumn + " in " + templateName;
    }

    public String getStartLocation() {
        String templateName = this.template != null ? this.template.getName() : "input";
        return "on line " + this.beginLine + ", column " + this.getBeginColumn() + " in " + templateName;
    }

    public String getEndLocation() {
        String templateName = this.template != null ? this.template.getName() : "input";
        return "on line " + this.endLine + ", column " + this.getEndColumn() + " in " + templateName;
    }

    public boolean contains(int column, int line) {
        if (line < this.beginLine || line > this.endLine) {
            return false;
        }
        if (line == this.beginLine && column < this.beginColumn) {
            return false;
        }
        return line != this.endLine || column <= this.endColumn;
    }

    public Template getTemplate() {
        return this.template;
    }

    public TemplateLocation copyLocationFrom(TemplateLocation from) {
        this.template = from.template;
        this.beginColumn = from.beginColumn;
        this.beginLine = from.beginLine;
        this.endColumn = from.endColumn;
        this.endLine = from.endLine;
        return this;
    }

    public final void setLocation(Template template, Token begin, Token end) {
        this.setLocation(template, begin.getBeginColumn(), begin.getBeginLine(), end.getEndColumn(), end.getEndLine());
    }

    public final void setLocation(Template template, Token begin, TemplateLocation end) {
        this.setLocation(template, begin.getBeginColumn(), begin.getBeginLine(), end.getEndColumn(), end.getEndLine());
    }

    public final void setLocation(Template template, TemplateLocation begin, Token end) {
        this.setLocation(template, begin.getBeginColumn(), begin.getBeginLine(), end.getEndColumn(), end.getEndLine());
    }

    public final void setLocation(Template template, TemplateLocation begin, TemplateLocation end) {
        this.setLocation(template, begin.getBeginColumn(), begin.getBeginLine(), end.getEndColumn(), end.getEndLine());
    }

    public void setLocation(Template template, int beginColumn, int beginLine, int endColumn, int endLine) {
        this.template = template;
        this.beginColumn = beginColumn;
        this.beginLine = beginLine;
        this.endColumn = endColumn;
        this.endLine = endLine;
    }
}

