/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.builtins;

import freemarker.core.Environment;
import freemarker.core.InvalidReferenceException;
import freemarker.core.ast.BuiltInExpression;
import freemarker.core.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.util.List;

public class newBI
extends ExpressionEvaluatingBuiltIn {
    static final Class<TemplateModel> TM_CLASS = TemplateModel.class;
    static final Class<BeanModel> BEAN_MODEL_CLASS = BeanModel.class;

    @Override
    public boolean isSideEffectFree() {
        return false;
    }

    @Override
    public TemplateModel get(Environment env, BuiltInExpression caller, TemplateModel model) {
        try {
            String classString = ((TemplateScalarModel)model).getAsString();
            return new ConstructorFunction(classString, env);
        }
        catch (ClassCastException cce) {
            throw new TemplateModelException("Expecting string on left of ?new built-in");
        }
        catch (NullPointerException npe) {
            throw new InvalidReferenceException("undefined string on left of ?new built-in", env);
        }
    }

    static class ConstructorFunction
    implements TemplateMethodModelEx {
        private final Class<?> cl;
        private final Environment env;

        public ConstructorFunction(String classname, Environment env) {
            this.env = env;
            try {
                this.cl = Class.forName(classname);
                if (!TM_CLASS.isAssignableFrom(this.cl)) {
                    throw new TemplateException("Class " + this.cl.getName() + " does not implement freemarker.template.TemplateModel", env);
                }
                if (BEAN_MODEL_CLASS.isAssignableFrom(this.cl)) {
                    throw new TemplateException("Bean Models cannot be instantiated using the ?new built-in", env);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new TemplateException(cnfe, env);
            }
        }

        @Override
        public Object exec(List arguments) {
            ObjectWrapper ow = null;
            if (this.env != null) {
                ow = this.env.getObjectWrapper();
            }
            BeansWrapper bw = ow instanceof BeansWrapper ? (BeansWrapper)ow : BeansWrapper.getDefaultInstance();
            return bw.newInstance(this.cl, arguments);
        }
    }
}

