/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.Expression;
import freemarker.core.ast.TemplateElement;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateTransformModel;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TransformBlock
extends TemplateElement {
    private Expression transformExpression;
    Map<String, Expression> namedArgs;

    public TransformBlock(Expression transformExpression, Map<String, Expression> namedArgs, TemplateElement nestedBlock) {
        this.transformExpression = transformExpression;
        this.namedArgs = namedArgs;
        this.nestedBlock = nestedBlock;
    }

    public Expression getTransformExpression() {
        return this.transformExpression;
    }

    public Map getArgs() {
        return this.namedArgs == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this.namedArgs);
    }

    @Override
    public void execute(Environment env) throws TemplateException, IOException {
        HashMap<String, TemplateModel> args;
        TemplateTransformModel ttm = env.getTransform(this.transformExpression);
        if (ttm != null) {
            args = new HashMap<String, TemplateModel>();
            if (this.namedArgs != null && !this.namedArgs.isEmpty()) {
                for (Map.Entry<String, Expression> entry : this.namedArgs.entrySet()) {
                    String key = entry.getKey();
                    Expression valueExp = entry.getValue();
                    TemplateModel value = valueExp.getAsTemplateModel(env);
                    args.put(key, value);
                }
            }
        } else {
            TemplateModel tm = this.transformExpression.getAsTemplateModel(env);
            throw TransformBlock.invalidTypeException(tm, this.transformExpression, env, "transform");
        }
        env.render(this.nestedBlock, ttm, args);
    }

    @Override
    public String getDescription() {
        return "transform " + this.transformExpression;
    }
}

