/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.Expression;
import freemarker.core.ast.TemplateElement;
import freemarker.core.parser.FMLexer;
import freemarker.core.parser.FMParser;
import freemarker.core.parser.ParseException;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;
import java.io.IOException;
import java.util.StringTokenizer;

public class StringLiteral
extends Expression
implements TemplateScalarModel {
    private TemplateElement interpolatedOutput;
    private String value;
    private boolean raw;

    public StringLiteral(String value, boolean raw) {
        this.value = value;
        this.raw = raw;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public String getValue() {
        return this.value;
    }

    public void checkInterpolation() {
        String src = this.getSource();
        if (src.length() > 5 && (src.indexOf("${") >= 0 || src.indexOf("#{") >= 0)) {
            FMLexer token_source = new FMLexer("input", this.value, FMLexer.LexicalState.DEFAULT, this.getBeginLine(), this.getBeginColumn() + 1);
            token_source.setOnlyTextOutput(true);
            FMParser parser = new FMParser(token_source);
            parser.setTemplate(this.getTemplate());
            try {
                this.interpolatedOutput = parser.FreeMarkerText();
            }
            catch (ParseException e) {
                e.setTemplateName(this.getTemplate().getName());
                throw e;
            }
            this.constantValue = null;
        }
    }

    @Override
    TemplateModel _getAsTemplateModel(Environment env) {
        return new SimpleScalar(this.getStringValue(env));
    }

    @Override
    public String getAsString() {
        return this.value;
    }

    @Override
    String getStringValue(Environment env) {
        if (this.interpolatedOutput == null) {
            return this.value;
        }
        TemplateExceptionHandler teh = env.getTemplateExceptionHandler();
        env.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        try {
            String string = env.renderElementToString(this.interpolatedOutput);
            return string;
        }
        catch (IOException ioe) {
            throw new TemplateException(ioe, env);
        }
        finally {
            env.setTemplateExceptionHandler(teh);
        }
    }

    @Override
    boolean isLiteral() {
        return this.interpolatedOutput == null;
    }

    @Override
    Expression _deepClone(String name, Expression subst) {
        StringLiteral cloned = new StringLiteral(this.value, this.raw);
        cloned.interpolatedOutput = this.interpolatedOutput;
        return cloned;
    }

    public static String escapeString(String s) {
        if (s.indexOf(34) == -1) {
            return s;
        }
        StringTokenizer st = new StringTokenizer(s, "\"", true);
        StringBuilder buf = new StringBuilder();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("\"")) {
                buf.append('\\');
            }
            buf.append(tok);
        }
        return buf.toString();
    }
}

