/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.EvaluationUtil;
import freemarker.core.ast.Expression;
import freemarker.core.ast.NonBooleanException;
import freemarker.core.ast.NumericalRange;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;

public class Range
extends Expression {
    private Expression left;
    private Expression right;

    public Range(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        left.parent = this;
        if (right != null) {
            right.parent = this;
        }
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    boolean hasRhs() {
        return this.right != null;
    }

    @Override
    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        int min = EvaluationUtil.getNumber(this.left, env).intValue();
        int max = 0;
        if (this.right != null) {
            max = EvaluationUtil.getNumber(this.right, env).intValue();
            return new NumericalRange(min, max);
        }
        return new NumericalRange(min);
    }

    @Override
    boolean isTrue(Environment env) {
        String msg = "Error " + this.getStartLocation() + ". \nExpecting a boolean here. Expression " + this + " is a range.";
        throw new NonBooleanException(msg, env);
    }

    @Override
    boolean isLiteral() {
        boolean rightIsLiteral = this.right == null || this.right.isLiteral();
        return this.constantValue != null || this.left.isLiteral() && rightIsLiteral;
    }

    @Override
    Expression _deepClone(String name, Expression subst) {
        return new Range(this.left.deepClone(name, subst), this.right.deepClone(name, subst));
    }
}

