/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.Expression;
import freemarker.core.ast.ParameterList;
import freemarker.core.ast.TemplateElement;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Param
extends TemplateElement {
    private String name;
    private ParameterList params;
    private List<Param> subParams;

    public Param(String name, ParameterList params, TemplateElement block) {
        this.name = name;
        this.params = params;
        this.nestedBlock = block;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void execute(Environment env) throws TemplateException, IOException {
        env.unqualifiedSet(this.name, new Model());
    }

    static class MultiParam
    extends Expression {
        List<Param> params = new ArrayList<Param>();

        MultiParam() {
        }

        @Override
        public Expression _deepClone(String s, Expression e) {
            return this;
        }

        @Override
        public boolean isLiteral() {
            return false;
        }

        @Override
        public TemplateModel _getAsTemplateModel(Environment env) {
            SimpleSequence result = new SimpleSequence();
            for (Param param : this.params) {
                result.add(param.new Model());
            }
            return result;
        }
    }

    public class Model
    implements TemplateModel {
    }

    class Expr
    extends Expression {
        Expr() {
        }

        @Override
        public Expression _deepClone(String s, Expression e) {
            return this;
        }

        @Override
        public boolean isLiteral() {
            return false;
        }

        @Override
        public TemplateModel _getAsTemplateModel(Environment env) {
            return new Model();
        }
    }
}

