/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class MixedContent
extends TemplateElement
implements Iterable<TemplateElement> {
    public MixedContent() {
        this.nestedElements = new ArrayList();
    }

    public void addElement(TemplateElement element) {
        this.nestedElements.add(element);
    }

    void prependElement(TemplateElement element) {
        element.setParent(this);
        ArrayList<TemplateElement> newList = new ArrayList<TemplateElement>();
        newList.add(element);
        for (TemplateElement te : this.nestedElements) {
            newList.add(te);
        }
        this.nestedElements = newList;
    }

    @Override
    public Iterator<TemplateElement> iterator() {
        return this.nestedElements.iterator();
    }

    @Override
    public void execute(Environment env) throws TemplateException, IOException {
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            TemplateElement element = (TemplateElement)this.nestedElements.get(i);
            env.render(element);
        }
    }

    @Override
    public String getDescription() {
        if (this.parent == null) {
            return "root element";
        }
        return "content";
    }

    @Override
    public boolean isIgnorable() {
        return this.nestedElements == null || this.nestedElements.size() == 0;
    }
}

