/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.TemplateNamespace;
import freemarker.core.ast.Expression;
import freemarker.core.ast.PositionalArgsList;
import freemarker.core.ast.StringLiteral;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateSequenceModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListLiteral
extends Expression {
    private final ArrayList<Expression> values;

    public ListLiteral(ArrayList<Expression> values) {
        this.values = values;
        values.trimToSize();
        for (Expression value : values) {
            value.parent = this;
        }
    }

    public List<Expression> getElements() {
        return Collections.unmodifiableList(this.values);
    }

    PositionalArgsList getAsArgsList() {
        PositionalArgsList result = new PositionalArgsList();
        for (Expression exp : this.values) {
            result.addArg(exp);
        }
        return result;
    }

    @Override
    TemplateModel _getAsTemplateModel(Environment env) {
        SimpleSequence list = new SimpleSequence(this.values.size());
        for (Expression exp : this.values) {
            TemplateModel tm = exp.getAsTemplateModel(env);
            ListLiteral.assertIsDefined(tm, exp, env);
            list.add(tm);
        }
        return list;
    }

    @Override
    boolean isLiteral() {
        if (this.constantValue != null) {
            return true;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            Expression exp = this.values.get(i);
            if (exp.isLiteral()) continue;
            return false;
        }
        return true;
    }

    TemplateSequenceModel evaluateStringsToNamespaces(Environment env) {
        TemplateSequenceModel val = (TemplateSequenceModel)this.getAsTemplateModel(env);
        SimpleSequence result = new SimpleSequence(val.size());
        for (int i = 0; i < this.values.size(); ++i) {
            if (this.values.get(i) instanceof StringLiteral) {
                String s = ((StringLiteral)this.values.get(i)).getAsString();
                try {
                    TemplateNamespace ns = env.importLib(s, null);
                    result.add(ns);
                    continue;
                }
                catch (IOException ioe) {
                    throw new TemplateException("Could not import library '" + s + "', " + ioe.getMessage(), env);
                }
            }
            result.add(val.get(i));
        }
        return result;
    }

    @Override
    Expression _deepClone(String name, Expression subst) {
        ArrayList<Expression> clonedValues = new ArrayList<Expression>(this.values.size());
        for (Expression exp : this.values) {
            clonedValues.add(exp.deepClone(name, subst));
        }
        return new ListLiteral(clonedValues);
    }
}

