/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.Expression;
import freemarker.core.ast.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;

public class Interpolation
extends TemplateElement {
    private Expression expression;
    private Expression escapedExpression;

    public Interpolation(Expression expression) {
        this.expression = expression;
        this.escapedExpression = expression;
    }

    public void setEscapedExpression(Expression escapedExpression) {
        this.escapedExpression = escapedExpression;
    }

    public Expression getEscapedExpression() {
        return this.escapedExpression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public void execute(Environment env) throws TemplateException, IOException {
        env.getOut().write(this.escapedExpression.getStringValue(env));
    }

    @Override
    public String getDescription() {
        return this.getSource() + (this.expression == this.escapedExpression ? "" : " escaped ${" + this.escapedExpression.getCanonicalForm() + "}");
    }
}

