/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.cache.TemplateCache;
import freemarker.core.Environment;
import freemarker.core.InvalidReferenceException;
import freemarker.core.ast.EvaluationUtil;
import freemarker.core.ast.Expression;
import freemarker.core.ast.NonBooleanException;
import freemarker.core.ast.StringLiteral;
import freemarker.core.ast.TemplateElement;
import freemarker.core.parser.ParseException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.StringUtil;
import freemarker.template.utility.UndeclaredThrowableException;
import java.io.IOException;

public class Include
extends TemplateElement {
    private Expression includedTemplateName;
    private Expression encodingExp;
    private Expression parseExp;
    private String encoding;
    private boolean parse;
    private String templatePath = "";
    private boolean freshNamespace;

    public Include(Template template, Expression includedTemplateName, boolean freshNamespace, Expression encodingExp, Expression parseExp) throws ParseException {
        this.freshNamespace = freshNamespace;
        if (template != null) {
            String templatePath1 = template.getName();
            int lastSlash = templatePath1.lastIndexOf(47);
            this.templatePath = lastSlash == -1 ? "" : templatePath1.substring(0, lastSlash + 1);
        }
        this.includedTemplateName = includedTemplateName;
        if (encodingExp instanceof StringLiteral) {
            this.encoding = encodingExp.toString();
            this.encoding = this.encoding.substring(1, this.encoding.length() - 1);
        } else {
            this.encodingExp = encodingExp;
        }
        if (parseExp == null) {
            this.parse = true;
        } else if (parseExp.isLiteral()) {
            try {
                if (parseExp instanceof StringLiteral) {
                    this.parse = StringUtil.getYesNo(parseExp.getStringValue(null));
                }
                try {
                    this.parse = parseExp.isTrue(null);
                }
                catch (NonBooleanException e) {
                    throw new ParseException("Expected a boolean or string as the value of the parse attribute", parseExp);
                }
            }
            catch (TemplateException e) {
                throw new UndeclaredThrowableException(e);
            }
        } else {
            this.parseExp = parseExp;
        }
    }

    public boolean isFreshNamespace() {
        return this.freshNamespace;
    }

    @Override
    public void execute(Environment env) throws TemplateException, IOException {
        Template includedTemplate;
        String templateNameString = this.includedTemplateName.getStringValue(env);
        if (templateNameString == null) {
            String msg = "Error " + this.getStartLocation() + "The expression " + this.includedTemplateName + " is undefined.";
            throw new InvalidReferenceException(msg, env);
        }
        String enc = this.encoding;
        if (this.encoding == null && this.encodingExp != null) {
            enc = this.encodingExp.getStringValue(env);
        }
        boolean parse = this.parse;
        if (this.parseExp != null) {
            TemplateModel tm = this.parseExp.getAsTemplateModel(env);
            Include.assertNonNull(tm, this.parseExp, env);
            parse = tm instanceof TemplateScalarModel ? this.getYesNo(EvaluationUtil.getString((TemplateScalarModel)tm, this.parseExp, env)) : this.parseExp.isTrue(env);
        }
        try {
            templateNameString = TemplateCache.getFullTemplatePath(env, this.templatePath, templateNameString);
            includedTemplate = env.getTemplateForInclusion(templateNameString, enc, parse);
        }
        catch (ParseException pe) {
            String msg = "Error parsing included template " + templateNameString + "\n" + pe.getMessage();
            throw new TemplateException(msg, pe, env);
        }
        catch (IOException ioe) {
            String msg = "Error reading included file " + templateNameString;
            throw new TemplateException(msg, ioe, env);
        }
        env.include(includedTemplate, this.freshNamespace);
    }

    public Expression getIncludedTemplateExpression() {
        return this.includedTemplateName;
    }

    public Expression getEncodingExp() {
        return this.encodingExp;
    }

    public Expression getParseExp() {
        return this.parseExp;
    }

    @Override
    public String getDescription() {
        String name = this.freshNamespace ? "template " : "include ";
        return name + this.includedTemplateName;
    }

    public boolean useFreshNamespace() {
        return this.freshNamespace;
    }

    private boolean getYesNo(String s) {
        try {
            return StringUtil.getYesNo(s);
        }
        catch (IllegalArgumentException iae) {
            throw new ParseException("Error " + this.getStartLocation() + "\nValue of include parse parameter must be boolean or one of these strings: \"n\", \"no\", \"f\", \"false\", \"y\", \"yes\", \"t\", \"true\"\nFound: " + this.parseExp, this.parseExp);
        }
    }
}

