/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.EvaluationUtil;
import freemarker.core.ast.Expression;
import freemarker.core.ast.NonStringException;
import freemarker.core.ast.Range;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.util.ArrayList;

public class DynamicKeyName
extends Expression {
    private Expression nameExpression;
    private Expression target;

    public DynamicKeyName(Expression target, Expression nameExpression) {
        this.target = target;
        this.nameExpression = nameExpression;
        target.parent = this;
        nameExpression.parent = this;
    }

    public Expression getNameExpression() {
        return this.nameExpression;
    }

    public Expression getTarget() {
        return this.target;
    }

    @Override
    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        TemplateModel targetModel = this.target.getAsTemplateModel(env);
        DynamicKeyName.assertNonNull(targetModel, this.target, env);
        if (this.nameExpression instanceof Range) {
            return this.dealWithRangeKey(targetModel, (Range)this.nameExpression, env);
        }
        TemplateModel keyModel = this.nameExpression.getAsTemplateModel(env);
        if (keyModel == null) {
            DynamicKeyName.assertNonNull(keyModel, this.nameExpression, env);
        }
        if (keyModel instanceof TemplateNumberModel) {
            int index = EvaluationUtil.getNumber(keyModel, this.nameExpression, env).intValue();
            return this.dealWithNumericalKey(targetModel, index, env);
        }
        if (keyModel instanceof TemplateScalarModel) {
            String key = EvaluationUtil.getString((TemplateScalarModel)keyModel, this.nameExpression, env);
            return this.dealWithStringKey(targetModel, key, env);
        }
        throw DynamicKeyName.invalidTypeException(keyModel, this.nameExpression, env, "number, range, or string");
    }

    private TemplateModel dealWithNumericalKey(TemplateModel targetModel, int index, Environment env) throws TemplateException {
        if (targetModel instanceof TemplateSequenceModel) {
            TemplateSequenceModel tsm = (TemplateSequenceModel)targetModel;
            int size = Integer.MAX_VALUE;
            try {
                size = tsm.size();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return index < size ? tsm.get(index) : null;
        }
        try {
            String s = this.target.getStringValue(env);
            try {
                return new SimpleScalar(s.substring(index, index + 1));
            }
            catch (RuntimeException re) {
                throw new TemplateException("", re, env);
            }
        }
        catch (NonStringException e) {
            throw DynamicKeyName.invalidTypeException(targetModel, this.target, env, "number, sequence, or string");
        }
    }

    private TemplateModel dealWithStringKey(TemplateModel targetModel, String key, Environment env) throws TemplateException {
        if (targetModel instanceof TemplateHashModel) {
            return ((TemplateHashModel)targetModel).get(key);
        }
        throw DynamicKeyName.invalidTypeException(targetModel, this.target, env, "hash");
    }

    private TemplateModel dealWithRangeKey(TemplateModel targetModel, Range range, Environment env) throws TemplateException {
        int start = EvaluationUtil.getNumber(range.getLeft(), env).intValue();
        int end = 0;
        boolean hasRhs = range.hasRhs();
        if (hasRhs) {
            end = EvaluationUtil.getNumber(range.getRight(), env).intValue();
        }
        if (targetModel instanceof TemplateSequenceModel) {
            TemplateSequenceModel sequence = (TemplateSequenceModel)targetModel;
            if (!hasRhs) {
                end = sequence.size() - 1;
            }
            if (start < 0) {
                String msg = range.getRight().getStartLocation() + "\nNegative starting index for range, is " + range;
                throw new TemplateException(msg, env);
            }
            if (end < 0) {
                String msg = range.getLeft().getStartLocation() + "\nNegative ending index for range, is " + range;
                throw new TemplateException(msg, env);
            }
            if (start >= sequence.size()) {
                String msg = range.getLeft().getStartLocation() + "\nLeft side index of range out of bounds, is " + start + ", but the sequence has only " + sequence.size() + " element(s) (note that indices are 0 based, and ranges are inclusive).";
                throw new TemplateException(msg, env);
            }
            if (end >= sequence.size()) {
                String msg = range.getRight().getStartLocation() + "\nRight side index of range out of bounds, is " + end + ", but the sequence has only " + sequence.size() + " element(s).(note that indices are 0 based, and ranges are inclusive).";
                throw new TemplateException(msg, env);
            }
            ArrayList<TemplateModel> list = new ArrayList<TemplateModel>(1 + Math.abs(start - end));
            if (start > end) {
                for (int i = start; i >= end; --i) {
                    list.add(sequence.get(i));
                }
            } else {
                for (int i = start; i <= end; ++i) {
                    list.add(sequence.get(i));
                }
            }
            return new SimpleSequence(list);
        }
        try {
            String s = this.target.getStringValue(env);
            if (!hasRhs) {
                end = s.length() - 1;
            }
            if (start < 0) {
                String msg = range.getLeft().getStartLocation() + "\nNegative starting index for range " + range + " : " + start;
                throw new TemplateException(msg, env);
            }
            if (end < 0) {
                String msg = range.getLeft().getStartLocation() + "\nNegative ending index for range " + range + " : " + end;
                throw new TemplateException(msg, env);
            }
            if (start > s.length()) {
                String msg = range.getLeft().getStartLocation() + "\nLeft side of range out of bounds, is: " + start + "\nbut string " + targetModel + " has " + s.length() + " elements.";
                throw new TemplateException(msg, env);
            }
            if (end > s.length()) {
                String msg = range.getRight().getStartLocation() + "\nRight side of range out of bounds, is: " + end + "\nbut string " + targetModel + " is only " + s.length() + " characters.";
                throw new TemplateException(msg, env);
            }
            try {
                return new SimpleScalar(s.substring(start, end + 1));
            }
            catch (RuntimeException re) {
                String msg = "Error " + this.getStartLocation();
                throw new TemplateException(msg, re, env);
            }
        }
        catch (NonStringException e) {
            throw DynamicKeyName.invalidTypeException(this.target.getAsTemplateModel(env), this.target, env, "number, scalar, or sequence");
        }
    }

    @Override
    boolean isLiteral() {
        return this.constantValue != null || this.target.isLiteral() && this.nameExpression.isLiteral();
    }

    @Override
    Expression _deepClone(String name, Expression subst) {
        return new DynamicKeyName(this.target.deepClone(name, subst), this.nameExpression.deepClone(name, subst));
    }
}

